/*
 * Decompiled with CFR 0.152.
 */
package com.epic_engine.mixin;

import com.epic_engine.config.EpicEngineWorldConfig;
import net.minecraft.world.level.dimension.DimensionType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DimensionType.class})
public class DimensionTypeMixin {
    @Inject(method={"height"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyWorldHeight(CallbackInfoReturnable<Integer> cir) {
        if (!((Boolean)EpicEngineWorldConfig.ENABLE_WORLD_MODIFICATIONS.get()).booleanValue()) {
            return;
        }
        int minHeight = (Integer)EpicEngineWorldConfig.MIN_BUILD_HEIGHT.get();
        int maxMountainHeight = (Integer)EpicEngineWorldConfig.MAX_MOUNTAIN_HEIGHT.get();
        int requiredHeight = maxMountainHeight - minHeight + 64;
        cir.setReturnValue((Object)requiredHeight);
    }

    @Inject(method={"minY"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyMinWorldHeight(CallbackInfoReturnable<Integer> cir) {
        if (!((Boolean)EpicEngineWorldConfig.ENABLE_WORLD_MODIFICATIONS.get()).booleanValue()) {
            return;
        }
        cir.setReturnValue((Object)((Integer)EpicEngineWorldConfig.MIN_BUILD_HEIGHT.get()));
    }

    @Inject(method={"logicalHeight"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyLogicalHeight(CallbackInfoReturnable<Integer> cir) {
        if (!((Boolean)EpicEngineWorldConfig.ENABLE_WORLD_MODIFICATIONS.get()).booleanValue()) {
            return;
        }
        int minHeight = (Integer)EpicEngineWorldConfig.MIN_BUILD_HEIGHT.get();
        int maxMountainHeight = (Integer)EpicEngineWorldConfig.MAX_MOUNTAIN_HEIGHT.get();
        int logicalHeight = Math.min(maxMountainHeight - minHeight + 32, 384);
        cir.setReturnValue((Object)logicalHeight);
    }
}

