/*
 * Decompiled with CFR 0.152.
 */
package com.epic_engine.mixin;

import com.epic_engine.config.EpicEngineCustomConfig;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelLoadingScreen.class})
public class LevelLoadingScreenMixin {
    @Unique
    private static final Logger LOGGER = LogManager.getLogger();
    @Unique
    private ResourceLocation bgId = null;
    @Unique
    private boolean bgReady = false;
    @Unique
    private String tip = "";
    @Unique
    private long lastSwap = 0L;
    @Unique
    private static final long INTERVAL = 3000L;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onInit(CallbackInfo ci) {
        if (!this.enabled()) {
            return;
        }
        EpicEngineCustomConfig.initializeResources();
        this.loadBackground();
        this.pickTip();
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void afterRender(GuiGraphics gg, int mx, int my, float pt, CallbackInfo ci) {
        if (!this.enabled()) {
            return;
        }
        int sw = Minecraft.m_91087_().m_91268_().m_85445_();
        int sh = Minecraft.m_91087_().m_91268_().m_85446_();
        if (this.bgReady) {
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gg.m_280411_(this.bgId, 0, 0, sw, sh, 0.0f, 0.0f, 1024, 1024, 1024, 1024);
        }
        this.maybeSwapTip();
        if (!this.tip.isEmpty()) {
            int color = this.parseColor((String)EpicEngineCustomConfig.LOADING_TEXT_COLOR.get());
            int w = Minecraft.m_91087_().f_91062_.m_92895_(this.tip);
            int x = (sw - w) / 2;
            int y = sh - 28;
            gg.m_280488_(Minecraft.m_91087_().f_91062_, this.tip, x + 1, y + 1, -16777216);
            gg.m_280488_(Minecraft.m_91087_().f_91062_, this.tip, x, y, color);
        }
    }

    @Unique
    private boolean enabled() {
        return (Boolean)EpicEngineCustomConfig.ENABLE_CUSTOMIZATION.get() != false && (Boolean)EpicEngineCustomConfig.ENABLE_CUSTOM_LOADING_SCREEN.get() != false;
    }

    @Unique
    private void loadBackground() {
        try {
            File file = EpicEngineCustomConfig.getTextureFile((String)EpicEngineCustomConfig.LOADING_SCREEN_BACKGROUND.get());
            if (!EpicEngineCustomConfig.fileExists(file)) {
                return;
            }
            try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                NativeImage img = NativeImage.m_85058_((InputStream)in);
                this.bgId = new ResourceLocation("epic_engine", "level_loading_bg");
                Minecraft.m_91087_().m_91097_().m_118495_(this.bgId, (AbstractTexture)new DynamicTexture(img));
                this.bgReady = true;
                LOGGER.info("Custom LevelLoading background loaded");
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load LevelLoading background", (Throwable)e);
        }
    }

    @Unique
    private void maybeSwapTip() {
        long now = System.currentTimeMillis();
        if (now - this.lastSwap < 3000L) {
            return;
        }
        this.pickTip();
        this.lastSwap = now;
    }

    @Unique
    private void pickTip() {
        List list = (List)EpicEngineCustomConfig.LOADING_TIPS.get();
        this.tip = list.isEmpty() ? "" : (String)list.get(RandomSource.m_216327_().m_188503_(list.size()));
    }

    @Unique
    private int parseColor(String c) {
        if (c == null) {
            return -1;
        }
        if (c.startsWith("#")) {
            c = c.substring(1);
        }
        try {
            if (c.length() == 6) {
                return (int)Long.parseLong("FF" + c, 16);
            }
            if (c.length() == 8) {
                return (int)Long.parseLong(c, 16);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }
}

