/*
 * Decompiled with CFR 0.152.
 */
package com.epic_engine.mixin;

import com.epic_engine.config.EpicEngineCustomConfig;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TitleScreen.class})
public class MainMenuMixin {
    @Unique
    private static final Logger epicEngine$LOGGER = LogManager.getLogger();
    @Unique
    private ResourceLocation epicEngine$customBackground = null;
    @Unique
    private ResourceLocation epicEngine$customTitle = null;
    @Unique
    private boolean epicEngine$customBackgroundLoaded = false;
    @Unique
    private boolean epicEngine$customTitleLoaded = false;
    @Unique
    private boolean epicEngine$initializeAttempted = false;
    @Unique
    private int epicEngine$titleWidth = 0;
    @Unique
    private int epicEngine$titleHeight = 0;

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void epicEngine$onInit(CallbackInfo ci) {
        epicEngine$LOGGER.info("Epic Engine: MainMenu init called! Mixin is working!");
        epicEngine$LOGGER.info("Epic Engine: Should use custom menu: {}", (Object)this.epicEngine$shouldUseCustomMainMenu());
        if (this.epicEngine$initializeAttempted) {
            return;
        }
        this.epicEngine$initializeAttempted = true;
        if (!this.epicEngine$shouldUseCustomMainMenu()) {
            return;
        }
        EpicEngineCustomConfig.initializeResources();
        this.epicEngine$loadCustomResources();
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void epicEngine$onRenderStart(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        if (!this.epicEngine$shouldUseCustomMainMenu() || !this.epicEngine$customBackgroundLoaded && !this.epicEngine$customTitleLoaded) {
            return;
        }
        if (this.epicEngine$customBackgroundLoaded) {
            this.epicEngine$renderCustomBackground(guiGraphics);
        } else {
            this.epicEngine$renderOriginalBackground(guiGraphics);
        }
        TitleScreen self = (TitleScreen)this;
        self.f_169369_.forEach(r -> r.m_88315_(guiGraphics, mouseX, mouseY, partialTicks));
        if (this.epicEngine$customTitleLoaded) {
            this.epicEngine$renderCustomTitle(guiGraphics);
        }
        ci.cancel();
    }

    @Unique
    private void epicEngine$renderCustomBackground(GuiGraphics guiGraphics) {
        int sw = Minecraft.m_91087_().m_91268_().m_85445_();
        int sh = Minecraft.m_91087_().m_91268_().m_85446_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280411_(this.epicEngine$customBackground, 0, 0, sw, sh, 0.0f, 0.0f, 1024, 1024, 1024, 1024);
    }

    @Unique
    private void epicEngine$renderOriginalBackground(GuiGraphics guiGraphics) {
        int sw = Minecraft.m_91087_().m_91268_().m_85445_();
        int sh = Minecraft.m_91087_().m_91268_().m_85446_();
        guiGraphics.m_280024_(0, 0, sw, sh, -15790301, -15790301);
    }

    @Unique
    private void epicEngine$renderCustomTitle(GuiGraphics guiGraphics) {
        try {
            int sw = Minecraft.m_91087_().m_91268_().m_85445_();
            int sh = Minecraft.m_91087_().m_91268_().m_85446_();
            int ow = Math.max(1, this.epicEngine$titleWidth);
            int oh = Math.max(1, this.epicEngine$titleHeight);
            float scale = Math.min((float)sw * 0.8f / (float)ow, (float)sh * 0.15f / (float)oh);
            scale = Math.max(scale, 0.5f);
            int drawW = (int)((float)ow * scale);
            int drawH = (int)((float)oh * scale);
            int x = (sw - drawW) / 2;
            int y = 30;
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
            guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280163_(this.epicEngine$customTitle, 0, 0, 0.0f, 0.0f, ow, oh, ow, oh);
            guiGraphics.m_280168_().m_85849_();
        }
        catch (Exception e) {
            epicEngine$LOGGER.error("Error rendering custom title", (Throwable)e);
        }
    }

    @Unique
    private void epicEngine$loadCustomResources() {
        try {
            NativeImage img;
            File titleFile;
            NativeImage img2;
            File bgFile;
            File cfgDir = new File(FMLPaths.CONFIGDIR.get().toFile(), "epic_engine");
            if (!cfgDir.exists()) {
                cfgDir.mkdirs();
            }
            if (EpicEngineCustomConfig.fileExists(bgFile = EpicEngineCustomConfig.getTextureFile((String)EpicEngineCustomConfig.MAIN_MENU_BACKGROUND.get())) && (img2 = this.epicEngine$readImage(bgFile)) != null) {
                this.epicEngine$customBackground = new ResourceLocation("epic_engine", "custom_background");
                Minecraft.m_91087_().m_91097_().m_118495_(this.epicEngine$customBackground, (AbstractTexture)new DynamicTexture(img2));
                this.epicEngine$customBackgroundLoaded = true;
            }
            if (EpicEngineCustomConfig.fileExists(titleFile = EpicEngineCustomConfig.getTextureFile((String)EpicEngineCustomConfig.MAIN_MENU_TITLE_IMAGE.get())) && (img = this.epicEngine$readImage(titleFile)) != null) {
                this.epicEngine$titleWidth = img.m_84982_();
                this.epicEngine$titleHeight = img.m_85084_();
                this.epicEngine$customTitle = new ResourceLocation("epic_engine", "custom_title");
                Minecraft.m_91087_().m_91097_().m_118495_(this.epicEngine$customTitle, (AbstractTexture)new DynamicTexture(img));
                this.epicEngine$customTitleLoaded = true;
            }
        }
        catch (Exception e) {
            epicEngine$LOGGER.error("Error loading custom resources", (Throwable)e);
        }
    }

    @Unique
    private NativeImage epicEngine$readImage(File file) {
        NativeImage nativeImage;
        block8: {
            InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
            try {
                nativeImage = NativeImage.m_85058_((InputStream)in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    epicEngine$LOGGER.error("Failed to read image: {}", (Object)file.getPath(), (Object)e);
                    return null;
                }
            }
            in.close();
        }
        return nativeImage;
    }

    @Unique
    private boolean epicEngine$shouldUseCustomMainMenu() {
        return (Boolean)EpicEngineCustomConfig.ENABLE_CUSTOMIZATION.get() != false && (Boolean)EpicEngineCustomConfig.ENABLE_CUSTOM_MAIN_MENU.get() != false;
    }
}

