/*
 * Decompiled with CFR 0.152.
 */
package com.epic_engine.mixin;

import com.epic_engine.config.EpicEngineWorldConfig;
import com.epic_engine.world.EnhancedMountainDensityFunction;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseRouter;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NoiseRouter.class})
public class NoiseRouterMixin {
    @Inject(method={"initialDensityWithoutJaggedness"}, at={@At(value="RETURN")}, cancellable=true)
    private void wrapInitialDensity(CallbackInfoReturnable<DensityFunction> cir) {
        if (!((Boolean)EpicEngineWorldConfig.ENABLE_WORLD_MODIFICATIONS.get()).booleanValue()) {
            return;
        }
        DensityFunction original = (DensityFunction)cir.getReturnValue();
        cir.setReturnValue((Object)new EnhancedMountainDensityFunction(original));
    }

    @Inject(method={"finalDensity"}, at={@At(value="RETURN")}, cancellable=true)
    private void wrapFinalDensity(CallbackInfoReturnable<DensityFunction> cir) {
        if (!((Boolean)EpicEngineWorldConfig.ENABLE_WORLD_MODIFICATIONS.get()).booleanValue()) {
            return;
        }
        DensityFunction original = (DensityFunction)cir.getReturnValue();
        cir.setReturnValue((Object)new EnhancedMountainDensityFunction(original));
    }

    @Inject(method={"depth"}, at={@At(value="RETURN")}, cancellable=true)
    private void wrapDepth(CallbackInfoReturnable<DensityFunction> cir) {
        if (!((Boolean)EpicEngineWorldConfig.ENABLE_WORLD_MODIFICATIONS.get()).booleanValue()) {
            return;
        }
        cir.setReturnValue((Object)new EnhancedMountainDensityFunction((DensityFunction)cir.getReturnValue()));
    }

    @Inject(method={"ridges"}, at={@At(value="RETURN")}, cancellable=true)
    private void wrapRidges(CallbackInfoReturnable<DensityFunction> cir) {
        if (!((Boolean)EpicEngineWorldConfig.ENABLE_WORLD_MODIFICATIONS.get()).booleanValue()) {
            return;
        }
        cir.setReturnValue((Object)new EnhancedMountainDensityFunction((DensityFunction)cir.getReturnValue()));
    }
}

