/*
 * Decompiled with CFR 0.152.
 */
package com.epic_engine.mixin;

import com.epic_engine.config.EpicEngineWorldConfig;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.levelgen.NoiseSettings;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NoiseSettings.class})
public class NoiseSettingsMixin {
    @Inject(method={"clampToHeightAccessor"}, at={@At(value="RETURN")}, cancellable=true)
    private void onClampToHeightAccessor(LevelHeightAccessor heightAccessor, CallbackInfoReturnable<NoiseSettings> cir) {
        if (!((Boolean)EpicEngineWorldConfig.ENABLE_WORLD_MODIFICATIONS.get()).booleanValue()) {
            return;
        }
        NoiseSettings orig = (NoiseSettings)cir.getReturnValue();
        int newMinY = (Integer)EpicEngineWorldConfig.MIN_BUILD_HEIGHT.get();
        int newHeight = (Integer)EpicEngineWorldConfig.MAX_MOUNTAIN_HEIGHT.get() - (Integer)EpicEngineWorldConfig.MIN_BUILD_HEIGHT.get() + 64;
        NoiseSettings tweaked = new NoiseSettings(newMinY, newHeight, orig.f_64512_(), orig.f_64513_());
        cir.setReturnValue((Object)tweaked);
    }
}

