/*
 * Decompiled with CFR 0.152.
 */
package com.epic_engine.mixin;

import com.epic_engine.config.EpicEngineCustomConfig;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public class TitleMixin {
    @Unique
    private static final Logger epicEngine$LOGGER = LogManager.getLogger();

    @Inject(method={"updateTitle"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUpdateTitle(CallbackInfo ci) {
        epicEngine$LOGGER.info("Epic Engine: TitleMixin activated - updateTitle called!");
        epicEngine$LOGGER.info("Epic Engine: Should use custom title: {}", (Object)this.epicEngine$shouldUseCustomTitle());
        if (this.epicEngine$shouldUseCustomTitle()) {
            epicEngine$LOGGER.info("Epic Engine: Applying custom title...");
            this.epicEngine$applyOurCustomTitle();
            ci.cancel();
            epicEngine$LOGGER.info("Epic Engine: Custom title applied and original method cancelled");
        } else {
            epicEngine$LOGGER.info("Epic Engine: Using default title");
        }
    }

    @Inject(method={"updateTitle"}, at={@At(value="RETURN")})
    private void afterUpdateTitle(CallbackInfo ci) {
        if (this.epicEngine$shouldUseCustomTitle()) {
            epicEngine$LOGGER.info("Epic Engine: Re-applying custom title after original updateTitle");
            this.epicEngine$applyOurCustomTitle();
        }
    }

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    private void onConstructed(CallbackInfo ci) {
        epicEngine$LOGGER.info("Epic Engine: TitleMixin - Minecraft constructor finished!");
        Minecraft minecraft = (Minecraft)this;
        minecraft.m_6937_(() -> {
            epicEngine$LOGGER.info("Epic Engine: Applying custom title via Minecraft.tell()");
            this.epicEngine$applyOurCustomTitle();
        });
    }

    @Unique
    private boolean epicEngine$shouldUseCustomTitle() {
        try {
            boolean customizationEnabled = (Boolean)EpicEngineCustomConfig.ENABLE_CUSTOMIZATION.get();
            boolean titleEnabled = (Boolean)EpicEngineCustomConfig.ENABLE_CUSTOM_WINDOW_TITLE.get();
            epicEngine$LOGGER.debug("Epic Engine: Customization enabled: {}, Title enabled: {}", (Object)customizationEnabled, (Object)titleEnabled);
            return customizationEnabled && titleEnabled;
        }
        catch (Exception e) {
            epicEngine$LOGGER.error("Epic Engine: Error checking custom title config", (Throwable)e);
            return false;
        }
    }

    @Unique
    private void epicEngine$applyOurCustomTitle() {
        try {
            Minecraft minecraft = (Minecraft)this;
            if (minecraft.m_91268_() != null && this.epicEngine$shouldUseCustomTitle()) {
                String customTitle = this.epicEngine$getCustomTitle();
                epicEngine$LOGGER.info("Epic Engine: Setting window title to: '{}'", (Object)customTitle);
                if (customTitle != null && !customTitle.isEmpty()) {
                    minecraft.m_91268_().m_85422_(customTitle);
                    epicEngine$LOGGER.info("Epic Engine: Window title successfully set!");
                } else {
                    epicEngine$LOGGER.warn("Epic Engine: Custom title is null or empty");
                }
            } else if (minecraft.m_91268_() == null) {
                epicEngine$LOGGER.warn("Epic Engine: Window is null, cannot set title");
            } else {
                epicEngine$LOGGER.info("Epic Engine: Custom title disabled, skipping");
            }
        }
        catch (Exception e) {
            epicEngine$LOGGER.error("Epic Engine: Failed to apply custom title", (Throwable)e);
        }
    }

    @Unique
    private String epicEngine$getCustomTitle() {
        try {
            String title = (String)EpicEngineCustomConfig.CUSTOM_WINDOW_TITLE.get();
            epicEngine$LOGGER.debug("Epic Engine: Retrieved custom title from config: '{}'", (Object)title);
            return title;
        }
        catch (Exception e) {
            epicEngine$LOGGER.error("Epic Engine: Error getting custom title from config", (Throwable)e);
            return "Epic Engine";
        }
    }
}

