/*
 * Decompiled with CFR 0.152.
 */
package com.epic_engine.world;

import com.epic_engine.config.EpicEngineWorldConfig;
import com.epic_engine.world.BiomeContext;
import com.epic_engine.world.PerlinNoise;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.jetbrains.annotations.NotNull;

public class EnhancedMountainDensityFunction
implements DensityFunction {
    private final DensityFunction original;
    private static final TagKey<Biome> MOUNTAIN_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("minecraft", "is_mountain"));
    private static final String JAGGED_PEAKS_ID = "minecraft:jagged_peaks";
    private static final Set<String> PLAINS_BIOMES = Set.of("minecraft:plains", "minecraft:sunflower_plains");
    private static final String MEADOW_ID = "minecraft:meadow";
    private static final Map<Long, Integer> BIOME_BASE_HEIGHTS = new HashMap<Long, Integer>();

    public EnhancedMountainDensityFunction(DensityFunction original) {
        this.original = original;
    }

    public double m_207386_(@NotNull DensityFunction.FunctionContext ctx) {
        if (!((Boolean)EpicEngineWorldConfig.ENABLE_WORLD_MODIFICATIONS.get()).booleanValue()) {
            return this.original.m_207386_(ctx);
        }
        double val = this.original.m_207386_(ctx);
        int x = ctx.m_207115_();
        int y = ctx.m_207114_();
        int z = ctx.m_207113_();
        return EnhancedMountainDensityFunction.enhanceTerrain(val, x, y, z);
    }

    public void m_207362_(double @NotNull [] array, @NotNull DensityFunction.ContextProvider prov) {
        if (!((Boolean)EpicEngineWorldConfig.ENABLE_WORLD_MODIFICATIONS.get()).booleanValue()) {
            this.original.m_207362_(array, prov);
            return;
        }
        this.original.m_207362_(array, prov);
        for (int i = 0; i < array.length; ++i) {
            DensityFunction.FunctionContext ctx = prov.m_207263_(i);
            int x = ctx.m_207115_();
            int y = ctx.m_207114_();
            int z = ctx.m_207113_();
            array[i] = EnhancedMountainDensityFunction.enhanceTerrain(array[i], x, y, z);
        }
    }

    private static double getMountainRangeControl(int x, int z) {
        double frequency = (Double)EpicEngineWorldConfig.MOUNTAIN_RANGE_SCALE.get();
        double noise = PerlinNoise.fractalNoise((double)x * frequency, 0.0, (double)z * frequency, 3, 0.6);
        return (noise + 1.0) * 0.5;
    }

    private static double getRidgeControl(int x, int z) {
        double freq1 = 0.002;
        double freq2 = 0.0015;
        double ridge1 = 1.0 - Math.abs(PerlinNoise.noise((double)x * freq1, 0.0, (double)z * freq1));
        double ridge2 = 1.0 - Math.abs(PerlinNoise.noise((double)x * freq2, 0.0, (double)z * freq2 + 100.0));
        return Math.max(ridge1, ridge2);
    }

    private static long getBiomeRegionKey(int x, int z, int regionSize) {
        long regionX = Math.floorDiv(x, regionSize);
        long regionZ = Math.floorDiv(z, regionSize);
        return regionX << 32 | regionZ & 0xFFFFFFFFL;
    }

    private static int getPlainBaseHeight(int x, int z, boolean isMeadow) {
        int targetHeight;
        boolean nearMountains;
        int regionSize = isMeadow ? 128 : 256;
        long regionKey = EnhancedMountainDensityFunction.getBiomeRegionKey(x, z, regionSize);
        if (BIOME_BASE_HEIGHTS.containsKey(regionKey)) {
            return BIOME_BASE_HEIGHTS.get(regionKey);
        }
        int baseHeight = 63;
        int maxVariation = (Integer)EpicEngineWorldConfig.PLAINS_MAX_HEIGHT_VARIATION.get();
        boolean bl = nearMountains = EnhancedMountainDensityFunction.getMountainProximityFactor(x, z) > 0.3;
        if (isMeadow || nearMountains) {
            variation = maxVariation / 2;
            targetHeight = baseHeight - variation;
        } else {
            variation = maxVariation / 2;
            targetHeight = baseHeight + variation;
        }
        int hashCode = Long.hashCode(regionKey);
        int smallVariation = Math.abs(hashCode % (maxVariation + 1));
        targetHeight = isMeadow || nearMountains ? (targetHeight -= smallVariation / 3) : (targetHeight += smallVariation / 3);
        BIOME_BASE_HEIGHTS.put(regionKey, targetHeight);
        return targetHeight;
    }

    private static double cutFlattenPlainsTerrain(double v, int x, int y, int z, String biomeId) {
        boolean isPlainsType = EnhancedMountainDensityFunction.isPlainsBiome(biomeId);
        boolean isMeadow = EnhancedMountainDensityFunction.isMeadowBiome(biomeId);
        if (!isPlainsType && !isMeadow) {
            return v;
        }
        int baseHeight = EnhancedMountainDensityFunction.getPlainBaseHeight(x, z, isMeadow);
        if (y > baseHeight) {
            return -1.0;
        }
        int surfaceDepth = 4;
        if (((Boolean)EpicEngineWorldConfig.PLAINS_FILL_SURFACE_CAVES.get()).booleanValue() && y <= baseHeight && y > baseHeight - surfaceDepth && v < 0.0) {
            return 0.2;
        }
        return v;
    }

    private static double getMountainProximityFactor(int x, int z) {
        double mountainValue = EnhancedMountainDensityFunction.getMountainRangeControl(x, z);
        double proximity = Math.max(0.0, 1.0 - Math.abs(mountainValue - 0.4) * 2.5);
        return Math.pow(proximity, 1.5);
    }

    private static boolean isPlainsBiome(String biomeId) {
        return PLAINS_BIOMES.contains(biomeId);
    }

    private static boolean isMeadowBiome(String biomeId) {
        return MEADOW_ID.equals(biomeId);
    }

    private static double enhanceTerrain(double v, int x, int y, int z) {
        Holder<Biome> currentBiome = BiomeContext.CURRENT.get();
        boolean isJaggedPeaks = false;
        String biomeId = "";
        if (currentBiome != null && currentBiome.m_203543_().isPresent()) {
            biomeId = ((ResourceKey)currentBiome.m_203543_().get()).m_135782_().toString();
            if (EnhancedMountainDensityFunction.isPlainsBiome(biomeId) || EnhancedMountainDensityFunction.isMeadowBiome(biomeId)) {
                return EnhancedMountainDensityFunction.cutFlattenPlainsTerrain(v, x, y, z, biomeId);
            }
            if (currentBiome.m_203656_(MOUNTAIN_TAG)) {
                isJaggedPeaks = JAGGED_PEAKS_ID.equals(biomeId);
                double factor = 1.0;
                if (y < (Integer)EpicEngineWorldConfig.BASE_TERRAIN_HEIGHT_LIMIT.get()) {
                    factor = (Double)EpicEngineWorldConfig.BASE_TERRAIN_FACTOR.get();
                }
                double rangeControl = EnhancedMountainDensityFunction.getMountainRangeControl(x, z);
                double ridgeControl = EnhancedMountainDensityFunction.getRidgeControl(x, z);
                double continuityThreshold = 0.4 * (1.0 - (Double)EpicEngineWorldConfig.MOUNTAIN_CONTINUITY.get());
                if (rangeControl > continuityThreshold) {
                    double mountainFactor;
                    double rangeStrength = Math.min(1.0, (rangeControl - continuityThreshold) / (1.0 - continuityThreshold));
                    if (y < (Integer)EpicEngineWorldConfig.MOUNTAIN_LOW_THRESHOLD.get()) {
                        mountainFactor = (Double)EpicEngineWorldConfig.MOUNTAIN_LOW_FACTOR.get();
                    } else if (y < (Integer)EpicEngineWorldConfig.MOUNTAIN_MID_THRESHOLD.get()) {
                        mountainFactor = (Double)EpicEngineWorldConfig.MOUNTAIN_MID_FACTOR.get();
                    } else {
                        mountainFactor = (Double)EpicEngineWorldConfig.MOUNTAIN_HIGH_FACTOR.get();
                        double heightScale = (double)(y - (Integer)EpicEngineWorldConfig.MOUNTAIN_MID_THRESHOLD.get()) / 128.0;
                        mountainFactor *= 1.0 + Math.min(0.5, heightScale * 0.3);
                    }
                    double ridgeThreshold = 0.65;
                    if (ridgeControl > ridgeThreshold && y > (Integer)EpicEngineWorldConfig.MOUNTAIN_LOW_THRESHOLD.get()) {
                        double ridgeStrength = (ridgeControl - ridgeThreshold) / (1.0 - ridgeThreshold);
                        double ridgeBoost = 1.0 + ridgeStrength * (Double)EpicEngineWorldConfig.RIDGE_STRENGTH.get();
                        mountainFactor *= ridgeBoost;
                    }
                    if (isJaggedPeaks) {
                        mountainFactor *= ((Double)EpicEngineWorldConfig.JAGGED_PEAKS_EXTRA_FACTOR.get()).doubleValue();
                        if (y > (Integer)EpicEngineWorldConfig.MOUNTAIN_MID_THRESHOLD.get()) {
                            double heightAboveThreshold = y - (Integer)EpicEngineWorldConfig.MOUNTAIN_MID_THRESHOLD.get();
                            double maxMountainHeight = ((Integer)EpicEngineWorldConfig.MAX_MOUNTAIN_HEIGHT.get()).intValue();
                            double progress = Math.min(1.0, heightAboveThreshold / (maxMountainHeight * 0.7));
                            double boostFactor = 1.0 + progress * 0.8;
                            mountainFactor *= boostFactor;
                        }
                        if (ridgeControl > 0.8 && y > (Integer)EpicEngineWorldConfig.MOUNTAIN_MID_THRESHOLD.get()) {
                            mountainFactor *= 1.2;
                        }
                    }
                    factor = mountainFactor = factor + (mountainFactor - factor) * rangeStrength;
                } else {
                    double transitionFactor = 1.0 + ((Double)EpicEngineWorldConfig.MOUNTAIN_LOW_FACTOR.get() - 1.0) * (rangeControl / continuityThreshold);
                    factor = Math.max(factor, transitionFactor);
                }
                double maxRatio = (double)((Integer)EpicEngineWorldConfig.MAX_MOUNTAIN_HEIGHT.get()).intValue() / (double)EpicEngineWorldConfig.calculateMaxBuildHeight();
                return Mth.m_14008_((double)(v * factor), (double)(-2.0 * maxRatio), (double)(2.0 * maxRatio));
            }
        }
        return v;
    }

    public double m_207402_() {
        return this.original.m_207402_();
    }

    public double m_207401_() {
        return this.original.m_207401_();
    }

    @NotNull
    public DensityFunction m_207456_(DensityFunction.Visitor visitor) {
        return visitor.m_214017_((DensityFunction)new EnhancedMountainDensityFunction(this.original.m_207456_(visitor)));
    }

    @NotNull
    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return KeyDispatchDataCodec.m_216238_((MapCodec)MapCodec.unit((Object)this));
    }
}

