/*
 * Decompiled with CFR 0.152.
 */
package net.myr.createmechanicalcompanion.item;

import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemStackHandler;
import net.myr.createmechanicalcompanion.entity.CustomWolf;
import net.myr.createmechanicalcompanion.entity.ModEntity;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class MechanicalWolfLink
extends Item
implements ICurioItem {
    private CompoundTag previousModuleTag;

    public MechanicalWolfLink(Item.Properties properties) {
        super(properties);
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        LivingEntity playerEntity = slotContext.entity();
        if (!(playerEntity instanceof Player)) {
            return false;
        }
        Player player = (Player)playerEntity;
        ICuriosItemHandler curiosInventory = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)playerEntity).orElse(null);
        if (curiosInventory == null) {
            return true;
        }
        ICurioStacksHandler headSlotHandler = (ICurioStacksHandler)curiosInventory.getCurios().get("head");
        if (headSlotHandler == null) {
            return false;
        }
        for (int i = 0; i < headSlotHandler.getSlots(); ++i) {
            ItemStack itemStack = headSlotHandler.getStacks().getStackInSlot(i);
            if (!(itemStack.m_41720_() instanceof MechanicalWolfLink)) continue;
            player.m_5661_((Component)Component.m_237115_((String)"item.createmechanicalcompanion.mechanical_wolf_link.duplicate_warning"), true);
            return false;
        }
        return true;
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        Level level = entity.m_9236_();
        CompoundTag tag = stack.m_41784_();
        if (!level.f_46443_ && tag.m_128441_("WolfUUID") && newStack.m_41720_().equals(Items.f_41852_)) {
            this.dismissWolf(level, tag);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity;
        Level level = slotContext.entity().m_9236_();
        if (level.f_46443_ || !((livingEntity = slotContext.entity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("WolfUUID")) {
            UUID wolfUUID = tag.m_128342_("WolfUUID");
            CustomWolf entity = (CustomWolf)((ServerLevel)level).m_8791_(wolfUUID);
            if (entity == null) {
                this.summonWolf(level, player, tag);
                return;
            }
            if (entity.m_21223_() <= 0.0f) {
                tag.m_128405_("SpawnCooldown", 200);
            }
            if (entity.m_7770_() != null) {
                String wolfName = entity.m_7770_().getString();
                tag.m_128359_("Nametag", wolfName);
            }
            this.saveWolfModulesToTrinket(tag, entity.getItemHandler());
        } else {
            this.summonWolf(level, player, tag);
        }
    }

    private void summonWolf(Level level, Player player, CompoundTag tag) {
        if (tag.m_128441_("SpawnCooldown")) {
            int spawnCooldown = tag.m_128451_("SpawnCooldown");
            if (--spawnCooldown == 0) {
                tag.m_128473_("SpawnCooldown");
            } else {
                tag.m_128405_("SpawnCooldown", spawnCooldown);
            }
            return;
        }
        CustomWolf newWolf = new CustomWolf((EntityType<? extends Wolf>)((EntityType)ModEntity.CUSTOM_WOLF.get()), level);
        newWolf.m_21828_(player);
        newWolf.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
        level.m_7967_((Entity)newWolf);
        if (tag.m_128441_("Nametag")) {
            newWolf.m_6593_((Component)Component.m_237113_((String)tag.m_128461_("Nametag")));
        }
        ItemStackHandler wolfInventory = this.loadWolfModulesFromTrinket(tag, newWolf.getItemHandler().getSlots());
        newWolf.setItemHandler(wolfInventory);
        tag.m_128362_("WolfUUID", newWolf.m_20148_());
    }

    private void dismissWolf(Level level, CompoundTag tag) {
        if (tag != null && tag.m_128403_("WolfUUID")) {
            UUID wolfUUID = tag.m_128342_("WolfUUID");
            Entity entity = ((ServerLevel)level).m_8791_(wolfUUID);
            if (entity instanceof CustomWolf) {
                CustomWolf wolf = (CustomWolf)entity;
                this.saveWolfModulesToTrinket(tag, wolf.getItemHandler());
                wolf.m_146870_();
            }
            tag.m_128473_("WolfUUID");
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return super.initCapabilities(stack, nbt);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        CompoundTag tag = pStack.m_41783_();
        if (Screen.m_96638_()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.createmechanicalcompanion.shift2"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.createmechanicalcompanion.mechanical_wolf_link.tooltip"));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.createmechanicalcompanion.shift"));
        }
        if (tag != null && tag.m_128441_("SpawnCooldown")) {
            int cooldownTicks = tag.m_128451_("SpawnCooldown");
            int seconds = cooldownTicks / 20;
            pTooltipComponents.add((Component)Component.m_237113_((String)("\u00a77Spawn Cooldown: \u00a7c" + seconds + "s")));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public void saveWolfModulesToTrinket(CompoundTag tag, ItemStackHandler handler) {
        if (tag == null || handler == null) {
            return;
        }
        CompoundTag serialized = handler.serializeNBT();
        if (serialized.equals((Object)this.previousModuleTag)) {
            return;
        }
        tag.m_128365_("WolfModules", (Tag)serialized);
        this.previousModuleTag = serialized;
    }

    public ItemStackHandler loadWolfModulesFromTrinket(CompoundTag tag, int size) {
        ItemStackHandler handler = new ItemStackHandler(size);
        if (tag != null && tag.m_128441_("WolfModules")) {
            CompoundTag serialized = tag.m_128469_("WolfModules");
            handler.deserializeNBT(serialized);
        }
        return handler;
    }
}

