#########################################
#					#
#	Vanilla Replays by Youly	#
#					#
#########################################




	# POS & ROTATION

$execute unless data entity @s sleeping_pos run data modify storage vanilla_replays:record_$(id) frame.$(frame).Pos set from entity @s Pos
$execute unless data entity @s sleeping_pos run data modify storage vanilla_replays:record_$(id) frame.$(frame).Rotation set from entity @s Rotation


	# INIT DATA

$execute if score @s vanilla_replays.frame matches 0 run data modify storage vanilla_replays:record_$(id) frame.$(frame).pose set value "standing"
$execute if score @s[predicate=vanilla_replays:swimming] vanilla_replays.frame matches 0 run data modify storage vanilla_replays:record_$(id) frame.$(frame).pose set value "swimming"
$execute if score @s vanilla_replays.frame matches 0 if function vanilla_replays:record/crouching/true run data modify storage vanilla_replays:record_$(id) frame.$(frame).pose set value "crouching"
$execute if score @s vanilla_replays.frame matches 0 if function vanilla_replays:record/crawling/true run data modify storage vanilla_replays:record_$(id) frame.$(frame).pose set value "swimming"
$execute if score @s vanilla_replays.frame matches 0 if function vanilla_replays:record/sleeping/true run data modify storage vanilla_replays:record_$(id) frame.$(frame).pose set value "sleeping"
$execute if score @s vanilla_replays.frame matches 0 if function vanilla_replays:record/sleeping/true run data modify storage vanilla_replays:record_$(id) frame.$(frame).sleeping_pos set from entity @s sleeping_pos
$execute if score @s vanilla_replays.frame matches 0 if entity @s[nbt={FallFlying:1b}] run data modify storage vanilla_replays:record_$(id) frame.$(frame).FallFlying set value 1b
$execute if score @s vanilla_replays.frame matches 0 if data entity @s RootVehicle run data modify storage vanilla_replays:record_$(id) frame.$(frame).riding set value 1b
$execute if score @s vanilla_replays.frame matches 0 run function vanilla_replays:record/potion_effects/record {id:$(id),frame:$(frame)}


	# RESPAWN / FIRE / HURT

$execute if entity @s[scores={vanilla_replays.lifetime=1}] run data modify storage vanilla_replays:record_$(id) frame.$(frame).respawning set value 1b

$execute if entity @s[nbt=!{HurtTime:0s},scores={vanilla_replays.lifetime=1..}] run data modify storage vanilla_replays:record_$(id) frame.$(frame).hurting set value 1b
$execute if entity @s[nbt=!{Fire:-20s},scores={vanilla_replays.lifetime=1..}] run data modify storage vanilla_replays:record_$(id) frame.$(frame).Fire set from entity @s Fire
$execute if entity @s[scores={vanilla_replays.lifetime=..0}] run data modify storage vanilla_replays:record_$(id) frame.$(frame).Fire set value 0b


	# DYING EFFECT

execute store result score .gamerule.doImmediateRespawn vanilla_replays.values run gamerule doImmediateRespawn
execute store result score .gamerule.keepInventory vanilla_replays.values run gamerule keepInventory

$execute if score .gamerule.doImmediateRespawn vanilla_replays.values matches 0 if entity @s[scores={vanilla_replays.die=1..}] run data modify storage vanilla_replays:record_$(id) frame.$(frame).dying set value 1b
$execute if score .gamerule.doImmediateRespawn vanilla_replays.values matches 1 if entity @s[scores={vanilla_replays.die=1..}] run data modify storage vanilla_replays:record_$(id) frame.$(frame).unfire set value 1b
$execute if score .gamerule.doImmediateRespawn vanilla_replays.values matches 0 if entity @s[scores={vanilla_replays.die=1..}] run data remove storage vanilla_replays:record_$(id) frame.$(frame).Fire
$execute if score .gamerule.doImmediateRespawn vanilla_replays.values matches 0 if entity @s[scores={vanilla_replays.die=1..}] run data modify storage vanilla_replays:record_$(id) frame.$(frame).Motion set from entity @s Motion

$execute if score .gamerule.doImmediateRespawn vanilla_replays.values matches 1 if entity @s[scores={vanilla_replays.die=1..}] run data modify storage vanilla_replays:record_$(id) frame.$(frame).hurting set value 1b
$execute if score .gamerule.keepInventory vanilla_replays.values matches 0 if entity @s[scores={vanilla_replays.die=1..}] run data modify storage vanilla_replays:record_$(id) frame.$(frame).clear set value 1b
$execute if score .gamerule.keepInventory vanilla_replays.values matches 0 if entity @s[scores={vanilla_replays.die=1..}] run function vanilla_replays:record/equipped_items/record {id:$(id),frame:$(frame)}

scoreboard players reset .gamerule.doImmediateRespawn vanilla_replays.values
scoreboard players reset .gamerule.keepInventory vanilla_replays.values


	# POSE

# swimming

$execute if entity @s[tag=!vanilla_replays.swimming] if predicate vanilla_replays:swimming run data modify storage vanilla_replays:record_$(id) frame.$(frame).pose set value "swimming"
execute if predicate vanilla_replays:swimming run tag @s add vanilla_replays.swimming
$execute if entity @s[tag=vanilla_replays.swimming] unless predicate vanilla_replays:swimming run data modify storage vanilla_replays:record_$(id) frame.$(frame).pose set value "standing"
execute unless predicate vanilla_replays:swimming run tag @s remove vanilla_replays.swimming

# crouching

$execute if entity @s[tag=!vanilla_replays.crouching] if function vanilla_replays:record/crouching/true run data modify storage vanilla_replays:record_$(id) frame.$(frame).pose set value "crouching"
execute if function vanilla_replays:record/crouching/true run tag @s add vanilla_replays.crouching
$execute if entity @s[tag=vanilla_replays.crouching] unless function vanilla_replays:record/crouching/true run data modify storage vanilla_replays:record_$(id) frame.$(frame).pose set value "standing"
execute unless function vanilla_replays:record/crouching/true run tag @s remove vanilla_replays.crouching

# crawling

$execute if entity @s[tag=!vanilla_replays.crawling] if function vanilla_replays:record/crawling/true run data modify storage vanilla_replays:record_$(id) frame.$(frame).pose set value "swimming"
execute if function vanilla_replays:record/crawling/true run tag @s add vanilla_replays.crawling
$execute if entity @s[tag=vanilla_replays.crawling] unless function vanilla_replays:record/crawling/true run data modify storage vanilla_replays:record_$(id) frame.$(frame).pose set value "standing"
execute unless function vanilla_replays:record/crawling/true run tag @s remove vanilla_replays.crawling

# sleeping

$execute if function vanilla_replays:record/sleeping/true run data modify storage vanilla_replays:record_$(id) frame.$(frame).sleeping_pos set from entity @s sleeping_pos
execute if function vanilla_replays:record/sleeping/true run tag @s add vanilla_replays.sleeping
$execute if entity @s[tag=vanilla_replays.sleeping] unless function vanilla_replays:record/sleeping/true run data modify storage vanilla_replays:record_$(id) frame.$(frame).pose set value "standing"
execute unless function vanilla_replays:record/sleeping/true run tag @s remove vanilla_replays.sleeping

# riding

$execute if entity @s[tag=!vanilla_replays.riding] if data entity @s RootVehicle run data modify storage vanilla_replays:record_$(id) frame.$(frame).riding set value 1b
execute if data entity @s RootVehicle run tag @s add vanilla_replays.riding
$execute if entity @s[tag=vanilla_replays.riding] unless data entity @s RootVehicle run data modify storage vanilla_replays:record_$(id) frame.$(frame).dismounting set value 1b
execute unless data entity @s RootVehicle run tag @s remove vanilla_replays.riding

# fallflying

$execute if entity @s[tag=!vanilla_replays.crawling] if entity @s[nbt={FallFlying:1b}] run data modify storage vanilla_replays:record_$(id) frame.$(frame).FallFlying set value 1b
execute if entity @s[nbt={FallFlying:1b}] run tag @s add vanilla_replays.gliding
$execute if entity @s[tag=vanilla_replays.gliding] unless entity @s[nbt={FallFlying:1b}] run data modify storage vanilla_replays:record_$(id) frame.$(frame).FallFlying set value 0b
execute unless entity @s[nbt={FallFlying:1b}] run tag @s remove vanilla_replays.gliding


	# SPECTATOR INVISIBILITY

$execute if entity @s[tag=!vanilla_replays.spectating] if entity @s[gamemode=spectator] run data modify storage vanilla_replays:record_$(id) frame.$(frame).spectating set value 1b
execute if entity @s[gamemode=spectator] run tag @s add vanilla_replays.spectating
$execute if entity @s[tag=vanilla_replays.spectating] unless entity @s[gamemode=spectator] run data modify storage vanilla_replays:record_$(id) frame.$(frame).spectating set value 0b
execute unless entity @s[gamemode=spectator] run tag @s remove vanilla_replays.spectating


	# APPLIED EFFECTS & VISUALS

$execute if entity @s[advancements={vanilla_replays:effects_changed=true}] if score @s vanilla_replays.lifetime matches 1.. run function vanilla_replays:record/potion_effects/record {id:$(id),frame:$(frame)}

$execute if entity @s[advancements={vanilla_replays:used_totem=true}] if score @s vanilla_replays.lifetime matches 1.. run data modify storage vanilla_replays:record_$(id) frame.$(frame).using_totem set value 1b


	# USING ITEM & HIT BY PROJECTILE

$execute if entity @s[advancements={vanilla_replays:shot_crossbow=true}] anchored eyes positioned ^ ^ ^ run function vanilla_replays:record/projectiles/record_crossbow {id:$(id),frame:$(frame)}
$execute if entity @s[scores={vanilla_replays.used_bow=1..}] anchored eyes positioned ^ ^ ^ run function vanilla_replays:record/projectiles/record_bow {id:$(id),frame:$(frame)}

$execute if entity @s[advancements={vanilla_replays:used_ender_eye=true}] anchored eyes positioned ^ ^ ^ run function vanilla_replays:record/projectiles/record_ender_eye {id:$(id),frame:$(frame)}
$execute if entity @s[scores={vanilla_replays.used_ender_pearl=1..}] anchored eyes positioned ^ ^ ^ run function vanilla_replays:record/projectiles/record_ender_pearl {id:$(id),frame:$(frame)}

$execute if entity @s[advancements={vanilla_replays:hit_by_arrow=true}] run data modify storage vanilla_replays:record_$(id) frame.$(frame).arrow_hit set value 1b

$execute if function vanilla_replays:record/throwing/trident anchored eyes positioned ^ ^ ^ run function vanilla_replays:record/projectiles/record_trident {id:$(id),frame:$(frame)}

$execute if entity @s[scores={vanilla_replays.used_wind_charge=1..}] anchored eyes positioned ^ ^ ^ run function vanilla_replays:record/projectiles/record_wind_charge {id:$(id),frame:$(frame)}

$execute if function vanilla_replays:record/throwing/egg anchored eyes positioned ^ ^ ^ run function vanilla_replays:record/projectiles/record_egg {id:$(id),frame:$(frame)}
$execute if entity @s[scores={vanilla_replays.used_snowball=1..}] anchored eyes positioned ^ ^ ^ run function vanilla_replays:record/projectiles/record_snowball {id:$(id),frame:$(frame)}

$execute if entity @s[scores={vanilla_replays.used_splash_potion=1..}] anchored eyes positioned ^ ^ ^ run function vanilla_replays:record/projectiles/record_splash_potion {id:$(id),frame:$(frame)}
$execute if entity @s[scores={vanilla_replays.used_lingering_potion=1..}] anchored eyes positioned ^ ^ ^ run function vanilla_replays:record/projectiles/record_lingering_potion {id:$(id),frame:$(frame)}
$execute if entity @s[scores={vanilla_replays.used_experience_bottle=1..}] anchored eyes positioned ^ ^ ^ run function vanilla_replays:record/projectiles/record_experience_bottle {id:$(id),frame:$(frame)}

$execute if entity @s[scores={vanilla_replays.used_firework_rocket=1..},nbt={FallFlying:1b}] run function vanilla_replays:record/projectiles/record_air_firework_rocket {id:$(id),frame:$(frame)}
$execute if entity @s[scores={vanilla_replays.used_firework_rocket=1..},nbt={FallFlying:0b}] run function vanilla_replays:record/projectiles/record_ground_firework_rocket {id:$(id),frame:$(frame)}

$execute if entity @s[scores={vanilla_replays.used_goat_horn=1..}] run function vanilla_replays:record/goat_horn/get_slot {id:$(id),frame:$(frame)}

# eating

$execute if entity @s[advancements={vanilla_replays:using_item=true}] run function vanilla_replays:record/consuming_item/tick {id:$(id),frame:$(frame)}

# dropped item

$execute if entity @s[scores={vanilla_replays.drop_item=1..}] anchored eyes positioned ^ ^ ^ run function vanilla_replays:record/dropped_item/record {id:$(id),frame:$(frame)}


	# DETECT ITEMS CHANGE

$function vanilla_replays:record/equipped_items/detect_selected {id:$(id),frame:$(frame)}

