#########################################
#					#
#	Vanilla Replays by Youly	#
#					#
#########################################




	# FUNCTIONS TICK

function vanilla_replays:record/tick
function vanilla_replays:playback/tick


	# ACTORS

execute as @e[tag=vanilla_replays.actor,tag=!vanilla_replays.playback] run effect give @s resistance infinite 255 true
execute as @e[tag=vanilla_replays.actor,tag=!vanilla_replays.playback] run effect give @s instant_health 1 20 true
execute as @e[tag=vanilla_replays.actor,tag=!vanilla_replays.playback] run data modify entity @s Glowing set value 0b

	# PLAYERS

# actor highlight & info

execute as @a[gamemode=!spectator] at @s run data modify entity @n[tag=vanilla_replays.actor,tag=!vanilla_replays.recording,tag=!vanilla_replays.playback,distance=0..5] Glowing set value 1b
execute as @a[gamemode=!spectator] at @s if entity @n[tag=vanilla_replays.actor,tag=!vanilla_replays.recording,tag=!vanilla_replays.playback,distance=0..5] run title @s actionbar [{text:"Nearest Actor: ",color:"gray"},{text:"Name: ",color:"white"},{color:"yellow","entity":"@n[tag=vanilla_replays.actor,tag=!vanilla_replays.recording,tag=!vanilla_replays.playback]","nbt":"CustomName"},{text:" |",color:"gray"},{text:" ID: ",color:"white"},{color:"yellow","score":{"name":"@n[tag=vanilla_replays.actor,tag=!vanilla_replays.recording,tag=!vanilla_replays.playback]","objective":"vanilla_replays.id"}},{text:" | ",color:"gray"},{color:"white",text:"Scene: "},{color:"yellow","entity":"@n[tag=vanilla_replays.actor,tag=!vanilla_replays.recording,tag=!vanilla_replays.playback]","nbt":"data.vanilla_replays:scene"}]
execute as @a[gamemode=!spectator] at @s if entity @n[tag=vanilla_replays.actor,tag=!vanilla_replays.recording,tag=!vanilla_replays.playback,distance=0..5] run tag @s add vanilla_replays.actor_nearby

execute as @a[gamemode=!spectator,tag=vanilla_replays.actor_nearby] at @s unless entity @n[tag=vanilla_replays.actor,tag=!vanilla_replays.recording,tag=!vanilla_replays.playback,distance=0..5] run title @s actionbar ""
execute as @a[gamemode=!spectator,tag=vanilla_replays.actor_nearby] at @s unless entity @n[tag=vanilla_replays.actor,tag=!vanilla_replays.recording,tag=!vanilla_replays.playback,distance=0..5] run tag @s remove vanilla_replays.actor_nearby

# actor raycast

kill @e[tag=vanilla_replays.actor.interaction,scores={vanilla_replays.lifetime=2..}]
scoreboard players add @e[tag=vanilla_replays.actor.interaction] vanilla_replays.lifetime 1

tag @e[tag=vanilla_replays.actor] remove vanilla_replays.actor.hovered

execute as @a[tag=!vanilla_replays.recording,predicate=vanilla_replays:any_sneak,predicate=vanilla_replays:looking_at_actor] at @s run function vanilla_replays:actor/raycast/cast

execute as @e[tag=vanilla_replays.actor.interaction,tag=!vanilla_replays.init] at @s if data entity @s interaction if entity @a[advancements={vanilla_replays:interact_interaction=true},tag=!vanilla_replays.recording,predicate=vanilla_replays:any_sneak,predicate=vanilla_replays:looking_at_actor] run function vanilla_replays:actor/raycast/get_properties

# recording info

execute as @a[tag=vanilla_replays.recording] run title @s actionbar {"color":"green","text":"Recording actor"}

# function triggers

scoreboard players enable @a vanilla_replays.trigger.stop_recording
execute as @a[scores={vanilla_replays.trigger.stop_recording=1..}] at @s run function vanilla_replays:record/stop
scoreboard players reset @a[scores={vanilla_replays.trigger.stop_recording=1..}] vanilla_replays.trigger.stop_recording

scoreboard players enable @a vanilla_replays.trigger.actor.list.evaluate
execute as @a[scores={vanilla_replays.trigger.actor.list.evaluate=1..}] at @s run function vanilla_replays:actor/list/evaluate
scoreboard players reset @a[scores={vanilla_replays.trigger.actor.list.evaluate=1..}] vanilla_replays.trigger.actor.list.evaluate

scoreboard players enable @a vanilla_replays.trigger.main
execute as @a[scores={vanilla_replays.trigger.main=1..}] at @s run dialog show @s vanilla_replays:main
execute as @a[scores={vanilla_replays.trigger.main=1..}] at @s run scoreboard players enable @s vanilla_replays.trigger.actor.list.evaluate
scoreboard players reset @a[scores={vanilla_replays.trigger.main=1..}] vanilla_replays.trigger.main


	# PROJECTILES ENTITIES

#eggs
execute as @e[tag=vanilla_replays.egg.anti_chicken,predicate=!vanilla_replays:riding] at @s positioned ~ ~-0.25 ~ run function vanilla_replays:other/egg/effect_on_chicken
kill @e[tag=vanilla_replays.egg.anti_chicken,scores={vanilla_replays.lifetime=3..}]
scoreboard players add @e[tag=vanilla_replays.egg.anti_chicken,predicate=!vanilla_replays:riding] vanilla_replays.lifetime 1

#experience bottles
execute as @e[tag=vanilla_replays.experience_bottle.anti_xp_orb,predicate=!vanilla_replays:riding] at @s positioned ~ ~-0.25 ~ run function vanilla_replays:other/experience_orb/get_id
kill @e[tag=vanilla_replays.experience_bottle.anti_xp_orb,scores={vanilla_replays.lifetime=3..}]
scoreboard players add @e[tag=vanilla_replays.experience_bottle.anti_xp_orb,predicate=!vanilla_replays:riding] vanilla_replays.lifetime 1

#lingering potions
execute as @e[tag=vanilla_replays.lingering_potion.anti_area_effect,predicate=!vanilla_replays:riding] at @s positioned ~ ~-0.25 ~ run function vanilla_replays:other/lingering_potion/get_id
kill @e[tag=vanilla_replays.lingering_potion.anti_area_effect,scores={vanilla_replays.lifetime=3..}]
scoreboard players add @e[tag=vanilla_replays.lingering_potion.anti_area_effect,predicate=!vanilla_replays:riding] vanilla_replays.lifetime 1


	# RESET DETECTIONS

scoreboard players reset @a vanilla_replays.die

scoreboard players reset @a vanilla_replays.take_damage

advancement revoke @a only vanilla_replays:effects_changed

advancement revoke @a only vanilla_replays:interact_interaction

advancement revoke @a only vanilla_replays:shot_crossbow
scoreboard players reset @a vanilla_replays.used_bow
advancement revoke @a only vanilla_replays:used_ender_eye
scoreboard players reset @a vanilla_replays.used_ender_pearl
scoreboard players reset @a vanilla_replays.used_trident
scoreboard players reset @a vanilla_replays.used_wind_charge

scoreboard players reset @a vanilla_replays.used_egg
scoreboard players reset @a vanilla_replays.used_brown_egg
scoreboard players reset @a vanilla_replays.used_blue_egg
scoreboard players reset @a vanilla_replays.used_snowball

scoreboard players reset @a vanilla_replays.used_lingering_potion
scoreboard players reset @a vanilla_replays.used_splash_potion
scoreboard players reset @a vanilla_replays.used_experience_bottle

advancement revoke @a only vanilla_replays:hit_by_arrow
advancement revoke @a only vanilla_replays:used_totem

scoreboard players reset @a vanilla_replays.used_firework_rocket

scoreboard players reset @a vanilla_replays.used_goat_horn
scoreboard players reset @a vanilla_replays.drop_item