/*
 * Decompiled with CFR 0.152.
 */
package de.pnku.mbdv.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import de.pnku.mbdv.MoreBedVariants;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

public class BedShapeState {
    public static boolean needsToBeChecked = false;
    public static boolean isPillowedPackActive = false;
    public static boolean isPillowedConnectedPackActive = false;
    public static boolean silent = false;

    @Environment(value=EnvType.CLIENT)
    public static void checkClientResourcepacks() {
        String clientUtilsClassName = "de.pnku.mbdv.util.client.ClientUtils";
        String packCheckerMethodName = "checkActiveResourcePacks";
        try {
            Class<?> clientUtilsClass = Class.forName(clientUtilsClassName);
            clientUtilsClass.getMethod(packCheckerMethodName, new Class[0]).invoke(null, new Object[0]);
            if (!silent) {
                MoreBedVariants.LOGGER.info("Active resource packs checked successfully.");
                silent = true;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            try {
                Class<?> clientUtilsClass = Class.forName(clientUtilsClassName);
                clientUtilsClass.getMethod(packCheckerMethodName, new Class[0]).invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e1) {
                MoreBedVariants.LOGGER.warn("Failed to check active resource packs: " + e.getMessage());
            }
            needsToBeChecked = false;
        }
    }

    @Environment(value=EnvType.SERVER)
    public static class ServerConfig {
        private static final File folder = new File("config");
        private static File mBedVConfig;
        public static Gson configGson;
        private static final String pillowedName = "pillowedUnconnectedShape";
        private static final String pillowedConnectedName = "pillowedConnectedShape";

        public static void checkServerConfig() {
            ServerConfig.createServerConfig();
            ServerConfig.readServerConfig();
        }

        private static void createServerConfig() {
            if (!folder.exists()) {
                folder.mkdir();
            }
            if (folder.isDirectory()) {
                boolean seemsValid;
                mBedVConfig = new File(folder, "morebedvariants.json");
                if (mBedVConfig.exists()) {
                    try {
                        String mBedVConfigJson = Files.readString(Path.of(mBedVConfig.getPath(), new String[0]));
                        seemsValid = mBedVConfigJson.trim().startsWith("{");
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    seemsValid = true;
                }
                if (!mBedVConfig.exists() || !seemsValid) {
                    if (!seemsValid) {
                        MoreBedVariants.LOGGER.info("Found invalid config file, creating new config file at './config/morebedvariants.json'.");
                    }
                    try {
                        mBedVConfig.createNewFile();
                        JsonObject defaultConfig = new JsonObject();
                        defaultConfig.addProperty(pillowedName, Boolean.valueOf(false));
                        defaultConfig.addProperty(pillowedConnectedName, Boolean.valueOf(false));
                        try (FileWriter writer = new FileWriter(mBedVConfig);){
                            configGson.toJson((JsonElement)defaultConfig, (Appendable)writer);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        private static void readServerConfig() {
            try {
                JsonReader mBedVConfigJsonReader = configGson.newJsonReader((Reader)new FileReader(mBedVConfig));
                JsonObject config = JsonParser.parseReader((JsonReader)mBedVConfigJsonReader).getAsJsonObject();
                isPillowedPackActive = config.get(pillowedName).getAsBoolean();
                isPillowedConnectedPackActive = config.get(pillowedConnectedName).getAsBoolean();
                needsToBeChecked = false;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public static void writeServerConfig() {
            boolean isPillowedConnectedShape = isPillowedConnectedPackActive;
            boolean isPillowedShape = !isPillowedConnectedShape && isPillowedPackActive;
            mBedVConfig = new File(folder, "morebedvariants.json");
            try {
                JsonObject config = new JsonObject();
                config.addProperty(pillowedName, Boolean.valueOf(isPillowedShape));
                config.addProperty(pillowedConnectedName, Boolean.valueOf(isPillowedConnectedShape));
                try (FileWriter writer = new FileWriter(mBedVConfig);){
                    configGson.toJson((JsonElement)config, (Appendable)writer);
                }
            }
            catch (IOException e) {
                MoreBedVariants.LOGGER.warn("Failed to write bed shape settings to config file at './config/morebedvariants.json': {}", (Object)e.getMessage());
            }
            isPillowedPackActive = isPillowedShape;
            isPillowedConnectedPackActive = isPillowedConnectedShape;
        }

        static {
            configGson = new GsonBuilder().setPrettyPrinting().create();
        }
    }
}

