/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.chat;

import com.owlmaddie.chat.GossipTypeHelper;
import com.owlmaddie.chat.PlayerData;
import com.owlmaddie.controls.SpeedControls;
import com.owlmaddie.goals.AttackPlayerGoal;
import com.owlmaddie.goals.EntityBehaviorManager;
import com.owlmaddie.goals.FleePlayerGoal;
import com.owlmaddie.goals.FollowPlayerGoal;
import com.owlmaddie.goals.GoalPriority;
import com.owlmaddie.goals.LeadPlayerGoal;
import com.owlmaddie.goals.ProtectPlayerGoal;
import com.owlmaddie.goals.TalkPlayerGoal;
import com.owlmaddie.message.Behavior;
import com.owlmaddie.network.ServerPackets;
import com.owlmaddie.particle.ParticleEmitter;
import com.owlmaddie.utils.ServerEntityFinder;
import com.owlmaddie.utils.TameableHelper;
import com.owlmaddie.utils.VillagerEntityAccessor;
import com.owlmaddie.utils.WitherEntityAccessor;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class BehaviorApplier {
    public static void apply(List<Behavior> behaviors, class_3222 player, String entityId, PlayerData playerData) {
        class_1308 entity = (class_1308)ServerEntityFinder.getEntityByUUID((class_3218)player.method_37908(), UUID.fromString(entityId));
        if (entity == null) {
            return;
        }
        float entitySpeed = SpeedControls.getMaxSpeed(entity);
        float entitySpeedMedium = class_3532.method_15363((float)(entitySpeed * 1.15f), (float)0.5f, (float)1.15f);
        float entitySpeedFast = class_3532.method_15363((float)(entitySpeed * 1.3f), (float)0.5f, (float)1.3f);
        for (Behavior behavior : behaviors) {
            ServerPackets.LOGGER.info("Behavior: " + behavior.getName() + (String)(behavior.getArgument() != null ? ", Argument: " + behavior.getArgument() : ""));
            if (behavior.getName().equals("FOLLOW")) {
                FollowPlayerGoal followGoal = new FollowPlayerGoal(player, entity, entitySpeedMedium);
                EntityBehaviorManager.removeGoal(entity, TalkPlayerGoal.class);
                EntityBehaviorManager.removeGoal(entity, FleePlayerGoal.class);
                EntityBehaviorManager.removeGoal(entity, AttackPlayerGoal.class);
                EntityBehaviorManager.removeGoal(entity, LeadPlayerGoal.class);
                EntityBehaviorManager.addGoal(entity, followGoal, GoalPriority.FOLLOW_PLAYER);
                if (playerData.friendship >= 0) {
                    ParticleEmitter.emitCreatureParticle((class_3218)entity.method_37908(), (class_1297)entity, (class_2394)ServerPackets.FOLLOW_ENEMY_PARTICLE, 0.5, 1);
                    continue;
                }
                ParticleEmitter.emitCreatureParticle((class_3218)entity.method_37908(), (class_1297)entity, (class_2394)ServerPackets.FOLLOW_ENEMY_PARTICLE, 0.5, 1);
                continue;
            }
            if (behavior.getName().equals("UNFOLLOW")) {
                EntityBehaviorManager.removeGoal(entity, FollowPlayerGoal.class);
                continue;
            }
            if (behavior.getName().equals("FLEE")) {
                float fleeDistance = 40.0f;
                FleePlayerGoal fleeGoal = new FleePlayerGoal(player, entity, entitySpeedFast, fleeDistance);
                EntityBehaviorManager.removeGoal(entity, TalkPlayerGoal.class);
                EntityBehaviorManager.removeGoal(entity, FollowPlayerGoal.class);
                EntityBehaviorManager.removeGoal(entity, AttackPlayerGoal.class);
                EntityBehaviorManager.removeGoal(entity, ProtectPlayerGoal.class);
                EntityBehaviorManager.removeGoal(entity, LeadPlayerGoal.class);
                EntityBehaviorManager.addGoal(entity, fleeGoal, GoalPriority.FLEE_PLAYER);
                ParticleEmitter.emitCreatureParticle((class_3218)entity.method_37908(), (class_1297)entity, (class_2394)ServerPackets.FLEE_PARTICLE, 0.5, 1);
                continue;
            }
            if (behavior.getName().equals("UNFLEE")) {
                EntityBehaviorManager.removeGoal(entity, FleePlayerGoal.class);
                continue;
            }
            if (behavior.getName().equals("ATTACK")) {
                AttackPlayerGoal attackGoal = new AttackPlayerGoal((class_1309)player, entity, entitySpeedFast);
                EntityBehaviorManager.removeGoal(entity, TalkPlayerGoal.class);
                EntityBehaviorManager.removeGoal(entity, FollowPlayerGoal.class);
                EntityBehaviorManager.removeGoal(entity, FleePlayerGoal.class);
                EntityBehaviorManager.removeGoal(entity, ProtectPlayerGoal.class);
                EntityBehaviorManager.removeGoal(entity, LeadPlayerGoal.class);
                EntityBehaviorManager.addGoal(entity, attackGoal, GoalPriority.ATTACK_PLAYER);
                ParticleEmitter.emitCreatureParticle((class_3218)entity.method_37908(), (class_1297)entity, (class_2394)ServerPackets.FLEE_PARTICLE, 0.5, 1);
                continue;
            }
            if (behavior.getName().equals("UNATTACK")) {
                EntityBehaviorManager.removeGoal(entity, AttackPlayerGoal.class);
                AttackPlayerGoal.stopAttack(entity);
                continue;
            }
            if (behavior.getName().equals("PROTECT")) {
                if (playerData.friendship <= 0) {
                    playerData.friendship = 1;
                }
                ProtectPlayerGoal protectGoal = new ProtectPlayerGoal((class_1309)player, entity, 1.0);
                EntityBehaviorManager.removeGoal(entity, TalkPlayerGoal.class);
                EntityBehaviorManager.removeGoal(entity, FleePlayerGoal.class);
                EntityBehaviorManager.removeGoal(entity, AttackPlayerGoal.class);
                EntityBehaviorManager.addGoal(entity, protectGoal, GoalPriority.PROTECT_PLAYER);
                ParticleEmitter.emitCreatureParticle((class_3218)entity.method_37908(), (class_1297)entity, (class_2394)ServerPackets.PROTECT_PARTICLE, 0.5, 1);
                continue;
            }
            if (behavior.getName().equals("UNPROTECT")) {
                EntityBehaviorManager.removeGoal(entity, ProtectPlayerGoal.class);
                continue;
            }
            if (behavior.getName().equals("LEAD")) {
                LeadPlayerGoal leadGoal = new LeadPlayerGoal(player, entity, entitySpeedMedium);
                EntityBehaviorManager.removeGoal(entity, FollowPlayerGoal.class);
                EntityBehaviorManager.removeGoal(entity, FleePlayerGoal.class);
                EntityBehaviorManager.removeGoal(entity, AttackPlayerGoal.class);
                EntityBehaviorManager.addGoal(entity, leadGoal, GoalPriority.LEAD_PLAYER);
                if (playerData.friendship >= 0) {
                    ParticleEmitter.emitCreatureParticle((class_3218)entity.method_37908(), (class_1297)entity, (class_2394)ServerPackets.LEAD_FRIEND_PARTICLE, 0.5, 1);
                    continue;
                }
                ParticleEmitter.emitCreatureParticle((class_3218)entity.method_37908(), (class_1297)entity, (class_2394)ServerPackets.LEAD_ENEMY_PARTICLE, 0.5, 1);
                continue;
            }
            if (behavior.getName().equals("UNLEAD")) {
                EntityBehaviorManager.removeGoal(entity, LeadPlayerGoal.class);
                continue;
            }
            if (!behavior.getName().equals("FRIENDSHIP")) continue;
            int new_friendship = Math.max(-3, Math.min(3, behavior.getArgument()));
            if (new_friendship > playerData.friendship) {
                EntityBehaviorManager.removeGoal(entity, FleePlayerGoal.class);
                EntityBehaviorManager.removeGoal(entity, AttackPlayerGoal.class);
                if (entity instanceof class_1528 && new_friendship == 3) {
                    class_1528 wither = (class_1528)entity;
                    ((WitherEntityAccessor)wither).callDropEquipment(entity.method_37908().method_48963().method_48830(), 1, true);
                    entity.method_37908().method_45445((class_1297)entity, entity.method_24515(), class_3417.field_15136, class_3419.field_15248, 0.3f, 1.0f);
                }
                if (entity instanceof class_1510 && new_friendship == 3) {
                    class_1510 dragon = (class_1510)entity;
                    ParticleEmitter.emitCreatureParticle((class_3218)entity.method_37908(), (class_1297)entity, (class_2394)ServerPackets.HEART_BIG_PARTICLE, 3.0, 200);
                    entity.method_37908().method_45445((class_1297)entity, entity.method_24515(), class_3417.field_14773, class_3419.field_15248, 0.3f, 1.0f);
                    entity.method_37908().method_45445((class_1297)entity, entity.method_24515(), class_3417.field_15195, class_3419.field_15248, 0.5f, 1.0f);
                    class_3218 serverWorld = (class_3218)entity.method_37908();
                    boolean doMobLoot = serverWorld.method_8450().method_8355(class_1928.field_19391);
                    int baseXP = 500;
                    if (dragon.method_6829() != null && !dragon.method_6829().method_12536()) {
                        baseXP = 12000;
                    }
                    if (entity.method_37908() instanceof class_3218 && doMobLoot) {
                        for (int j = 1; j <= 11; ++j) {
                            float xpFraction = j == 11 ? 0.2f : 0.08f;
                            int xpAmount = class_3532.method_15375((float)((float)baseXP * xpFraction));
                            class_1303.method_31493((class_3218)((class_3218)entity.method_37908()), (class_243)entity.method_19538(), (int)xpAmount);
                        }
                    }
                    dragon.method_6829().method_12528(dragon);
                }
            }
            if (entity instanceof class_1646 && playerData.friendship != new_friendship) {
                VillagerEntityAccessor villager = (VillagerEntityAccessor)entity;
                switch (new_friendship) {
                    case 3: {
                        GossipTypeHelper.startGossip(villager, player.method_5667(), GossipTypeHelper.MAJOR_POSITIVE, 20);
                        GossipTypeHelper.startGossip(villager, player.method_5667(), GossipTypeHelper.MINOR_POSITIVE, 25);
                        break;
                    }
                    case 2: {
                        GossipTypeHelper.startGossip(villager, player.method_5667(), GossipTypeHelper.MINOR_POSITIVE, 25);
                        break;
                    }
                    case 1: {
                        GossipTypeHelper.startGossip(villager, player.method_5667(), GossipTypeHelper.MINOR_POSITIVE, 10);
                        break;
                    }
                    case -1: {
                        GossipTypeHelper.startGossip(villager, player.method_5667(), GossipTypeHelper.MINOR_NEGATIVE, 10);
                        break;
                    }
                    case -2: {
                        GossipTypeHelper.startGossip(villager, player.method_5667(), GossipTypeHelper.MINOR_NEGATIVE, 25);
                        break;
                    }
                    case -3: {
                        GossipTypeHelper.startGossip(villager, player.method_5667(), GossipTypeHelper.MAJOR_NEGATIVE, 20);
                        GossipTypeHelper.startGossip(villager, player.method_5667(), GossipTypeHelper.MINOR_NEGATIVE, 25);
                    }
                }
            }
            if (entity instanceof class_1321 && playerData.friendship != new_friendship) {
                class_1321 tamableEntity = (class_1321)entity;
                if (new_friendship == 3 && !tamableEntity.method_6181()) {
                    tamableEntity.method_6170((class_1657)player);
                } else if (new_friendship == -3 && tamableEntity.method_6181()) {
                    TameableHelper.setTamed((class_1321)entity, false);
                    TameableHelper.clearOwner(tamableEntity);
                }
            }
            if (playerData.friendship != new_friendship) {
                int friendDiff = new_friendship - playerData.friendship;
                if (friendDiff > 0) {
                    if (new_friendship == 3) {
                        ParticleEmitter.emitCreatureParticle((class_3218)entity.method_37908(), (class_1297)entity, (class_2394)ServerPackets.HEART_BIG_PARTICLE, 0.5, 10);
                    } else {
                        ParticleEmitter.emitCreatureParticle((class_3218)entity.method_37908(), (class_1297)entity, (class_2394)ServerPackets.HEART_SMALL_PARTICLE, 0.1, 1);
                    }
                } else if (friendDiff < 0) {
                    if (new_friendship == -3) {
                        ParticleEmitter.emitCreatureParticle((class_3218)entity.method_37908(), (class_1297)entity, (class_2394)ServerPackets.FIRE_BIG_PARTICLE, 0.5, 10);
                    } else {
                        ParticleEmitter.emitCreatureParticle((class_3218)entity.method_37908(), (class_1297)entity, (class_2394)ServerPackets.FIRE_SMALL_PARTICLE, 0.1, 1);
                    }
                }
            }
            playerData.friendship = new_friendship;
        }
    }
}

