/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.chat;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.owlmaddie.chat.ChatDataManager;
import com.owlmaddie.chat.ChatGPTRequest;
import com.owlmaddie.chat.ChatMessage;
import com.owlmaddie.chat.ChatPrompt;
import com.owlmaddie.chat.EntityChatDataLight;
import com.owlmaddie.chat.EventQueueManager;
import com.owlmaddie.chat.LineWrapper;
import com.owlmaddie.chat.PlayerData;
import com.owlmaddie.commands.ConfigurationHandler;
import com.owlmaddie.message.MessageParser;
import com.owlmaddie.network.ServerPackets;
import com.owlmaddie.utils.ArmorHelper;
import com.owlmaddie.utils.ServerEntityFinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityChatData {
    @Expose(serialize=false, deserialize=false)
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");
    @Expose
    public String entityId;
    @Expose
    public String currentMessage;
    @Expose
    public int currentLineNumber;
    @Expose
    public ChatDataManager.ChatStatus status;
    @Expose
    public String characterSheet;
    @Expose
    public ChatDataManager.ChatSender sender;
    @Expose
    public int auto_generated;
    @Expose
    public List<ChatMessage> previousMessages;
    @Expose
    public Long born;
    @Expose
    public Long death;
    @Expose(serialize=false, deserialize=false)
    public class_3222 lastPlayer;
    @Expose
    public ChatMessage errorMessage = null;
    @SerializedName(value="playerId")
    @Expose(serialize=false)
    private String legacyPlayerId;
    @SerializedName(value="friendship")
    @Expose(serialize=false)
    public Integer legacyFriendship;
    @Expose
    public Map<String, PlayerData> players;

    public EntityChatData(String entityId) {
        this.entityId = entityId;
        this.players = new HashMap<String, PlayerData>();
        this.currentMessage = "";
        this.currentLineNumber = 0;
        this.characterSheet = "";
        this.status = ChatDataManager.ChatStatus.NONE;
        this.sender = ChatDataManager.ChatSender.USER;
        this.auto_generated = 0;
        this.previousMessages = new ArrayList<ChatMessage>();
        this.born = System.currentTimeMillis();
        this.lastPlayer = null;
        this.legacyPlayerId = null;
        this.legacyFriendship = null;
    }

    public void postDeserializeInitialization() {
        if (this.players == null) {
            this.players = new HashMap<String, PlayerData>();
        }
        if (this.legacyPlayerId != null && !this.legacyPlayerId.isEmpty()) {
            this.migrateData();
        }
        EventQueueManager.addEntityIdToCreate(this.entityId);
    }

    private void migrateData() {
        PlayerData blankPlayerData = this.players.computeIfAbsent("", k -> new PlayerData());
        if (this.previousMessages != null) {
            for (ChatMessage message : this.previousMessages) {
                if (message.timestamp == null) {
                    message.timestamp = System.currentTimeMillis();
                }
                if (message.name != null && !message.name.isEmpty()) continue;
                message.name = "";
            }
        }
        blankPlayerData.friendship = this.legacyFriendship;
        if (this.born == null) {
            this.born = System.currentTimeMillis();
        }
        this.legacyPlayerId = null;
        this.legacyFriendship = null;
    }

    public PlayerData getPlayerData(String playerName) {
        if (this.players == null) {
            return new PlayerData();
        }
        if (this.players.containsKey("")) {
            return this.players.get("");
        }
        if (this.players.containsKey(playerName)) {
            return this.players.get(playerName);
        }
        PlayerData newPlayerData = new PlayerData();
        this.players.put(playerName, newPlayerData);
        return newPlayerData;
    }

    public EntityChatDataLight toLightVersion(String playerName) {
        return new EntityChatDataLight(this, playerName);
    }

    public String getCharacterProp(String propertyName) {
        Pattern pattern = Pattern.compile("-?\\s*" + Pattern.quote(propertyName) + ":\\s*(.+)", 2);
        Matcher matcher = pattern.matcher(this.characterSheet);
        if (matcher.find()) {
            return matcher.group(1).trim().replace("\"", "");
        }
        return "N/A";
    }

    private static class_1291 effectOf(class_1293 inst) {
        class_1291 raw = inst.method_5579();
        if (raw instanceof class_1291) {
            class_1291 se = raw;
            return se;
        }
        return (class_1291)((class_6880)raw).comp_349();
    }

    public Map<String, String> getPlayerContext(class_3222 player, String userLanguage, ConfigurationHandler.Config config) {
        HashMap<String, String> contextData = new HashMap<String, String>();
        contextData.put("player_name", player.method_5476().getString());
        contextData.put("player_health", Math.round(player.method_6032()) + "/" + Math.round(player.method_6063()));
        contextData.put("player_hunger", String.valueOf(player.method_7344().method_7586()));
        contextData.put("player_held_item", String.valueOf(player.method_6047().method_7909().toString()));
        contextData.put("player_biome", ((class_5321)player.method_37908().method_23753(player.method_24515()).method_40230().get()).method_29177().method_12832());
        contextData.put("player_is_creative", player.method_7337() ? "yes" : "no");
        contextData.put("player_is_swimming", player.method_5681() ? "yes" : "no");
        contextData.put("player_is_on_ground", player.method_24828() ? "yes" : "no");
        contextData.put("player_language", userLanguage);
        class_1799 headArmor = ArmorHelper.getArmor((class_1657)player, class_1304.field_6169);
        class_1799 chestArmor = ArmorHelper.getArmor((class_1657)player, class_1304.field_6174);
        class_1799 legsArmor = ArmorHelper.getArmor((class_1657)player, class_1304.field_6172);
        class_1799 feetArmor = ArmorHelper.getArmor((class_1657)player, class_1304.field_6166);
        contextData.put("player_armor_head", headArmor.method_7909().toString());
        contextData.put("player_armor_chest", chestArmor.method_7909().toString());
        contextData.put("player_armor_legs", legsArmor.method_7909().toString());
        contextData.put("player_armor_feet", feetArmor.method_7909().toString());
        String effectsString = player.method_6088().values().stream().map(inst -> EntityChatData.effectOf(inst).method_5567() + " x" + (inst.method_5578() + 1)).collect(Collectors.joining(", "));
        contextData.put("player_active_effects", effectsString);
        if (!config.getStory().isEmpty()) {
            contextData.put("story", "Story: " + config.getStory());
        } else {
            contextData.put("story", "");
        }
        int hours = (int)((player.method_37908().method_8532() / 1000L + 6L) % 24L);
        int minutes = (int)((double)(player.method_37908().method_8532() % 1000L) / 1000.0 * 60.0);
        contextData.put("world_time", String.format("%02d:%02d", hours, minutes));
        contextData.put("world_is_raining", player.method_37908().method_8419() ? "yes" : "no");
        contextData.put("world_is_thundering", player.method_37908().method_8546() ? "yes" : "no");
        contextData.put("world_difficulty", player.method_37908().method_8407().method_5460());
        contextData.put("world_is_hardcore", player.method_37908().method_8401().method_152() ? "yes" : "no");
        String moonPhaseDescription = switch (player.method_37908().method_30273()) {
            case 0 -> "Full Moon";
            case 1 -> "Waning Gibbous";
            case 2 -> "Last Quarter";
            case 3 -> "Waning Crescent";
            case 4 -> "New Moon";
            case 5 -> "Waxing Crescent";
            case 6 -> "First Quarter";
            case 7 -> "Waxing Gibbous";
            default -> "Unknown";
        };
        contextData.put("world_moon_phase", moonPhaseDescription);
        class_1308 entity = (class_1308)ServerEntityFinder.getEntityByUUID((class_3218)player.method_37908(), UUID.fromString(this.entityId));
        if (entity.method_5797() == null) {
            contextData.put("entity_name", "");
        } else {
            contextData.put("entity_name", entity.method_5797().getString());
        }
        contextData.put("entity_type", entity.method_5864().method_5897().getString());
        contextData.put("entity_health", Math.round(entity.method_6032()) + "/" + Math.round(entity.method_6063()));
        contextData.put("entity_personality", this.getCharacterProp("Personality"));
        contextData.put("entity_speaking_style", this.getCharacterProp("Speaking Style / Tone"));
        contextData.put("entity_likes", this.getCharacterProp("Likes"));
        contextData.put("entity_dislikes", this.getCharacterProp("Dislikes"));
        contextData.put("entity_age", this.getCharacterProp("Age"));
        contextData.put("entity_alignment", this.getCharacterProp("Alignment"));
        contextData.put("entity_class", this.getCharacterProp("Class"));
        contextData.put("entity_skills", this.getCharacterProp("Skills"));
        contextData.put("entity_background", this.getCharacterProp("Background"));
        if (entity.field_6012 < 0) {
            contextData.put("entity_maturity", "Baby");
        } else {
            contextData.put("entity_maturity", "Adult");
        }
        PlayerData playerData = this.getPlayerData(player.method_5476().getString());
        if (playerData != null) {
            contextData.put("entity_friendship", String.valueOf(playerData.friendship));
        } else {
            contextData.put("entity_friendship", String.valueOf(0));
        }
        return contextData;
    }

    public boolean lastMsgIsUserMsg() {
        return this.previousMessages.size() > 0 && this.previousMessages.get((int)(this.previousMessages.size() - 1)).sender.equals((Object)ChatDataManager.ChatSender.USER);
    }

    public void generateEntityResponse(String userLanguage, class_3222 player, Consumer<String> onUncleanResponse, Consumer<String> onError) {
        String systemPrompt = "system-chat";
        ConfigurationHandler.Config config = new ConfigurationHandler(ServerPackets.serverInstance).loadConfig();
        String promptText = ChatPrompt.loadPromptFromResource(ServerPackets.serverInstance.method_34864(), systemPrompt);
        Map<String, String> contextData = this.getPlayerContext(player, userLanguage, config);
        ((CompletableFuture)ChatGPTRequest.fetchMessageFromChatGPT(config, promptText, contextData, this.previousMessages, false, "", player).thenAccept(ent_msg -> ServerPackets.serverInstance.execute(() -> {
            try {
                if (ent_msg == null) {
                    throw new RuntimeException(ChatGPTRequest.lastErrorMessage);
                }
                onUncleanResponse.accept((String)ent_msg);
            }
            catch (Exception e) {
                onError.accept(e != null && e.getMessage() != null ? e.getMessage() : "");
            }
        }))).exceptionally(ex -> {
            ServerPackets.serverInstance.execute(() -> onError.accept(ex != null && ex.getMessage() != null ? ex.getMessage() : ""));
            return null;
        });
    }

    public static String truncateString(String input, int maxLength) {
        return input.length() > maxLength ? input.substring(0, maxLength - 3) + "..." : input;
    }

    public void setError(String errorMSg) {
        this.errorMessage = new ChatMessage(errorMSg, ChatDataManager.ChatSender.ASSISTANT, this.lastPlayer != null ? this.lastPlayer.method_5477().getString() : "");
    }

    public ChatMessage getTopMessage() {
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        ChatMessage top = this.previousMessages.get(this.previousMessages.size() - 1);
        String newMessage = MessageParser.parseMessage(top.message.replace("\n", " ")).getCleanedMessage();
        return new ChatMessage(newMessage, top.sender, top.name);
    }

    public void addMessage(String message, ChatDataManager.ChatSender sender, class_3222 player) {
        this.errorMessage = null;
        this.lastPlayer = player;
        String truncatedMessage = message.substring(0, Math.min(message.length(), ChatDataManager.MAX_CHAR_IN_USER_MESSAGE));
        String playerName = player.method_5476().getString();
        if (sender == ChatDataManager.ChatSender.USER && this.previousMessages.size() > 1) {
            ChatMessage lastMessage = this.previousMessages.get(this.previousMessages.size() - 1);
            if (lastMessage.name == null || !lastMessage.name.equals(playerName)) {
                boolean isReturningPlayer = this.previousMessages.stream().anyMatch(msg -> playerName.equals(msg.name));
                String note = isReturningPlayer ? "<returning player: " + playerName + " resumes the conversation>" : "<a new player has joined the conversation: " + playerName + ">";
                this.previousMessages.add(new ChatMessage(note, sender, playerName));
                LOGGER.info("Conversation-switching message: status=PENDING, sender={}, message={}, player={}, entity={}", new Object[]{ChatDataManager.ChatStatus.PENDING, note, playerName, this.entityId});
            }
            this.status = ChatDataManager.ChatStatus.PENDING;
        }
        this.previousMessages.add(new ChatMessage(truncatedMessage, sender, playerName));
        this.currentMessage = truncatedMessage;
        this.currentLineNumber = 0;
        this.sender = sender;
        if (sender == ChatDataManager.ChatSender.ASSISTANT) {
            this.status = ChatDataManager.ChatStatus.DISPLAY;
        }
    }

    public List<String> getWrappedLines() {
        return LineWrapper.wrapLines(this.currentMessage, ChatDataManager.MAX_CHAR_PER_LINE);
    }

    public boolean isEndOfMessage() {
        int totalLines = this.getWrappedLines().size();
        return this.currentLineNumber + ChatDataManager.DISPLAY_NUM_LINES >= totalLines;
    }

    public class_3222 getPlayer() {
        if (this.lastPlayer == null) {
            throw new RuntimeException("Tried to get player but no player found");
        }
        return this.lastPlayer;
    }
}

