/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.owlmaddie.network.ServerPackets;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Path serverConfigPath;
    private final Path defaultConfigPath;

    public ConfigurationHandler(MinecraftServer server) {
        this.serverConfigPath = server.method_27050(class_5218.field_24188).resolve("creaturepals.json");
        this.defaultConfigPath = Paths.get(".", "creaturepals.json");
    }

    public Config loadConfig() {
        Config config = this.loadConfigFromFile(this.serverConfigPath);
        if (config == null) {
            config = this.loadConfigFromFile(this.defaultConfigPath);
        }
        return config != null ? config : new Config();
    }

    public boolean saveConfig(Config config, boolean useServerConfig) {
        boolean bl;
        block8: {
            Path path = useServerConfig ? this.serverConfigPath : this.defaultConfigPath;
            BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);
            try {
                gson.toJson((Object)config, (Appendable)writer);
                bl = true;
                if (writer == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    String errorMessage = "Error saving `creaturepals.json`. CreaturePals config was not saved. " + e.getMessage();
                    LOGGER.error(errorMessage, (Throwable)e);
                    ServerPackets.sendErrorToAllOps(ServerPackets.serverInstance, errorMessage);
                    return false;
                }
            }
            ((Writer)writer).close();
        }
        return bl;
    }

    private Config loadConfigFromFile(Path filePath) {
        Config config;
        block8: {
            BufferedReader reader = Files.newBufferedReader(filePath);
            try {
                config = (Config)gson.fromJson((Reader)reader, Config.class);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            ((Reader)reader).close();
        }
        return config;
    }

    public static class Config {
        private String apiKey = "";
        private String url = "https://api.player2.game/v1/chat/completions";
        private String model = "gpt-3.5-turbo";
        private int maxContextTokens = 16385;
        private int maxOutputTokens = 200;
        private double percentOfContext = 0.75;
        private int timeout = 45;
        private boolean chatBubbles = true;
        private List<String> whitelist = new ArrayList<String>();
        private List<String> blacklist = new ArrayList<String>();
        private String story = "";

        public String getApiKey() {
            return this.apiKey;
        }

        public void setApiKey(String apiKey) {
            if (apiKey.startsWith("p2_")) {
                this.setUrl("https://api.player2.game/v1/chat/completions");
            } else if (apiKey.startsWith("cc_") && apiKey.length() == 15) {
                this.setUrl("https://api.creaturechat.com/v1/chat/completions");
            } else if (apiKey.startsWith("sk-")) {
                this.setUrl("https://api.openai.com/v1/chat/completions");
            }
            this.apiKey = apiKey;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public int getMaxContextTokens() {
            return this.maxContextTokens;
        }

        public void setMaxContextTokens(int maxContextTokens) {
            this.maxContextTokens = maxContextTokens;
        }

        public int getMaxOutputTokens() {
            return this.maxOutputTokens;
        }

        public void setMaxOutputTokens(int maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
        }

        public double getPercentOfContext() {
            return this.percentOfContext;
        }

        public void setPercentOfContext(double percentOfContext) {
            this.percentOfContext = percentOfContext;
        }

        public List<String> getWhitelist() {
            return this.whitelist;
        }

        public void setWhitelist(List<String> whitelist) {
            this.whitelist = whitelist;
        }

        public List<String> getBlacklist() {
            return this.blacklist;
        }

        public void setBlacklist(List<String> blacklist) {
            this.blacklist = blacklist;
        }

        public String getStory() {
            return this.story;
        }

        public void setStory(String story) {
            this.story = story;
        }

        public boolean getChatBubbles() {
            return this.chatBubbles;
        }

        public void setChatBubbles(boolean chatBubblesEnabled) {
            this.chatBubbles = chatBubblesEnabled;
        }
    }
}

