/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.goals;

import com.owlmaddie.chat.ChatDataManager;
import com.owlmaddie.chat.EntityChatData;
import com.owlmaddie.chat.EventQueueManager;
import com.owlmaddie.controls.LookControls;
import com.owlmaddie.goals.PlayerBaseGoal;
import com.owlmaddie.network.ServerPackets;
import com.owlmaddie.particle.LeadParticleEffect;
import com.owlmaddie.utils.RandomTargetFinder;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeadPlayerGoal
extends PlayerBaseGoal {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");
    private final class_1308 entity;
    private final double speed;
    private final Random random = new Random();
    private int currentWaypoint = 0;
    private int totalWaypoints;
    private class_243 currentTarget = null;
    private boolean foundWaypoint = false;
    private int ticksSinceLastWaypoint = 0;

    public LeadPlayerGoal(class_3222 player, class_1308 entity, double speed) {
        super((class_1309)player);
        this.entity = entity;
        this.speed = speed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        this.totalWaypoints = this.random.nextInt(14) + 6;
    }

    @Override
    public boolean method_6264() {
        return super.method_6264() && !this.foundWaypoint && this.entity.method_5858((class_1297)this.targetEntity) <= 256.0 && !this.foundWaypoint;
    }

    public boolean method_6266() {
        return super.method_6264() && !this.foundWaypoint && this.entity.method_5858((class_1297)this.targetEntity) <= 256.0 && !this.foundWaypoint;
    }

    public void method_6268() {
        ++this.ticksSinceLastWaypoint;
        if (this.entity.method_5858((class_1297)this.targetEntity) > 256.0) {
            this.entity.method_5942().method_6340();
            return;
        }
        if (this.currentWaypoint >= this.totalWaypoints && !this.foundWaypoint) {
            this.foundWaypoint = true;
            LOGGER.info("Tick: You have ARRIVED at your destination");
            ServerPackets.scheduler.scheduleTask(() -> {
                String arrivedMessage = "<You have arrived at your destination>";
                ChatDataManager chatDataManager = ChatDataManager.getServerInstance();
                EntityChatData chatData = chatDataManager.getOrCreateChatData(this.entity.method_5845());
                if (!chatData.characterSheet.isEmpty()) {
                    if (chatData.auto_generated < ChatDataManager.MAX_AUTOGENERATE_RESPONSES) {
                        EventQueueManager.addUserMessage((class_1297)this.entity, "N/A", (class_3222)this.targetEntity, arrivedMessage, true);
                    }
                }
            });
            this.entity.method_5942().method_6340();
        } else if (this.currentTarget == null || this.entity.method_5707(this.currentTarget) < 4.0 || this.ticksSinceLastWaypoint >= 200) {
            this.setNewTarget();
            this.moveToTarget();
            this.ticksSinceLastWaypoint = 0;
        } else {
            this.moveToTarget();
        }
    }

    private void moveToTarget() {
        if (this.currentTarget != null) {
            if (this.entity instanceof class_1314) {
                class_11 path;
                if (!this.entity.method_5942().method_23966() && (path = this.entity.method_5942().method_6352(this.currentTarget.field_1352, this.currentTarget.field_1351, this.currentTarget.field_1350, 1)) != null) {
                    LOGGER.debug("Start moving along path");
                    this.entity.method_5942().method_6334(path, this.speed);
                }
            } else {
                LookControls.lookAtPosition(this.currentTarget, this.entity);
                class_243 entityPos = this.entity.method_19538();
                class_243 moveDirection = this.currentTarget.method_1020(entityPos).method_1029();
                double currentSpeed = this.entity.method_18798().method_37267();
                currentSpeed = class_3532.method_15348((float)((float)currentSpeed), (float)((float)this.speed), (float)((float)(0.005 * (this.speed / Math.max(currentSpeed, 0.1)))));
                class_243 newVelocity = new class_243(moveDirection.field_1352 * currentSpeed, moveDirection.field_1351 * currentSpeed, moveDirection.field_1350 * currentSpeed);
                this.entity.method_18799(newVelocity);
                this.entity.field_6037 = true;
            }
        }
    }

    private void setNewTarget() {
        ++this.currentWaypoint;
        LOGGER.info("Waypoint " + this.currentWaypoint + " / " + this.totalWaypoints);
        this.currentTarget = RandomTargetFinder.findRandomTarget(this.entity, 30.0, 24.0, 36.0);
        if (this.currentTarget != null) {
            this.emitParticlesAlongRaycast(this.entity.method_19538(), this.currentTarget);
        }
        this.entity.method_5942().method_6340();
    }

    private void emitParticleAt(class_243 position, double angle) {
        if (this.entity.method_37908() instanceof class_3218) {
            class_3218 serverWorld = (class_3218)this.entity.method_37908();
            LeadParticleEffect effect = new LeadParticleEffect((float)angle);
            serverWorld.method_14199((class_2394)effect, position.field_1352, position.field_1351 + 0.05, position.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void emitParticlesAlongRaycast(class_243 start, class_243 end) {
        class_243 direction = end.method_1020(start);
        double angleRadians = Math.atan2(direction.field_1350, direction.field_1352);
        double angleDegrees = Math.toDegrees(angleRadians);
        double minecraftYaw = (360.0 - (angleDegrees + 90.0)) % 360.0;
        if ((minecraftYaw = (minecraftYaw + 180.0) % 360.0) < 0.0) {
            minecraftYaw += 360.0;
        }
        double distance = start.method_1022(end);
        double startRange = Math.min(5.0, distance);
        double endRange = Math.min(startRange + 10.0, distance);
        for (double d = startRange; d <= endRange; d += 5.0) {
            class_243 pos = start.method_1019(direction.method_1029().method_1021(d));
            this.emitParticleAt(pos, Math.toRadians(minecraftYaw));
        }
    }
}

