/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.mixin;

import com.owlmaddie.chat.ChatDataManager;
import java.util.UUID;
import net.minecraft.class_1308;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_5761;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_5761.class})
public interface MixinBucketable {
    @Inject(method={"saveDefaultDataToBucketTag(Lnet/minecraft/world/entity/Mob;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="TAIL")})
    private static void addCPUUIDToStack(class_1308 entity, class_1799 stack, CallbackInfo ci) {
        Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");
        UUID originalUUID = entity.method_5667();
        LOGGER.info("Saving original UUID of bucketed entity: " + String.valueOf(originalUUID));
        class_2487 nbt = stack.method_7948();
        nbt.method_25927("CPUUID", originalUUID);
    }

    @Inject(method={"loadDefaultDataFromBucketTag(Lnet/minecraft/world/entity/Mob;Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private static void readCPUUIDFromNbt(class_1308 entity, class_2487 nbt, CallbackInfo ci) {
        Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");
        UUID newUUID = entity.method_5667();
        if (nbt.method_10545("CPUUID")) {
            UUID originalUUID = nbt.method_25926("CPUUID");
            LOGGER.info("Duplicating bucketed chat data for original UUID (" + String.valueOf(originalUUID) + ") to cloned entity: (" + String.valueOf(newUUID) + ")");
            ChatDataManager.getServerInstance().updateUUID(originalUUID.toString(), newUUID.toString());
        }
    }
}

