/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.network;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.owlmaddie.chat.ChatDataManager;
import com.owlmaddie.chat.ClientChatDataManager;
import com.owlmaddie.chat.EntityChatDataLight;
import com.owlmaddie.chat.PlayerData;
import com.owlmaddie.network.ClientBufferHelper;
import com.owlmaddie.network.ClientPacketHelper;
import com.owlmaddie.network.ServerPackets;
import com.owlmaddie.player2.TTS;
import com.owlmaddie.player2.auth.OAuthThroughChat;
import com.owlmaddie.player2.auth.Player2OAuthHandler;
import com.owlmaddie.ui.BubbleRenderer;
import com.owlmaddie.ui.PlayerMessageManager;
import com.owlmaddie.utils.ClientEntityFinder;
import com.owlmaddie.utils.Decompression;
import com.owlmaddie.utils.SerializationGSON;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ClientPackets {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");
    static HashMap<Integer, byte[]> receivedChunks = new HashMap();

    public static void sendGenerateGreeting(class_1297 entity) {
        String userLanguageCode = class_310.method_1551().method_1526().method_4669();
        String userLanguageName = class_310.method_1551().method_1526().method_4668(userLanguageCode).method_48303().getString();
        class_2540 buf = ClientBufferHelper.create();
        buf.method_10814(entity.method_5845());
        buf.method_10814(userLanguageName);
        ClientPacketHelper.send(ServerPackets.PACKET_C2S_GREETING, buf);
    }

    public static void sendUpdateLineNumber(class_1297 entity, Integer lineNumber) {
        class_2540 buf = ClientBufferHelper.create();
        buf.method_10814(entity.method_5845());
        buf.writeInt(lineNumber.intValue());
        ClientPacketHelper.send(ServerPackets.PACKET_C2S_READ_NEXT, buf);
    }

    public static void sendOpenChat(class_1297 entity) {
        class_2540 buf = ClientBufferHelper.create();
        buf.method_10814(entity.method_5845());
        ClientPacketHelper.send(ServerPackets.PACKET_C2S_OPEN_CHAT, buf);
    }

    public static void sendCloseChat() {
        class_2540 buf = ClientBufferHelper.create();
        ClientPacketHelper.send(ServerPackets.PACKET_C2S_CLOSE_CHAT, buf);
    }

    public static void setChatStatus(class_1297 entity, ChatDataManager.ChatStatus new_status) {
        class_2540 buf = ClientBufferHelper.create();
        buf.method_10814(entity.method_5845());
        buf.method_10814(new_status.toString());
        ClientPacketHelper.send(ServerPackets.PACKET_C2S_SET_STATUS, buf);
    }

    public static void sendChat(class_1297 entity, String message) {
        String userLanguageCode = class_310.method_1551().method_1526().method_4669();
        String userLanguageName = class_310.method_1551().method_1526().method_4668(userLanguageCode).method_48303().getString();
        class_2540 buf = ClientBufferHelper.create();
        buf.method_10814(entity.method_5845());
        buf.method_10814(message);
        buf.method_10814(userLanguageName);
        ClientPacketHelper.send(ServerPackets.PACKET_C2S_SEND_CHAT, buf);
    }

    public static void sendAuthResponse(UUID requestId, String key) {
        class_2540 buf = ClientBufferHelper.create();
        buf.method_10814(requestId.toString());
        buf.method_10814(key);
        ClientPacketHelper.send(ServerPackets.PACKET_C2S_AUTH_RESPONSE, buf);
    }

    public static void sendAuthFixedError() {
        LOGGER.info("Client: sending auth fixed error");
        class_2540 buf = ClientBufferHelper.create();
        ClientPacketHelper.send(ServerPackets.PACKET_C2S_AUTH_FIXED_ERROR, buf);
    }

    public static Map<String, PlayerData> readPlayerDataMap(class_2540 buffer) {
        int size = buffer.readInt();
        HashMap<String, PlayerData> map = new HashMap<String, PlayerData>();
        for (int i = 0; i < size; ++i) {
            String key = buffer.method_19772();
            PlayerData data = new PlayerData();
            data.friendship = buffer.readInt();
            map.put(key, data);
        }
        return map;
    }

    public static void register() {
        ClientPacketHelper.registerReceiver(ServerPackets.PACKET_S2C_ENTITY_MESSAGE, (client, handler, buffer, responseSender) -> {
            UUID entityId = UUID.fromString(buffer.method_19772());
            String message = buffer.method_10800(Short.MAX_VALUE);
            int line = buffer.readInt();
            String status_name = buffer.method_10800(Short.MAX_VALUE);
            ChatDataManager.ChatStatus status = ChatDataManager.ChatStatus.valueOf(status_name);
            String sender_name = buffer.method_10800(Short.MAX_VALUE);
            ChatDataManager.ChatSender sender = ChatDataManager.ChatSender.valueOf(sender_name);
            Map<String, PlayerData> players = ClientPackets.readPlayerDataMap(buffer);
            client.execute(() -> {
                if (client.field_1724 == null || client.field_1687 == null) {
                    LOGGER.warn("Client not fully initialized. Dropping message for entity '{}'.", (Object)entityId);
                    return;
                }
                EntityChatDataLight chatData = ClientChatDataManager.getOrCreateChatData(entityId.toString());
                if (message != null && !message.isEmpty()) {
                    chatData.currentMessage = message;
                }
                chatData.currentLineNumber = line;
                chatData.status = status;
                chatData.sender = sender;
                chatData.players = players;
                class_1308 entity = ClientEntityFinder.getEntityByUUID(client.field_1687, entityId);
                if (entity != null) {
                    ClientPackets.playNearbyUISound(client, (class_1297)entity, 0.2f);
                }
                if (status == ChatDataManager.ChatStatus.DISPLAY && chatData.sender == ChatDataManager.ChatSender.ASSISTANT) {
                    if (message.contains("Error:")) {
                        return;
                    }
                    TTS.speak(message, entityId);
                }
            });
        });
        ClientPacketHelper.registerReceiver(ServerPackets.PACKET_S2C_PLAYER_MESSAGE, (client, handler, buffer, responseSender) -> {
            UUID senderPlayerId = UUID.fromString(buffer.method_19772());
            String senderPlayerName = buffer.method_10800(Short.MAX_VALUE);
            String message = buffer.method_10800(Short.MAX_VALUE);
            client.execute(() -> {
                if (client.field_1724 == null || client.field_1687 == null) {
                    LOGGER.warn("Client not fully initialized. Dropping message for sender '{}'.", (Object)senderPlayerId);
                    return;
                }
                PlayerMessageManager.addMessage(senderPlayerId, message, senderPlayerName, ChatDataManager.TICKS_TO_DISPLAY_USER_MESSAGE);
            });
        });
        ClientPacketHelper.registerReceiver(ServerPackets.PACKET_S2C_LOGIN, (client, handler, buffer, responseSender) -> {
            int sequenceNumber = buffer.readInt();
            int totalPackets = buffer.readInt();
            byte[] chunk = buffer.method_10795();
            client.execute(() -> {
                receivedChunks.put(sequenceNumber, chunk);
                if (receivedChunks.size() == totalPackets) {
                    LOGGER.info("Reassemble chunks on client and decompress lite JSON data string");
                    ByteArrayOutputStream combined = new ByteArrayOutputStream();
                    for (int i = 0; i < totalPackets; ++i) {
                        combined.write(receivedChunks.get(i), 0, receivedChunks.get(i).length);
                    }
                    String chatDataJSON = Decompression.decompressString(combined.toByteArray());
                    if (chatDataJSON == null || chatDataJSON.isEmpty()) {
                        LOGGER.warn("Received invalid or empty chat data JSON. Skipping processing.");
                        return;
                    }
                    Gson GSON = SerializationGSON.GSON;
                    Type type = new TypeToken<ConcurrentHashMap<String, EntityChatDataLight>>(){}.getType();
                    ClientChatDataManager.entityChatDataMap = (ConcurrentHashMap)GSON.fromJson(chatDataJSON, type);
                    receivedChunks.clear();
                }
            });
        });
        ClientPacketHelper.registerReceiver(ServerPackets.PACKET_S2C_WHITELIST, (client, handler, buffer, responseSender) -> {
            int whitelistSize = buffer.readInt();
            ArrayList<String> whitelist = new ArrayList<String>(whitelistSize);
            for (int i = 0; i < whitelistSize; ++i) {
                whitelist.add(buffer.method_10800(Short.MAX_VALUE));
            }
            int blacklistSize = buffer.readInt();
            ArrayList<String> blacklist = new ArrayList<String>(blacklistSize);
            for (int i = 0; i < blacklistSize; ++i) {
                blacklist.add(buffer.method_10800(Short.MAX_VALUE));
            }
            client.execute(() -> {
                BubbleRenderer.whitelist = whitelist;
                BubbleRenderer.blacklist = blacklist;
            });
        });
        ClientPacketHelper.registerReceiver(ServerPackets.PACKET_S2C_PLAYER_STATUS, (client, handler, buffer, responseSender) -> {
            UUID playerId = UUID.fromString(buffer.method_19772());
            boolean isChatOpen = buffer.readBoolean();
            class_1657 player = ClientEntityFinder.getPlayerEntityFromUUID(playerId);
            client.execute(() -> {
                if (player == null) {
                    LOGGER.warn("Player entity is null. Skipping status update.");
                    return;
                }
                if (isChatOpen) {
                    PlayerMessageManager.openChatUI(playerId);
                    ClientPackets.playNearbyUISound(client, (class_1297)player, 0.2f);
                } else {
                    PlayerMessageManager.closeChatUI(playerId);
                }
            });
        });
        ClientPacketHelper.registerReceiver(ServerPackets.PACKET_S2C_UNAUTH_ERR, (client, handler, buffer, responseSender) -> {
            LOGGER.info("Client: recieved unauth err");
            OAuthThroughChat.handleAuthError();
        });
        ClientPacketHelper.registerReceiver(ServerPackets.PACKET_S2C_AUTH_REQUEST, (client, handler, buffer, responseSender) -> {
            UUID requestId = UUID.fromString(buffer.method_19772());
            if (client != null) {
                client.execute(() -> {
                    String key = Player2OAuthHandler.getApiKey();
                    if (key != null && !key.isEmpty()) {
                        Player2OAuthHandler.setApiKey(key);
                    }
                    ClientPackets.sendAuthResponse(requestId, key == null ? "" : key);
                    LOGGER.info("Responded to server auth request {} with {}key.", (Object)requestId, (Object)(key == null || key.isEmpty() ? "no " : ""));
                });
            }
        });
        ClientPacketHelper.registerReceiver(ServerPackets.PACKET_S2C_SET_TTS, (client, handler, buffer, responseSender) -> {
            boolean status = buffer.readBoolean();
            client.execute(() -> {
                TTS.enabled = status;
            });
        });
    }

    private static void playNearbyUISound(class_310 client, class_1297 player, float maxVolume) {
        double distance;
        int distance_squared = 144;
        if (client.field_1724 != null && (distance = client.field_1724.method_5649(player.method_23317(), player.method_23318(), player.method_23321())) <= (double)distance_squared) {
            float volume = maxVolume - (float)distance / (float)distance_squared * maxVolume;
            client.field_1724.method_5783((class_3414)class_3417.field_15015.comp_349(), volume, 0.8f);
        }
    }
}

