/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.network;

import com.owlmaddie.chat.ChatDataManager;
import com.owlmaddie.chat.ChatDataSaverScheduler;
import com.owlmaddie.chat.ChatGPTRequest;
import com.owlmaddie.chat.ClientSideEffects;
import com.owlmaddie.chat.EntityChatData;
import com.owlmaddie.chat.EntityChatDataLight;
import com.owlmaddie.chat.EventQueueManager;
import com.owlmaddie.chat.PlayerData;
import com.owlmaddie.commands.ConfigurationHandler;
import com.owlmaddie.goals.EntityBehaviorManager;
import com.owlmaddie.goals.GoalPriority;
import com.owlmaddie.goals.TalkPlayerGoal;
import com.owlmaddie.network.BufferHelper;
import com.owlmaddie.network.ClickEventHelper;
import com.owlmaddie.network.PacketHelper;
import com.owlmaddie.particle.Particles;
import com.owlmaddie.utils.Compression;
import com.owlmaddie.utils.ServerEntityFinder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerPackets {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");
    public static MinecraftServer serverInstance;
    public static ChatDataSaverScheduler scheduler;
    public static final class_2960 PACKET_C2S_GREETING;
    public static final class_2960 PACKET_C2S_READ_NEXT;
    public static final class_2960 PACKET_C2S_SET_STATUS;
    public static final class_2960 PACKET_C2S_OPEN_CHAT;
    public static final class_2960 PACKET_C2S_CLOSE_CHAT;
    public static final class_2960 PACKET_C2S_SEND_CHAT;
    public static final class_2960 PACKET_C2S_AUTH_RESPONSE;
    public static final class_2960 PACKET_C2S_AUTH_FIXED_ERROR;
    public static final class_2960 PACKET_S2C_AUTH_REQUEST;
    public static final class_2960 PACKET_S2C_ENTITY_MESSAGE;
    public static final class_2960 PACKET_S2C_PLAYER_MESSAGE;
    public static final class_2960 PACKET_S2C_LOGIN;
    public static final class_2960 PACKET_S2C_WHITELIST;
    public static final class_2960 PACKET_S2C_PLAYER_STATUS;
    public static final class_2960 PACKET_S2C_UNAUTH_ERR;
    public static final class_2960 PACKET_S2C_SET_TTS;
    public static final class_2396<?> HEART_SMALL_PARTICLE;
    public static final class_2396<?> HEART_BIG_PARTICLE;
    public static final class_2396<?> FIRE_SMALL_PARTICLE;
    public static final class_2396<?> FIRE_BIG_PARTICLE;
    public static final class_2396<?> ATTACK_PARTICLE;
    public static final class_2396<?> FLEE_PARTICLE;
    public static final class_2396<?> FOLLOW_FRIEND_PARTICLE;
    public static final class_2396<?> FOLLOW_ENEMY_PARTICLE;
    public static final class_2396<?> PROTECT_PARTICLE;
    public static final class_2396<?> LEAD_FRIEND_PARTICLE;
    public static final class_2396<?> LEAD_ENEMY_PARTICLE;
    public static final class_2396<?> LEAD_PARTICLE;
    private static final Map<UUID, UUID> pendingAuthRequests;

    public static void register() {
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960("creaturepals", "heart_small"), HEART_SMALL_PARTICLE);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960("creaturepals", "heart_big"), HEART_BIG_PARTICLE);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960("creaturepals", "fire_small"), FIRE_SMALL_PARTICLE);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960("creaturepals", "fire_big"), FIRE_BIG_PARTICLE);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960("creaturepals", "attack"), ATTACK_PARTICLE);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960("creaturepals", "flee"), FLEE_PARTICLE);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960("creaturepals", "follow_enemy"), FOLLOW_ENEMY_PARTICLE);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960("creaturepals", "follow_friend"), FOLLOW_FRIEND_PARTICLE);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960("creaturepals", "protect"), PROTECT_PARTICLE);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960("creaturepals", "lead_enemy"), LEAD_ENEMY_PARTICLE);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960("creaturepals", "lead_friend"), LEAD_FRIEND_PARTICLE);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960("creaturepals", "lead"), LEAD_PARTICLE);
        PacketHelper.registerReceiver(PACKET_C2S_GREETING, (server, player, buf) -> {
            UUID entityId = UUID.fromString(buf.method_19772());
            String userLanguage = buf.method_10800(Short.MAX_VALUE);
            server.execute(() -> {
                class_1308 entity = (class_1308)ServerEntityFinder.getEntityByUUID((class_3218)player.method_37908(), entityId);
                if (entity != null) {
                    EntityChatData chatData = ChatDataManager.getServerInstance().getOrCreateChatData(entity.method_5845());
                    if (chatData.characterSheet.isEmpty()) {
                        LOGGER.info("C2S_GREETING");
                        EventQueueManager.addGreeting((class_1297)entity, userLanguage, player);
                    }
                }
            });
        });
        PacketHelper.registerReceiver(PACKET_C2S_READ_NEXT, (server, player, buf) -> {
            UUID entityId = UUID.fromString(buf.method_19772());
            int lineNumber = buf.readInt();
            server.execute(() -> {
                class_1308 entity = (class_1308)ServerEntityFinder.getEntityByUUID((class_3218)player.method_37908(), entityId);
                if (entity != null) {
                    TalkPlayerGoal talkGoal = new TalkPlayerGoal((class_3222)player, entity, 3.5);
                    EntityBehaviorManager.addGoal(entity, talkGoal, GoalPriority.TALK_PLAYER);
                    LOGGER.info("ServerPackets/read_Next entityID={} lineNumber={} playerID={}", new Object[]{entityId, lineNumber, player.method_5667()});
                    EntityChatData chatData = ChatDataManager.getServerInstance().getOrCreateChatData(entity.method_5845());
                    LOGGER.info("Update read lines to " + lineNumber + " for: " + entity.method_5864().toString());
                    ClientSideEffects.setLineNumberUsingParamsFromChatData(entity.method_5845(), lineNumber);
                }
            });
        });
        PacketHelper.registerReceiver(PACKET_C2S_SET_STATUS, (server, player, buf) -> {
            UUID entityId = UUID.fromString(buf.method_19772());
            String status_name = buf.method_10800(Short.MAX_VALUE);
            LOGGER.info("ServerPackets/setStatus entityID={} status={} playerID={}", new Object[]{entityId, status_name, player.method_5667()});
            server.execute(() -> {
                class_1308 entity = (class_1308)ServerEntityFinder.getEntityByUUID((class_3218)player.method_37908(), entityId);
                if (entity != null) {
                    TalkPlayerGoal talkGoal = new TalkPlayerGoal((class_3222)player, entity, 3.5);
                    EntityBehaviorManager.addGoal(entity, talkGoal, GoalPriority.TALK_PLAYER);
                    ClientSideEffects.setStatusUsingParamsFromChatData(entity.method_5845(), ChatDataManager.ChatStatus.valueOf(status_name));
                }
            });
        });
        PacketHelper.registerReceiver(PACKET_C2S_OPEN_CHAT, (server, player, buf) -> {
            UUID entityId = UUID.fromString(buf.method_19772());
            server.execute(() -> {
                class_1308 entity = (class_1308)ServerEntityFinder.getEntityByUUID((class_3218)player.method_37908(), entityId);
                if (entity != null) {
                    TalkPlayerGoal talkGoal = new TalkPlayerGoal((class_3222)player, entity, 7.0);
                    EntityBehaviorManager.addGoal(entity, talkGoal, GoalPriority.TALK_PLAYER);
                }
                ServerPackets.BroadcastPlayerStatus((class_1657)player, true);
            });
        });
        PacketHelper.registerReceiver(PACKET_C2S_AUTH_RESPONSE, (server, player, buf) -> {
            UUID requestId = UUID.fromString(buf.method_19772());
            String apiKey = buf.method_19772();
            server.execute(() -> {
                if (ChatGPTRequest.apiKeyAwaiter.get(requestId) != null) {
                    ChatGPTRequest.apiKeyAwaiter.remove(requestId).complete(apiKey);
                }
            });
        });
        PacketHelper.registerReceiver(PACKET_C2S_CLOSE_CHAT, (server, player, buf) -> server.execute(() -> ServerPackets.BroadcastPlayerStatus((class_1657)player, false)));
        PacketHelper.registerReceiver(PACKET_C2S_SEND_CHAT, (server, player, buf) -> {
            UUID entityId = UUID.fromString(buf.method_19772());
            String message = buf.method_10800(Short.MAX_VALUE);
            String userLanguage = buf.method_10800(Short.MAX_VALUE);
            class_1309 ent = ServerEntityFinder.getEntityByUUID((class_3218)player.method_37908(), entityId);
            String RHS = ent != null && ent.method_5797() != null && !ent.method_5797().equals((Object)"N/A") ? "> (to " + ent.method_5797().getString() + ") " : "> ";
            LOGGER.info("ServerPackets/sendChat entityID={} message={} playerID={}", new Object[]{entityId, message, player.method_5667()});
            ServerPackets.BroadcastMessage((class_2561)class_2561.method_43470((String)("<" + player.method_5477().getString() + RHS + message)));
            server.execute(() -> {
                class_1308 entity = (class_1308)ServerEntityFinder.getEntityByUUID((class_3218)player.method_37908(), entityId);
                if (entity != null) {
                    ChatDataManager.getServerInstance().getOrCreateChatData(entity.method_5845());
                    EventQueueManager.addUserMessage((class_1297)entity, userLanguage, player, message, false);
                    ClientSideEffects.setPending(entity.method_5845());
                }
            });
        });
        PacketHelper.registerReceiver(PACKET_C2S_AUTH_FIXED_ERROR, (server, player, buf) -> {
            LOGGER.info("Server: recieved packet that auth error was fixed.");
            EventQueueManager.fixedAuthError(player);
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.field_14140;
            ServerPackets.send_whitelist_blacklist(player);
            LOGGER.info("Server send compressed, chunked login message packets to player: " + player.method_5477().getString());
            String chatDataJSON = ChatDataManager.getServerInstance().GetLightChatData(player.method_5476().getString());
            byte[] compressedData = Compression.compressString(chatDataJSON);
            if (compressedData == null) {
                LOGGER.error("Failed to compress chat data.");
                return;
            }
            int chunkSize = 32000;
            int totalPackets = (int)Math.ceil((double)compressedData.length / 32000.0);
            for (int i = 0; i < totalPackets; ++i) {
                int start = i * 32000;
                int end = Math.min(compressedData.length, start + 32000);
                class_2540 buffer = BufferHelper.create();
                buffer.writeInt(i);
                buffer.writeInt(totalPackets);
                byte[] chunk = Arrays.copyOfRange(compressedData, start, end);
                buffer.method_10813(chunk);
                PacketHelper.send(player, PACKET_S2C_LOGIN, buffer);
            }
            ConfigurationHandler.Config config = new ConfigurationHandler(server).loadConfig();
            String serverApiKey = config.getApiKey();
            if (serverApiKey == null || serverApiKey.isEmpty()) {
                ServerPackets.requestPlayerApiKey(player);
            }
        });
        ServerWorldEvents.LOAD.register((server, world) -> {
            String world_name = world.method_27983().method_29177().method_12832();
            if (world_name.equals("overworld")) {
                serverInstance = server;
                ChatDataManager.getServerInstance().loadChatData(server);
                scheduler = new ChatDataSaverScheduler();
                scheduler.startAutoSaveTask(server, 15L, TimeUnit.MINUTES);
            }
        });
        ServerWorldEvents.UNLOAD.register((server, world) -> {
            String world_name = world.method_27983().method_29177().method_12832();
            if (world_name == "overworld") {
                ChatDataManager.getServerInstance().saveChatData(server);
                serverInstance = null;
                if (scheduler != null) {
                    scheduler.stopAutoSaveTask();
                    scheduler = null;
                }
            }
        });
        ServerEntityEvents.ENTITY_UNLOAD.register((entity, world) -> {
            String entityUUID = entity.method_5845();
            if (entity.method_35049() == class_1297.class_5529.field_26998 && ChatDataManager.getServerInstance().entityChatDataMap.containsKey(entityUUID)) {
                LOGGER.debug("Entity killed (" + entityUUID + "), updating death time stamp.");
                ChatDataManager.getServerInstance().entityChatDataMap.get((Object)entityUUID).death = System.currentTimeMillis();
            }
        });
    }

    public static void send_whitelist_blacklist(class_3222 player) {
        ConfigurationHandler.Config config = new ConfigurationHandler(serverInstance).loadConfig();
        class_2540 buffer = BufferHelper.create();
        List<String> whitelist = config.getWhitelist();
        buffer.writeInt(whitelist.size());
        for (String entry : whitelist) {
            buffer.method_10814(entry);
        }
        List<String> blacklist = config.getBlacklist();
        buffer.writeInt(blacklist.size());
        for (String entry : blacklist) {
            buffer.method_10814(entry);
        }
        if (player != null) {
            LOGGER.info("Sending whitelist / blacklist packet to player: " + player.method_5477().getString());
            PacketHelper.send(player, PACKET_S2C_WHITELIST, buffer);
        } else {
            for (class_3222 serverPlayer : serverInstance.method_3760().method_14571()) {
                PacketHelper.send(serverPlayer, PACKET_S2C_WHITELIST, buffer);
            }
        }
    }

    public static void writePlayerDataMap(class_2540 buffer, Map<String, PlayerData> map) {
        buffer.writeInt(map.size());
        for (Map.Entry<String, PlayerData> entry : map.entrySet()) {
            buffer.method_10814(entry.getKey());
            PlayerData data = entry.getValue();
            buffer.writeInt(data.friendship);
        }
    }

    public static void BroadcastEntityMessage(EntityChatDataLight chatData) {
        LOGGER.info("Broadcasting entity message: entityId={}, status={}, currentMessage={}, currentLineNumber={}, senderType={}", new Object[]{chatData.entityId, chatData.status, chatData.currentMessage.length() > 24 ? chatData.currentMessage.substring(0, 24) + "..." : chatData.currentMessage, chatData.currentLineNumber, chatData.sender});
        for (class_3222 player : serverInstance.method_3760().method_14571()) {
            class_2540 buffer = BufferHelper.create();
            buffer.method_10814(chatData.entityId);
            buffer.method_10814(chatData.currentMessage);
            buffer.writeInt(chatData.currentLineNumber);
            buffer.method_10814(chatData.status.toString());
            buffer.method_10814(chatData.sender.toString());
            ServerPackets.writePlayerDataMap(buffer, chatData.players);
            PacketHelper.send(player, PACKET_S2C_ENTITY_MESSAGE, buffer);
        }
    }

    public static void BroadcastPlayerMessage(EntityChatData chatData, class_3222 sender) {
        LOGGER.info("Broadcasting player message: senderUUID={}, message={}", (Object)sender.method_5845(), (Object)chatData.currentMessage);
        class_2540 buffer = BufferHelper.create();
        buffer.method_10814(sender.method_5845());
        buffer.method_10814(sender.method_5476().getString());
        buffer.method_10814(chatData.currentMessage);
        for (class_3222 serverPlayer : serverInstance.method_3760().method_14571()) {
            PacketHelper.send(serverPlayer, PACKET_S2C_PLAYER_MESSAGE, buffer);
        }
    }

    public static void BroadcastPlayerStatus(class_1657 player, boolean isChatOpen) {
        class_2540 buffer = BufferHelper.create();
        buffer.method_10814(player.method_5845());
        buffer.writeBoolean(isChatOpen);
        for (class_3222 serverPlayer : serverInstance.method_3760().method_14571()) {
            LOGGER.debug("Server broadcast " + player.method_5477().getString() + " player status to client: " + serverPlayer.method_5477().getString() + " | isChatOpen: " + isChatOpen);
            PacketHelper.send(serverPlayer, PACKET_S2C_PLAYER_STATUS, buffer);
        }
    }

    public static void SendTTSStatus(class_3222 player, boolean tts) {
        class_2540 buf = BufferHelper.create();
        buf.writeBoolean(tts);
        PacketHelper.send(player, PACKET_S2C_SET_TTS, buf);
    }

    public static void BroadcastUnauthErr(class_3222 player) {
        LOGGER.info("Server: Sending unauth err packet");
        class_2540 buffer = BufferHelper.create();
        PacketHelper.send(player, PACKET_S2C_UNAUTH_ERR, buffer);
    }

    public static void BroadcastMessage(class_2561 message) {
        for (class_3222 serverPlayer : serverInstance.method_3760().method_14571()) {
            serverPlayer.method_7353(message, false);
        }
    }

    public static void SendClickableError(class_1657 player, String message, String url) {
        class_5250 text = class_2561.method_43470((String)message).method_27692(class_124.field_1061).method_27694(style -> style.method_10958(ClickEventHelper.openUrl(url)).method_30938(Boolean.valueOf(true)));
        player.method_7353((class_2561)text, false);
    }

    public static void sendErrorToAllOps(MinecraftServer server, String message) {
        for (class_3222 player : server.method_3760().method_14571()) {
            if (!server.method_3760().method_14569(player.method_7334())) continue;
            ServerPackets.SendClickableError((class_1657)player, message, "https://player2.game/discord");
        }
    }

    public static UUID requestPlayerApiKey(class_3222 player) {
        UUID requestId = UUID.randomUUID();
        pendingAuthRequests.put(requestId, player.method_5667());
        return ServerPackets.requestPlayerApiKeyWithId(player, requestId);
    }

    public static UUID requestPlayerApiKeyWithId(class_3222 player, UUID requestId) {
        class_2540 buffer = BufferHelper.create();
        buffer.method_10814(requestId.toString());
        PacketHelper.send(player, PACKET_S2C_AUTH_REQUEST, buffer);
        LOGGER.info("Sent API key request to '{}' with requestId={}", (Object)player.method_7334().getName(), (Object)requestId);
        return requestId;
    }

    static {
        scheduler = null;
        PACKET_C2S_GREETING = new class_2960("creaturepals", "packet_c2s_greeting");
        PACKET_C2S_READ_NEXT = new class_2960("creaturepals", "packet_c2s_read_next");
        PACKET_C2S_SET_STATUS = new class_2960("creaturepals", "packet_c2s_set_status");
        PACKET_C2S_OPEN_CHAT = new class_2960("creaturepals", "packet_c2s_open_chat");
        PACKET_C2S_CLOSE_CHAT = new class_2960("creaturepals", "packet_c2s_close_chat");
        PACKET_C2S_SEND_CHAT = new class_2960("creaturepals", "packet_c2s_send_chat");
        PACKET_C2S_AUTH_RESPONSE = new class_2960("creaturepals", "packet_c2s_auth_response");
        PACKET_C2S_AUTH_FIXED_ERROR = new class_2960("creaturepals", "packet_c2s_auth_fixed_error");
        PACKET_S2C_AUTH_REQUEST = new class_2960("creaturepals", "packet_s2c_auth_request");
        PACKET_S2C_ENTITY_MESSAGE = new class_2960("creaturepals", "packet_s2c_entity_message");
        PACKET_S2C_PLAYER_MESSAGE = new class_2960("creaturepals", "packet_s2c_player_message");
        PACKET_S2C_LOGIN = new class_2960("creaturepals", "packet_s2c_login");
        PACKET_S2C_WHITELIST = new class_2960("creaturepals", "packet_s2c_whitelist");
        PACKET_S2C_PLAYER_STATUS = new class_2960("creaturepals", "packet_s2c_player_status");
        PACKET_S2C_UNAUTH_ERR = new class_2960("creaturepals", "packet_s2c_unauth_err");
        PACKET_S2C_SET_TTS = new class_2960("creaturepals", "packet_s2c_set_tts");
        HEART_SMALL_PARTICLE = Particles.HEART_SMALL_PARTICLE;
        HEART_BIG_PARTICLE = Particles.HEART_BIG_PARTICLE;
        FIRE_SMALL_PARTICLE = Particles.FIRE_SMALL_PARTICLE;
        FIRE_BIG_PARTICLE = Particles.FIRE_BIG_PARTICLE;
        ATTACK_PARTICLE = Particles.ATTACK_PARTICLE;
        FLEE_PARTICLE = Particles.FLEE_PARTICLE;
        FOLLOW_FRIEND_PARTICLE = Particles.FOLLOW_FRIEND_PARTICLE;
        FOLLOW_ENEMY_PARTICLE = Particles.FOLLOW_ENEMY_PARTICLE;
        PROTECT_PARTICLE = Particles.PROTECT_PARTICLE;
        LEAD_FRIEND_PARTICLE = Particles.LEAD_FRIEND_PARTICLE;
        LEAD_ENEMY_PARTICLE = Particles.LEAD_ENEMY_PARTICLE;
        LEAD_PARTICLE = Particles.LEAD_PARTICLE;
        pendingAuthRequests = new ConcurrentHashMap<UUID, UUID>();
    }
}

