/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.chat;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.owlmaddie.chat.EntityChatData;
import com.owlmaddie.network.ServerPackets;
import com.owlmaddie.utils.SerializationGSON;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatDataManager {
    private static final ChatDataManager SERVER_INSTANCE = new ChatDataManager(true);
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");
    public static int MAX_CHAR_PER_LINE = 20;
    public static int DISPLAY_NUM_LINES = 3;
    public static int MAX_CHAR_IN_USER_MESSAGE = 512;
    public static int TICKS_TO_DISPLAY_USER_MESSAGE = 70;
    public static int MAX_AUTOGENERATE_RESPONSES = 3;
    private static final Gson GSON = new Gson();
    public ConcurrentHashMap<String, EntityChatData> entityChatDataMap = new ConcurrentHashMap();

    public void clearData() {
        this.entityChatDataMap.clear();
    }

    private ChatDataManager(Boolean server_only) {
        if (server_only.booleanValue()) {
            // empty if block
        }
    }

    public static ChatDataManager getServerInstance() {
        return SERVER_INSTANCE;
    }

    public EntityChatData getOrCreateChatData(String entityId) {
        return this.entityChatDataMap.computeIfAbsent(entityId, k -> new EntityChatData(entityId));
    }

    public void updateUUID(String oldUUID, String newUUID) {
        EntityChatData data = this.entityChatDataMap.remove(oldUUID);
        if (data != null) {
            data.entityId = newUUID;
            this.entityChatDataMap.put(newUUID, data);
            LOGGER.info("Updated chat data from UUID (" + oldUUID + ") to UUID (" + newUUID + ")");
            ServerPackets.BroadcastEntityMessage(data.toLightVersion(data.getPlayer().method_5477().getString()));
        } else {
            LOGGER.info("Unable to update chat data, UUID not found: " + oldUUID);
        }
    }

    public String GetLightChatData(String playerName) {
        try {
            HashMap lightVersionMap = new HashMap();
            this.entityChatDataMap.forEach((name, entityChatData) -> lightVersionMap.put(name, entityChatData.toLightVersion(playerName)));
            return SerializationGSON.GSON.toJson(lightVersionMap);
        }
        catch (Exception e) {
            return "";
        }
    }

    public void saveChatData(MinecraftServer server) {
        File saveFile = new File(server.method_27050(class_5218.field_24188).toFile(), "chatdata.json");
        LOGGER.info("Saving chat data to " + saveFile.getAbsolutePath());
        this.entityChatDataMap.values().removeIf(entityChatData -> entityChatData.status == ChatStatus.NONE);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(saveFile), StandardCharsets.UTF_8);){
            SerializationGSON.GSON.toJson(this.entityChatDataMap, (Appendable)writer);
        }
        catch (Exception e) {
            String errorMessage = "Error saving `chatdata.json`. No CreaturePals chat history was saved! " + e.getMessage();
            LOGGER.error(errorMessage, (Throwable)e);
            ServerPackets.sendErrorToAllOps(server, errorMessage);
        }
    }

    public void loadChatData(MinecraftServer server) {
        File loadFile = new File(server.method_27050(class_5218.field_24188).toFile(), "chatdata.json");
        LOGGER.info("Loading chat data from " + loadFile.getAbsolutePath());
        if (loadFile.exists()) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(loadFile), StandardCharsets.UTF_8);){
                Type type = new TypeToken<ConcurrentHashMap<String, EntityChatData>>(){}.getType();
                this.entityChatDataMap = (ConcurrentHashMap)SerializationGSON.GSON.fromJson((Reader)reader, type);
                this.entityChatDataMap.values().removeIf(entityChatData -> entityChatData.status == ChatStatus.NONE);
                for (EntityChatData entityChatData2 : this.entityChatDataMap.values()) {
                    entityChatData2.postDeserializeInitialization();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error loading chat data", (Throwable)e);
                this.entityChatDataMap = new ConcurrentHashMap();
            }
        } else {
            this.entityChatDataMap = new ConcurrentHashMap();
        }
    }

    public static enum ChatStatus {
        NONE,
        PENDING,
        DISPLAY,
        HIDDEN;

    }

    public static enum ChatSender {
        USER,
        ASSISTANT;

    }
}

