/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.chat;

import com.owlmaddie.chat.BehaviorApplier;
import com.owlmaddie.chat.ChatDataManager;
import com.owlmaddie.chat.ChatMessage;
import com.owlmaddie.chat.EntityChatData;
import com.owlmaddie.chat.EntityChatDataLight;
import com.owlmaddie.chat.EventQueueManager;
import com.owlmaddie.chat.PlayerData;
import com.owlmaddie.message.MessageParser;
import com.owlmaddie.message.ParsedMessage;
import com.owlmaddie.network.ServerPackets;
import com.owlmaddie.utils.Randomizer;
import com.owlmaddie.utils.ServerEntityFinder;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSideEffects {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");

    private static EntityChatData getChatData(UUID entityId) {
        return ChatDataManager.getServerInstance().getOrCreateChatData(entityId.toString());
    }

    public static void onEntityGeneratedMessage(String entityId, String uncleanEntityMessageResponse, class_3222 player) {
        LOGGER.info("sideEffect/onEntityGeneratedMessage entityId={} uncleanEntityResponse={} player={}", new Object[]{entityId, uncleanEntityMessageResponse, player});
        ParsedMessage result = MessageParser.parseMessage(uncleanEntityMessageResponse.replace("\n", " "));
        PlayerData playerData = ClientSideEffects.getChatData(UUID.fromString(entityId)).getPlayerData(player.method_5845());
        BehaviorApplier.apply(result.getBehaviors(), player, entityId, playerData);
        String cleanedMessage = result.getCleanedMessage();
        if (cleanedMessage.isEmpty()) {
            ClientSideEffects.getChatData(UUID.fromString(entityId)).addMessage("...", ChatDataManager.ChatSender.ASSISTANT, player);
            ServerPackets.BroadcastEntityMessage(new EntityChatDataLight(entityId, "...", 0, ChatDataManager.ChatStatus.DISPLAY, ChatDataManager.ChatSender.ASSISTANT, ClientSideEffects.getChatData((UUID)UUID.fromString((String)entityId)).characterSheet, ClientSideEffects.getChatData((UUID)UUID.fromString((String)entityId)).players));
        } else {
            ClientSideEffects.getChatData(UUID.fromString(entityId)).addMessage(uncleanEntityMessageResponse, ChatDataManager.ChatSender.ASSISTANT, player);
            ClientSideEffects.sendChatAsEntity(entityId, cleanedMessage, player, true);
        }
    }

    public static void onCharacterSheetGenerated(String entityId, String characterSheet, boolean shouldGreet, class_3222 player) {
        LOGGER.info("sideEffect/onCharacterSheetGen entityid={} characterSheet={} shouldGreet={} player={}", new Object[]{entityId, characterSheet, shouldGreet, player});
        ClientSideEffects.getChatData((UUID)UUID.fromString((String)entityId)).characterSheet = characterSheet;
        String characterName = Optional.ofNullable(ClientSideEffects.getChatData(UUID.fromString(entityId)).getCharacterProp("name")).filter(s -> !s.isEmpty()).orElse("N/A");
        if (characterName.equals("N/A")) {
            throw new RuntimeException("Generated \"\" or \"N/A\" as a character name");
        }
        String shortGreeting = Optional.ofNullable(ClientSideEffects.getChatData(UUID.fromString(entityId)).getCharacterProp("short greeting")).filter(s -> !s.isEmpty()).orElse(Randomizer.getRandomMessage(Randomizer.RandomType.NO_RESPONSE)).replace("\n", " ");
        ClientSideEffects.setNameOfEntity(entityId, characterName);
        if (shouldGreet) {
            ClientSideEffects.getChatData(UUID.fromString(entityId)).addMessage(shortGreeting, ChatDataManager.ChatSender.ASSISTANT, player);
            ClientSideEffects.sendChatAsEntity(entityId, shortGreeting, player, true);
        }
    }

    private static void setNameOfEntity(String entityId, String characterName) {
        LOGGER.info("SideEffect/setNameOfEntity entityId={} characterName={}", (Object)entityId, (Object)characterName);
        for (class_3218 world : ServerPackets.serverInstance.method_3738()) {
            class_1308 entity = (class_1308)ServerEntityFinder.getEntityByUUID(world, UUID.fromString(entityId));
            if (entity == null || characterName.isEmpty() || characterName.equals("N/A") || entity.method_5797() != null) continue;
            LOGGER.debug("Setting MC Server Entity name to " + characterName + " for " + entityId);
            entity.method_5665((class_2561)class_2561.method_43470((String)characterName));
            entity.method_5880(true);
            entity.method_5971();
        }
    }

    public static void onLLMGenerateError(String entityId, String errMsg, class_3222 player) {
        LOGGER.error("Side effect: onLLMGenerateError, clearing msg. errMsg={}", (Object)errMsg);
        Object errorMessage = "Error: ";
        errorMessage = (String)errorMessage + EntityChatData.truncateString(errMsg, 55) + "\n";
        errorMessage = (String)errorMessage + "Help is available at player2.game/discord";
        EntityChatData data = ClientSideEffects.getChatData(UUID.fromString(entityId));
        data.setError((String)errorMessage);
        if (errMsg.contains("Connection refused")) {
            LOGGER.info("Connection refused error! handling case");
            String displayedErrorMessage = "Error: Player2 must be running. Download and run Player2.\nhttps://player2.game\n";
            ClientSideEffects.sendChatAsEntity(entityId, displayedErrorMessage, player, false);
            ServerPackets.SendClickableError((class_1657)player, displayedErrorMessage, "https://player2.game");
            ServerPackets.SendClickableError((class_1657)player, "If Player2 is running and it still doesn't work, make a ticket on discord.\nhttps://player2.game/discord", "https://player2.game/discord");
            return;
        }
        if (errMsg.contains("Unauthorized")) {
            EventQueueManager.unauthError(player);
            ServerPackets.BroadcastUnauthErr(player);
            ClientSideEffects.sendChatAsEntity(entityId, "Please authorize to use AI features.", player, false);
            return;
        }
        ClientSideEffects.sendChatAsEntity(entityId, (String)errorMessage, player, false);
        LOGGER.error("After chat as ent ");
        ClientSideEffects.getChatData((UUID)UUID.fromString((String)entityId)).status = ChatDataManager.ChatStatus.DISPLAY;
        LOGGER.info("Sending clickable error");
        ServerPackets.SendClickableError((class_1657)player, (String)errorMessage, "https://player2.game/discord");
    }

    public static void sendChatAsEntity(String entityId, String message, class_3222 player, boolean shouldBroadcast) {
        LOGGER.info("SIDEEFFECT/sendChatAsEntity entityId={} message={} ", (Object)entityId.toString(), (Object)message);
        ServerPackets.BroadcastEntityMessage(new EntityChatDataLight(entityId, message, 0, ChatDataManager.ChatStatus.DISPLAY, ChatDataManager.ChatSender.ASSISTANT, ClientSideEffects.getChatData((UUID)UUID.fromString((String)entityId)).characterSheet, ClientSideEffects.getChatData((UUID)UUID.fromString((String)entityId)).players));
        LOGGER.info("Finding entity ");
        class_1309 entity = ServerEntityFinder.getEntityByUUID((class_3218)player.method_37908(), UUID.fromString(entityId));
        LOGGER.info("Custom name");
        if (entity == null || entity.method_5797() == null) {
            return;
        }
        String entityCustomName = entity.method_5797().getString();
        LOGGER.info("Find entity Type");
        String entityType = entity.method_5864().method_35050();
        LOGGER.info("player broadcast");
        if (shouldBroadcast) {
            ServerPackets.BroadcastMessage((class_2561)class_2561.method_43470((String)("<" + entityCustomName + " the " + entityType + "> " + message)));
        }
    }

    public static void setPending(String entityId) {
        LOGGER.info("SIDEEFFECT/setPending entityId={} ", (Object)entityId.toString());
        if (ClientSideEffects.getChatData((UUID)UUID.fromString((String)entityId)).previousMessages.size() == 0) {
            ServerPackets.BroadcastEntityMessage(new EntityChatDataLight(entityId, "", 0, ChatDataManager.ChatStatus.PENDING, ChatDataManager.ChatSender.USER, ClientSideEffects.getChatData((UUID)UUID.fromString((String)entityId)).characterSheet, ClientSideEffects.getChatData((UUID)UUID.fromString((String)entityId)).players));
            return;
        }
        ClientSideEffects.setStatusUsingParamsFromChatData(entityId, ChatDataManager.ChatStatus.PENDING);
    }

    public static void setStatusUsingParamsFromChatData(String entityId, ChatDataManager.ChatStatus status) {
        LOGGER.info("SideEffect/setStatusUSingParamsFromChatData entityId={} status={}", (Object)entityId, (Object)status);
        if (ClientSideEffects.getChatData((UUID)UUID.fromString((String)entityId)).previousMessages.size() == 0) {
            throw new RuntimeException("Only call setStatusUsingParamsFromChatData when msgs > 0");
        }
        ChatMessage topMessage = ClientSideEffects.getChatData(UUID.fromString(entityId)).getTopMessage();
        ClientSideEffects.getChatData((UUID)UUID.fromString((String)entityId)).status = status;
        ServerPackets.BroadcastEntityMessage(new EntityChatDataLight(entityId, topMessage.message, ClientSideEffects.getChatData((UUID)UUID.fromString((String)entityId)).currentLineNumber, status, topMessage.sender, ClientSideEffects.getChatData((UUID)UUID.fromString((String)entityId)).characterSheet, ClientSideEffects.getChatData((UUID)UUID.fromString((String)entityId)).players));
    }

    public static void updateUUID(UUID oldUUID, UUID newUUID) {
        throw new RuntimeException("implement this");
    }

    public static void setLineNumberUsingParamsFromChatData(String entityId, int lineNumber) {
        ChatMessage topMessage = ClientSideEffects.getChatData(UUID.fromString(entityId)).getTopMessage();
        LOGGER.info("sideEffect/setLineNumber entityId={} lineNumber={} topMessage.message={}", new Object[]{entityId, lineNumber, topMessage.message});
        int totalLines = ClientSideEffects.getChatData(UUID.fromString(entityId)).getWrappedLines().size();
        ClientSideEffects.getChatData((UUID)UUID.fromString((String)entityId)).currentLineNumber = Math.min(Math.max(lineNumber, 0), totalLines);
        ServerPackets.BroadcastEntityMessage(new EntityChatDataLight(entityId, topMessage.message, ClientSideEffects.getChatData((UUID)UUID.fromString((String)entityId)).currentLineNumber, ChatDataManager.ChatStatus.DISPLAY, topMessage.sender, ClientSideEffects.getChatData((UUID)UUID.fromString((String)entityId)).characterSheet, ClientSideEffects.getChatData((UUID)UUID.fromString((String)entityId)).players));
    }
}

