/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.chat;

import com.owlmaddie.chat.ClientSideEffects;
import com.owlmaddie.chat.EventQueueData;
import com.owlmaddie.network.PacketHelper;
import com.owlmaddie.utils.ServerEntityFinder;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventQueueManager {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");
    private static boolean addingEntityQueues = false;
    private static Set<class_3222> unauthPlayers = new HashSet<class_3222>();
    private static List<LLMCompleter> completers = List.of(new LLMCompleter());
    private static ConcurrentHashMap<String, EventQueueData> queueData = new ConcurrentHashMap();
    private static Set<String> entityIdsToAdd = new HashSet<String>();

    public static void addEntityIdToCreate(String entityId) {
        entityIdsToAdd.add(entityId);
    }

    public static void addGreeting(class_1297 entity, String userLangauge, class_3222 player) {
        if (player == null) {
            throw new RuntimeException("Null player for addGreeting");
        }
        LOGGER.info("AddGreeting, entityId={} playerID={}", (Object)entity.method_5667(), (Object)player.method_5667());
        ClientSideEffects.setPending(entity.method_5845());
        EventQueueManager.getOrCreateQueueData(entity.method_5845(), entity).requestGreeting(userLangauge, player);
    }

    private static Optional<String> getEntityIdToProcess(MinecraftServer server) {
        return queueData.values().stream().filter(EventQueueData::shouldProcess).filter(data -> !unauthPlayers.contains(data.getPlayer())).max(Comparator.comparingInt(EventQueueData::getPriority)).map(EventQueueData::getId);
    }

    private static void errorCooldown(String entityId) {
        queueData.get(entityId).errorCooldown();
    }

    public static void injectOnServerTick(MinecraftServer server) {
        EventQueueManager.tryAddAllNewEntities(server);
        EventQueueManager.removeDeadEntities();
        if (addingEntityQueues) {
            return;
        }
        for (LLMCompleter completer : completers) {
            if (!completer.isAvailable()) {
                return;
            }
            Optional<String> entityIdOption = EventQueueManager.getEntityIdToProcess(server);
            entityIdOption.ifPresent(entityId -> {
                LOGGER.info("PRESENT " + entityId);
                ClientSideEffects.setPending(entityId);
                completer.process((String)entityId, (uncleanMsg, player) -> ClientSideEffects.onEntityGeneratedMessage(entityId, uncleanMsg, player), (errMsg, player) -> {
                    ClientSideEffects.onLLMGenerateError(entityId, errMsg, player);
                    EventQueueManager.errorCooldown(entityId);
                }, (characterSheet, shouldGreet, player) -> ClientSideEffects.onCharacterSheetGenerated(entityId, characterSheet, shouldGreet, player));
            });
        }
    }

    public static EventQueueData getOrCreateQueueData(String entityId, class_1297 entity) {
        return queueData.computeIfAbsent(entityId, k -> {
            LOGGER.info(String.format("EventQueueManager/creating new queue data for ent id (%s)", entityId));
            return new EventQueueData(entityId, entity);
        });
    }

    private static void removeDeadEntities() {
        for (EventQueueData curQueue : queueData.values()) {
            if (!curQueue.shouldDelete()) continue;
            queueData.remove(curQueue.getId());
        }
    }

    private static void tryAddAllNewEntities(MinecraftServer server) {
        Iterator<String> iterator = entityIdsToAdd.iterator();
        while (iterator.hasNext()) {
            String entityId = iterator.next();
            boolean added = false;
            for (class_3222 player : server.method_3760().method_14571()) {
                class_1309 cur = ServerEntityFinder.getEntityByUUID((class_3218)player.method_37908(), UUID.fromString(entityId));
                if (cur == null) continue;
                LOGGER.info("tryAddAllNewEntities entityId={}", (Object)entityId);
                EventQueueManager.getOrCreateQueueData(entityId, (class_1297)cur);
                added = true;
                break;
            }
            if (!added) continue;
            iterator.remove();
        }
    }

    public static void updateUUID(String oldId, String newId, class_1297 newEntity) {
        EventQueueData data = queueData.remove(oldId);
        if (data == null) {
            LOGGER.info("Unable to update chat data, UUID not found: " + oldId);
            return;
        }
        data.updateUUID(newId, newEntity);
        queueData.put(newId, data);
    }

    public static void addUserMessage(class_1297 entity, String userLanguage, class_3222 player, String userMessage, boolean is_auto_message) {
        LOGGER.info("Add user message entityID={}, playerID={}, message={} ", new Object[]{entity.method_5845(), player.method_5667(), userMessage});
        EventQueueData q = EventQueueManager.getOrCreateQueueData(entity.method_5845(), entity);
        q.addUserMessage(entity, userLanguage, player, userMessage, is_auto_message);
    }

    public static void addUserMessageToAllClose(String userLanguage, class_3222 player, String userMessage, boolean is_auto_message) {
        addingEntityQueues = true;
        ServerEntityFinder.getCloseEntities((class_3218)player.method_37908(), player, 6.0).stream().filter(e -> !(e instanceof class_1657)).forEach(e -> {
            LOGGER.info("Sending user msg={} to ent_id={}", (Object)userMessage, (Object)e.method_5845());
            EventQueueManager.getOrCreateQueueData(e.method_5845(), e);
            EventQueueManager.addUserMessage(e, userLanguage, player, userMessage, is_auto_message);
        });
        addingEntityQueues = false;
    }

    public static void unauthError(class_3222 player) {
        unauthPlayers.add(player);
    }

    public static void fixedAuthError(class_3222 player) {
        unauthPlayers.remove(player);
    }

    private static class LLMCompleter {
        private boolean isProcessing = false;

        private LLMCompleter() {
        }

        public boolean isAvailable() {
            return !this.isProcessing;
        }

        public void process(String entityId, BiConsumer<String, class_3222> onUncleanResponse, BiConsumer<String, class_3222> onError, PacketHelper.TriConsumer<String, Boolean, class_3222> onCharacterSheetAndShouldGreet) {
            LOGGER.info("LLMCompleter/processing entityId={}", (Object)entityId);
            this.isProcessing = true;
            queueData.get(entityId).process((resp, player) -> {
                LOGGER.info("LLMCompleter/doneProcessing/Success entityId={} resp={}", (Object)entityId, resp);
                onUncleanResponse.accept((String)resp, (class_3222)player);
                this.isProcessing = false;
            }, (errMsg, player) -> {
                LOGGER.info("LLMCompleter/doneProcessing/Error entityId={} errMsg={}", (Object)entityId, errMsg);
                onError.accept((String)errMsg, (class_3222)player);
                this.isProcessing = false;
            }, (characterSheet, shouldGreet, player) -> {
                LOGGER.info("LLMCompleter/doneProcessing/Greeting entityId={} characterSheet={} shouldGreet={}", new Object[]{entityId, characterSheet, shouldGreet});
                onCharacterSheetAndShouldGreet.accept((String)characterSheet, (Boolean)shouldGreet, (class_3222)player);
                this.isProcessing = shouldGreet == false;
            });
        }
    }
}

