/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.controls;

import com.owlmaddie.controls.ISquidEntity;
import net.minecraft.class_1308;
import net.minecraft.class_1432;
import net.minecraft.class_1477;
import net.minecraft.class_1571;
import net.minecraft.class_1593;
import net.minecraft.class_1621;
import net.minecraft.class_1634;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class LookControls {
    public static void lookAtPlayer(class_3222 player, class_1308 entity) {
        class_243 playerPos = player.method_19538();
        float eyeHeight = player.method_18381(player.method_18376());
        class_243 eyePos = new class_243(playerPos.field_1352, playerPos.field_1351 + (double)eyeHeight, playerPos.field_1350);
        LookControls.lookAtPosition(eyePos, entity);
    }

    public static void lookAtPosition(class_243 targetPos, class_1308 entity) {
        if (entity instanceof class_1621) {
            LookControls.handleSlimeLook((class_1621)entity, targetPos);
        } else if (entity instanceof class_1477) {
            LookControls.handleSquidLook((class_1477)entity, targetPos);
        } else if (entity instanceof class_1571) {
            LookControls.handleFlyingEntity(entity, targetPos, 10.0f);
        } else if (entity instanceof class_1432 || entity instanceof class_1634 || entity instanceof class_1593) {
            LookControls.handleFlyingEntity(entity, targetPos, 4.0f);
        } else {
            entity.method_5988().method_6230(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, 10.0f, (float)entity.method_5978());
        }
    }

    private static void handleSlimeLook(class_1621 slime, class_243 targetPos) {
        float yawChange = LookControls.calculateYawChange((class_1308)slime, targetPos);
        ((class_1621.class_1625)slime.method_5962()).method_7165(slime.method_36454() + yawChange, false);
    }

    private static void handleSquidLook(class_1477 squid, class_243 targetPos) {
        class_243 toPlayer = LookControls.calculateNormalizedDirection((class_1308)squid, targetPos);
        class_243 swimVec = toPlayer.method_1021((double)0.15f);
        ((ISquidEntity)squid).forceSwimVector(swimVec);
        squid.method_18799(swimVec);
        if (squid.method_19538().method_1022(targetPos) < 3.5) {
            ((ISquidEntity)squid).forceSwimVector(class_243.field_1353);
            squid.method_18800(0.0, 0.0, 0.0);
        }
    }

    private static void handleFlyingEntity(class_1308 flyingEntity, class_243 targetPos, float stopDistance) {
        class_243 flyingPosition = flyingEntity.method_19538();
        class_243 toPlayer = targetPos.method_1020(flyingPosition).method_1029();
        float targetYaw = (float)(class_3532.method_15349((double)toPlayer.field_1350, (double)toPlayer.field_1352) * 57.29577951308232 - 90.0);
        flyingEntity.method_36456(targetYaw);
        flyingEntity.method_5988().method_6230(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, 10.0f, (float)flyingEntity.method_5978());
        float initialSpeed = 0.15f;
        flyingEntity.method_18800((double)((float)toPlayer.field_1352 * initialSpeed), (double)((float)toPlayer.field_1351 * initialSpeed), (double)((float)toPlayer.field_1350 * initialSpeed));
        double distanceToPlayer = flyingEntity.method_19538().method_1022(targetPos);
        if (distanceToPlayer < (double)stopDistance) {
            flyingEntity.method_18800(0.0, 0.0, 0.0);
        }
    }

    public static float calculateYawChange(class_1308 entity, class_243 targetPos) {
        class_243 toPlayer = LookControls.calculateNormalizedDirection(entity, targetPos);
        float targetYaw = (float)Math.toDegrees(Math.atan2(toPlayer.field_1350, toPlayer.field_1352)) - 90.0f;
        float yawDifference = class_3532.method_15393((float)(targetYaw - entity.method_36454()));
        return class_3532.method_15363((float)yawDifference, (float)-10.0f, (float)10.0f);
    }

    public static class_243 calculateNormalizedDirection(class_1308 entity, class_243 targetPos) {
        class_243 entityPos = entity.method_19538();
        return targetPos.method_1020(entityPos).method_1029();
    }
}

