/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.goals;

import com.owlmaddie.controls.DamageHelper;
import com.owlmaddie.goals.PlayerBaseGoal;
import com.owlmaddie.network.ServerPackets;
import java.util.EnumSet;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1427;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_5354;

public class AttackPlayerGoal
extends PlayerBaseGoal {
    protected final class_1308 attackerEntity;
    protected final double speed;
    protected EntityState currentState = EntityState.IDLE;
    protected int cooldownTimer = 0;
    protected final int CHARGE_TIME = 12;
    protected final double MOVE_DISTANCE = 200.0;
    protected final double CHARGE_DISTANCE = 25.0;
    protected final double ATTACK_DISTANCE = 4.0;

    public AttackPlayerGoal(class_1309 targetEntity, class_1308 attackerEntity, double speed) {
        super(targetEntity);
        this.attackerEntity = attackerEntity;
        this.speed = speed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18408));
    }

    @Override
    public boolean method_6264() {
        return super.method_6264() && this.isGoalActive();
    }

    public boolean method_6266() {
        return super.method_6264() && this.isGoalActive();
    }

    public void method_6270() {
        AttackPlayerGoal.stopAttack(this.attackerEntity);
    }

    private boolean isGoalActive() {
        if (this.targetEntity == null || this.targetEntity != null && !this.targetEntity.method_5805()) {
            return false;
        }
        if (!this.attackerEntity.equals((Object)this.targetEntity)) {
            this.attackerEntity.method_5980(this.targetEntity);
        }
        boolean isNearby = this.attackerEntity.method_5858((class_1297)this.targetEntity) < 200.0;
        boolean isNearbyAndNoNativeAttacks = isNearby && !this.hasNativeAttacks();
        class_1308 livingAttackerEntity = this.attackerEntity;
        boolean hasNativeAttacksButCannotTarget = isNearby && this.hasNativeAttacks() && !livingAttackerEntity.method_18395(this.targetEntity);
        return isNearbyAndNoNativeAttacks || hasNativeAttacksButCannotTarget;
    }

    private boolean hasNativeAttacks() {
        return this.attackerEntity instanceof class_1588 || this.attackerEntity instanceof class_5354 || this.attackerEntity instanceof class_1603 || this.attackerEntity instanceof class_1427;
    }

    private void performAttack() {
        if (!this.attackerEntity.equals((Object)this.targetEntity)) {
            this.targetEntity.method_6015((class_1309)this.attackerEntity);
        }
        DamageHelper.applyLeapDamage((class_1309)this.attackerEntity, this.targetEntity, 1.0f);
        this.attackerEntity.method_5783(class_3417.field_15115, 1.0f, 1.0f);
        int numParticles = ThreadLocalRandom.current().nextInt(2, 7);
        ((class_3218)this.attackerEntity.method_37908()).method_14199((class_2394)ServerPackets.ATTACK_PARTICLE, this.targetEntity.method_23317(), this.targetEntity.method_23323(0.5), this.targetEntity.method_23321(), numParticles, 0.5, 0.5, 0.1, 0.4);
    }

    public void method_6268() {
        double squaredDistanceToPlayer = this.attackerEntity.method_5858((class_1297)this.targetEntity);
        this.attackerEntity.method_5988().method_6226((class_1297)this.targetEntity, 30.0f, 30.0f);
        switch (this.currentState.ordinal()) {
            case 1: {
                this.cooldownTimer = 12;
                if (squaredDistanceToPlayer < 4.0) {
                    this.currentState = EntityState.ATTACKING;
                    break;
                }
                if (squaredDistanceToPlayer < 25.0) {
                    this.currentState = EntityState.CHARGING;
                    break;
                }
                if (!(squaredDistanceToPlayer < 200.0)) break;
                this.currentState = EntityState.MOVING_TOWARDS_PLAYER;
                break;
            }
            case 0: {
                this.attackerEntity.method_5942().method_6335((class_1297)this.targetEntity, this.speed);
                if (squaredDistanceToPlayer < 25.0) {
                    this.currentState = EntityState.CHARGING;
                    break;
                }
                this.currentState = EntityState.IDLE;
                break;
            }
            case 2: {
                this.attackerEntity.method_5942().method_6335((class_1297)this.targetEntity, this.speed / 2.5);
                if (this.cooldownTimer > 0) break;
                this.currentState = EntityState.LEAPING;
                break;
            }
            case 4: {
                class_243 leapDirection = new class_243(this.targetEntity.method_23317() - this.attackerEntity.method_23317(), 0.1, this.targetEntity.method_23321() - this.attackerEntity.method_23321()).method_1029().method_1021(1.0);
                this.attackerEntity.method_18799(leapDirection);
                this.attackerEntity.field_6037 = true;
                this.currentState = EntityState.ATTACKING;
                break;
            }
            case 3: {
                this.attackerEntity.method_5942().method_6335((class_1297)this.targetEntity, this.speed / 2.5);
                if (squaredDistanceToPlayer < 4.0 && this.cooldownTimer <= 0) {
                    this.performAttack();
                    this.currentState = EntityState.IDLE;
                    break;
                }
                if (this.cooldownTimer > 0) break;
                this.currentState = EntityState.IDLE;
            }
        }
        --this.cooldownTimer;
    }

    public static void stopAttack(class_1308 entity) {
        entity.method_5980(null);
        if (entity instanceof class_5354) {
            class_5354 n = (class_5354)entity;
            n.method_29513(null);
            n.method_29514(0);
        }
    }

    protected static enum EntityState {
        MOVING_TOWARDS_PLAYER,
        IDLE,
        CHARGING,
        ATTACKING,
        LEAPING;

    }
}

