/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.player2;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.owlmaddie.player2.Player2AudioHandler;
import com.owlmaddie.player2.auth.Player2OAuthHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class Player2APIService {
    static Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");
    private static final String BASE_URL = "https://api.player2.game";

    private static String getApiKey() {
        return Player2OAuthHandler.getApiKey();
    }

    private static Map<String, JsonElement> sendRequest(String endpoint, boolean postRequest, JsonObject requestBody) throws Exception {
        String line;
        int responseCode;
        String apiKey = Player2APIService.getApiKey();
        if (apiKey == null || apiKey.isEmpty()) {
            LOGGER.info("Player2APIKey env variable not set");
            throw new IllegalStateException("PLAYER2_API_KEY environment variable is not set");
        }
        LOGGER.info("Sending request to url={}", (Object)(BASE_URL + endpoint));
        URL url = new URI(BASE_URL + endpoint).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(postRequest ? "POST" : "GET");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Authorization", "Bearer " + apiKey);
        LOGGER.debug("Sending %s request to %s\n", (Object)(postRequest ? "POST" : "GET"), (Object)(BASE_URL + endpoint));
        if (postRequest && requestBody != null) {
            LOGGER.debug("Request Body: %s\n", (Object)requestBody);
            connection.setDoOutput(true);
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = requestBody.toString().getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
        }
        if ((responseCode = connection.getResponseCode()) != 200) {
            InputStream errorStream = connection.getErrorStream();
            if (errorStream != null) {
                String errorLine;
                BufferedReader errorReader = new BufferedReader(new InputStreamReader(errorStream, StandardCharsets.UTF_8));
                StringBuilder errorResponse = new StringBuilder();
                while ((errorLine = errorReader.readLine()) != null) {
                    errorResponse.append(errorLine);
                }
                errorReader.close();
                LOGGER.error("Error response: " + String.valueOf(errorResponse));
            }
            throw new IOException("HTTP " + responseCode + ": " + connection.getResponseMessage());
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        StringBuilder response = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            response.append(line);
        }
        reader.close();
        JsonObject jsonResponse = JsonParser.parseString((String)response.toString()).getAsJsonObject();
        HashMap<String, JsonElement> responseMap = new HashMap<String, JsonElement>();
        for (Map.Entry entry : jsonResponse.entrySet()) {
            responseMap.put((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        LOGGER.debug("DONE %s request to %s \n", (Object)(postRequest ? "POST" : "GET"), (Object)endpoint);
        return responseMap;
    }

    public static void sendHeartbeat() {
        try {
            LOGGER.debug("Sending Heartbeat to Player2 API");
            Map<String, JsonElement> responseMap = Player2APIService.sendRequest("/v1/health", false, null);
            if (responseMap.containsKey("status")) {
                String status = responseMap.get("status").getAsString();
                LOGGER.debug("Heartbeat Successful - Status: " + status);
            }
        }
        catch (Exception e) {
            LOGGER.error("Heartbeat Fail: %s", (Object)e.getMessage());
        }
    }

    public static void textToSpeech(String message, String voiceId, UUID entityId) {
        block10: {
            try {
                JsonObject requestBody = new JsonObject();
                requestBody.addProperty("text", message);
                JsonArray voiceIdsArray = new JsonArray();
                voiceIdsArray.add(voiceId);
                requestBody.add("voice_ids", (JsonElement)voiceIdsArray);
                requestBody.addProperty("speed", (Number)1.0);
                requestBody.addProperty("audio_format", "wav");
                LOGGER.debug("Sending TTS request: " + message);
                Map<String, JsonElement> response = null;
                try {
                    response = Player2APIService.sendRequest("/v1/tts/speak", true, requestBody);
                    if (!response.containsKey("data")) break block10;
                    String audioData = response.get("data").getAsString();
                    LOGGER.debug("TTS audio generated: " + audioData);
                    try {
                        File tempFile = File.createTempFile("player2_tts_", ".wav");
                        if (audioData.startsWith("data:")) {
                            String base64Data = audioData.substring(audioData.indexOf(",") + 1);
                            byte[] audioBytes = Base64.getDecoder().decode(base64Data);
                            Files.write(tempFile.toPath(), audioBytes, new OpenOption[0]);
                            LOGGER.debug("Decoded base64 audio data to: " + tempFile.getAbsolutePath());
                        } else {
                            URL url = new URL(audioData);
                            InputStream in = url.openStream();
                            Files.copy(in, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            in.close();
                            LOGGER.debug("Downloaded TTS audio to: " + tempFile.getAbsolutePath());
                        }
                        boolean playbackStarted = Player2AudioHandler.playAudioFile(tempFile, entityId);
                        if (playbackStarted) {
                            LOGGER.debug("TTS audio playback started successfully");
                        } else {
                            LOGGER.error("Failed to start TTS audio playback");
                        }
                        tempFile.deleteOnExit();
                    }
                    catch (Exception ex) {
                        LOGGER.error("Failed to play TTS audio: " + ex.getMessage());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static List<JsonObject> getVoices() {
        try {
            Map<String, JsonElement> responseMap = Player2APIService.sendRequest("/v1/tts/voices", false, null);
            JsonElement voicesJsonElement = responseMap.get("voices");
            if (voicesJsonElement != null && voicesJsonElement.isJsonArray()) {
                JsonArray voicesJsonArray = voicesJsonElement.getAsJsonArray();
                ArrayList<JsonObject> voiceIds = new ArrayList<JsonObject>();
                for (JsonElement voiceElement : voicesJsonArray) {
                    JsonObject voiceObject = voiceElement.getAsJsonObject();
                    voiceIds.add(voiceObject);
                }
                return voiceIds;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to get voices: " + e.getMessage());
        }
        return Collections.emptyList();
    }

    public static Map<String, JsonElement> createChatCompletion(List<JsonObject> messages, String model) {
        try {
            JsonObject requestBody = new JsonObject();
            requestBody.addProperty("model", model);
            requestBody.add("messages", new Gson().toJsonTree(messages));
            requestBody.addProperty("max_tokens", (Number)1000);
            requestBody.addProperty("temperature", (Number)0.7);
            LOGGER.debug("Sending chat completion request");
            return Player2APIService.sendRequest("/v1/chat/completions", true, requestBody);
        }
        catch (Exception e) {
            LOGGER.error("Chat completion request failed: " + e.getMessage());
            return Collections.emptyMap();
        }
    }
}

