/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.player2;

import com.google.gson.JsonObject;
import com.owlmaddie.player2.Player2APIService;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class TTS {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");
    public static final ExecutorService ttsThread = Executors.newSingleThreadExecutor();
    public static ConcurrentHashMap<UUID, PerEntityTTS> entityTTSData = new ConcurrentHashMap();
    public static List<String> englishVoices = null;
    public static boolean enabled = true;
    private static final Random random = new Random();

    public static void speak(String message, UUID entityId) {
        LOGGER.info("client/tts/speak(msg={}, id={})", (Object)message, (Object)entityId);
        if (!enabled) {
            return;
        }
        ttsThread.submit(() -> {
            entityTTSData.computeIfAbsent(entityId, id -> {
                LOGGER.info("computing tts data for id={}", (Object)entityId);
                if (englishVoices == null || englishVoices.size() == 0) {
                    LOGGER.info("computing voices");
                    List<JsonObject> voices = Player2APIService.getVoices();
                    englishVoices = voices.stream().filter(jsonV -> {
                        if (jsonV.has("language")) {
                            String language = jsonV.get("language").getAsString();
                            return language.toLowerCase().contains("english");
                        }
                        if (jsonV.has("name")) {
                            String name = jsonV.get("name").getAsString();
                            return name.toLowerCase().contains("en") || name.toLowerCase().contains("english");
                        }
                        return true;
                    }).map(jsonV -> {
                        if (jsonV.has("id")) {
                            return jsonV.get("id").getAsString();
                        }
                        if (jsonV.has("voice_id")) {
                            return jsonV.get("voice_id").getAsString();
                        }
                        if (jsonV.has("name")) {
                            return jsonV.get("name").getAsString();
                        }
                        return "alloy";
                    }).toList();
                    if (englishVoices.isEmpty()) {
                        LOGGER.info("Setting default voices");
                        englishVoices = List.of("alloy", "echo", "fable", "onyx", "nova");
                    }
                }
                int index = random.nextInt(englishVoices.size());
                PerEntityTTS data = new PerEntityTTS(englishVoices.get(index), "");
                return data;
            });
            PerEntityTTS data = entityTTSData.get(entityId);
            if (data.lastMessage.equals(message)) {
                return;
            }
            data.lastMessage = message;
            Player2APIService.textToSpeech(message, data.voiceId, entityId);
        });
    }

    public static void initializeVoices() {
        ttsThread.submit(() -> {
            List<JsonObject> voices = Player2APIService.getVoices();
            if (!voices.isEmpty()) {
                System.out.println("Loaded " + voices.size() + " voices from Player2 API");
                englishVoices = voices.stream().filter(jsonV -> {
                    if (jsonV.has("language")) {
                        String language = jsonV.get("language").getAsString();
                        return language.toLowerCase().contains("english");
                    }
                    if (jsonV.has("name")) {
                        String name = jsonV.get("name").getAsString();
                        return name.toLowerCase().contains("en") || name.toLowerCase().contains("english");
                    }
                    return true;
                }).map(jsonV -> {
                    if (jsonV.has("id")) {
                        return jsonV.get("id").getAsString();
                    }
                    if (jsonV.has("voice_id")) {
                        return jsonV.get("voice_id").getAsString();
                    }
                    if (jsonV.has("name")) {
                        return jsonV.get("name").getAsString();
                    }
                    return "alloy";
                }).toList();
                if (englishVoices.isEmpty()) {
                    englishVoices = List.of("alloy", "echo", "fable", "onyx", "nova");
                }
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    static class PerEntityTTS {
        public String voiceId;
        public String lastMessage;

        public PerEntityTTS(String voiceId, String lastMessage) {
            this.voiceId = voiceId;
            this.lastMessage = lastMessage;
        }
    }
}

