/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.ui;

import com.owlmaddie.chat.ChatDataManager;
import com.owlmaddie.chat.ClientChatDataManager;
import com.owlmaddie.chat.EntityChatDataLight;
import com.owlmaddie.chat.PlayerData;
import com.owlmaddie.render.BlendHelper;
import com.owlmaddie.render.EntityTextureHelper;
import com.owlmaddie.render.QuadBuffer;
import com.owlmaddie.render.ShaderHelper;
import com.owlmaddie.skin.PlayerCustomTexture;
import com.owlmaddie.ui.BubbleLocationManager;
import com.owlmaddie.ui.EntityRenderPosition;
import com.owlmaddie.ui.PlayerMessageManager;
import com.owlmaddie.utils.EntityHeights;
import com.owlmaddie.utils.EntityRendererAccessor;
import com.owlmaddie.utils.TextureLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_897;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class BubbleRenderer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");
    protected static TextureLoader textures = new TextureLoader();
    public static int DISPLAY_PADDING = 2;
    public static int animationFrame = 0;
    public static long lastTick = 0L;
    public static int light = 0xF000F0;
    public static int overlay = class_4608.field_21444;
    public static List<String> whitelist = new ArrayList<String>();
    public static List<String> blacklist = new ArrayList<String>();
    private static int queryEntityDataCount = 0;
    private static List<class_1297> relevantEntities;

    public static void drawTextBubbleBackground(String base_name, class_4587 matrices, float x, float y, float width, float height, int friendship) {
        ShaderHelper.setTexturedShader();
        BlendHelper.enableBlend();
        BlendHelper.defaultBlendFunc();
        BlendHelper.enableDepthTest();
        BlendHelper.depthMask(true);
        QuadBuffer buffer = QuadBuffer.INSTANCE;
        float z = 0.01f;
        if (friendship == -3 && !base_name.endsWith("-player")) {
            TextureLoader.bind(0, textures.GetUI(base_name + "-enemy"));
        } else if (friendship == 3 && !base_name.endsWith("-player")) {
            TextureLoader.bind(0, textures.GetUI(base_name + "-friend"));
        } else {
            TextureLoader.bind(0, textures.GetUI(base_name));
        }
        BubbleRenderer.drawTexturePart(matrices, buffer, x - 50.0f, y, z, 228.0f, 40.0f);
        TextureLoader.bind(0, textures.GetUI("text-middle"));
        BubbleRenderer.drawTexturePart(matrices, buffer, x, y + 40.0f, z, width, height);
        TextureLoader.bind(0, textures.GetUI("text-bottom"));
        BubbleRenderer.drawTexturePart(matrices, buffer, x, y + 40.0f + height, z, width, 5.0f);
        BlendHelper.disableBlend();
        BlendHelper.disableDepthTest();
    }

    private static void drawTexturePart(class_4587 matrices, QuadBuffer buffer, float x, float y, float z, float width, float height) {
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        buffer.begin();
        buffer.vertex(matrix4f, x, y + height, z).color(255, 255, 255, 255).texture(0.0f, 1.0f).light(light).overlay(overlay);
        buffer.vertex(matrix4f, x + width, y + height, z).color(255, 255, 255, 255).texture(1.0f, 1.0f).light(light).overlay(overlay);
        buffer.vertex(matrix4f, x + width, y, z).color(255, 255, 255, 255).texture(1.0f, 0.0f).light(light).overlay(overlay);
        buffer.vertex(matrix4f, x, y, z).color(255, 255, 255, 255).texture(0.0f, 0.0f).light(light).overlay(overlay);
        buffer.draw();
    }

    private static void drawIcon(String ui_icon_name, class_4587 matrices, float x, float y, float width, float height) {
        class_2960 button_texture = textures.GetUI(ui_icon_name);
        ShaderHelper.setTexturedShader();
        TextureLoader.bind(0, button_texture);
        BlendHelper.enableBlend();
        BlendHelper.defaultBlendFunc();
        BlendHelper.enableDepthTest();
        BlendHelper.depthMask(true);
        QuadBuffer buffer = QuadBuffer.INSTANCE;
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        buffer.begin();
        buffer.vertex(matrix4f, x, y + height, 0.0f).color(255, 255, 255, 255).texture(0.0f, 1.0f).light(light).overlay(overlay);
        buffer.vertex(matrix4f, x + width, y + height, 0.0f).color(255, 255, 255, 255).texture(1.0f, 1.0f).light(light).overlay(overlay);
        buffer.vertex(matrix4f, x + width, y, 0.0f).color(255, 255, 255, 255).texture(1.0f, 0.0f).light(light).overlay(overlay);
        buffer.vertex(matrix4f, x, y, 0.0f).color(255, 255, 255, 255).texture(0.0f, 0.0f).light(light).overlay(overlay);
        buffer.draw();
        BlendHelper.disableBlend();
        BlendHelper.disableDepthTest();
    }

    private static void drawFriendshipStatus(class_4587 matrices, float x, float y, float width, float height, int friendship) {
        String ui_icon_name = "friendship" + friendship;
        ShaderHelper.setTexturedShader();
        class_2960 button_texture = textures.GetUI(ui_icon_name);
        TextureLoader.bind(0, button_texture);
        BlendHelper.enableBlend();
        BlendHelper.defaultBlendFunc();
        BlendHelper.enableDepthTest();
        BlendHelper.depthMask(true);
        QuadBuffer buffer = QuadBuffer.INSTANCE;
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        buffer.begin();
        float z = -0.01f;
        buffer.vertex(matrix4f, x, y + height, z).color(255, 255, 255, 255).texture(0.0f, 1.0f).light(light).overlay(overlay);
        buffer.vertex(matrix4f, x + width, y + height, z).color(255, 255, 255, 255).texture(1.0f, 1.0f).light(light).overlay(overlay);
        buffer.vertex(matrix4f, x + width, y, z).color(255, 255, 255, 255).texture(1.0f, 0.0f).light(light).overlay(overlay);
        buffer.vertex(matrix4f, x, y, z).color(255, 255, 255, 255).texture(0.0f, 0.0f).light(light).overlay(overlay);
        buffer.draw();
        BlendHelper.disableBlend();
        BlendHelper.disableDepthTest();
    }

    private static void drawEntityIcon(class_4587 matrices, class_1297 entity, float x, float y, float width, float height) {
        class_897<?> renderer = EntityRendererAccessor.getEntityRenderer(entity);
        class_2960 skinId = EntityTextureHelper.getTexture(renderer, entity);
        if (skinId == null) {
            return;
        }
        String skinPath = skinId.method_12832();
        class_2960 iconId = textures.GetEntity(skinPath);
        if (iconId == null) {
            return;
        }
        ShaderHelper.setTexturedShader();
        TextureLoader.bind(0, iconId);
        BlendHelper.enableBlend();
        BlendHelper.defaultBlendFunc();
        BlendHelper.enableDepthTest();
        BlendHelper.depthMask(true);
        QuadBuffer buffer = QuadBuffer.INSTANCE;
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        buffer.begin();
        float z = -0.01f;
        buffer.vertex(matrix4f, x, y + height, z).color(255, 255, 255, 255).texture(0.0f, 1.0f).light(light).overlay(overlay);
        buffer.vertex(matrix4f, x + width, y + height, z).color(255, 255, 255, 255).texture(1.0f, 1.0f).light(light).overlay(overlay);
        buffer.vertex(matrix4f, x + width, y, z).color(255, 255, 255, 255).texture(1.0f, 0.0f).light(light).overlay(overlay);
        buffer.vertex(matrix4f, x, y, z).color(255, 255, 255, 255).texture(0.0f, 0.0f).light(light).overlay(overlay);
        buffer.draw();
        BlendHelper.disableBlend();
        BlendHelper.disableDepthTest();
    }

    private static void drawPlayerIcon(class_4587 matrices, class_1297 entity, float x, float y, float width, float height) {
        class_897<?> renderer = EntityRendererAccessor.getEntityRenderer(entity);
        class_2960 playerTexture = EntityTextureHelper.getTexture(renderer, entity);
        if (playerTexture == null) {
            return;
        }
        boolean customSkinFound = PlayerCustomTexture.hasCustomIcon(playerTexture);
        ShaderHelper.setTexturedShader();
        TextureLoader.bind(0, playerTexture);
        BlendHelper.enableBlend();
        BlendHelper.defaultBlendFunc();
        BlendHelper.enableDepthTest();
        BlendHelper.depthMask(true);
        QuadBuffer buffer = QuadBuffer.INSTANCE;
        buffer.begin();
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        float z = -0.01f;
        if (customSkinFound) {
            float[][] newCoordinates = new float[][]{{0.0f, 0.0f, 8.0f, 8.0f, 0.0f, 0.0f}, {24.0f, 0.0f, 32.0f, 8.0f, 8.0f, 0.0f}, {32.0f, 0.0f, 40.0f, 8.0f, 16.0f, 0.0f}, {56.0f, 0.0f, 64.0f, 8.0f, 0.0f, 8.0f}, {56.0f, 20.0f, 64.0f, 28.0f, 8.0f, 8.0f}, {36.0f, 16.0f, 44.0f, 20.0f, 16.0f, 8.0f}, {56.0f, 16.0f, 64.0f, 20.0f, 16.0f, 12.0f}, {56.0f, 28.0f, 64.0f, 36.0f, 0.0f, 16.0f}, {56.0f, 36.0f, 64.0f, 44.0f, 8.0f, 16.0f}, {56.0f, 44.0f, 64.0f, 48.0f, 16.0f, 16.0f}, {12.0f, 48.0f, 20.0f, 52.0f, 16.0f, 20.0f}};
            float scaleFactor = 0.77f;
            for (float[] coords : newCoordinates) {
                float newU1 = coords[0] / 64.0f;
                float newV1 = coords[1] / 64.0f;
                float newU2 = coords[2] / 64.0f;
                float newV2 = coords[3] / 64.0f;
                float offsetX = coords[4] * scaleFactor;
                float offsetY = coords[5] * scaleFactor;
                float scaledX = x + offsetX;
                float scaledY = y + offsetY;
                float scaledWidth = (coords[2] - coords[0]) * scaleFactor;
                float scaledHeight = (coords[3] - coords[1]) * scaleFactor;
                buffer.vertex(matrix4f, scaledX, scaledY + scaledHeight, z).color(255, 255, 255, 255).texture(newU1, newV2).light(light).overlay(overlay);
                buffer.vertex(matrix4f, scaledX + scaledWidth, scaledY + scaledHeight, z).color(255, 255, 255, 255).texture(newU2, newV2).light(light).overlay(overlay);
                buffer.vertex(matrix4f, scaledX + scaledWidth, scaledY, z).color(255, 255, 255, 255).texture(newU2, newV1).light(light).overlay(overlay);
                buffer.vertex(matrix4f, scaledX, scaledY, z).color(255, 255, 255, 255).texture(newU1, newV1).light(light).overlay(overlay);
            }
        } else {
            x += 2.0f;
            y += 2.0f;
            width -= 4.0f;
            float u1 = 0.125f;
            float v1 = 0.125f;
            float u2 = 0.25f;
            float v2 = 0.25f;
            buffer.vertex(matrix4f, x, y + (height -= 4.0f), z).color(255, 255, 255, 255).texture(u1, v2).light(light).overlay(overlay);
            buffer.vertex(matrix4f, x + width, y + height, z).color(255, 255, 255, 255).texture(u2, v2).light(light).overlay(overlay);
            buffer.vertex(matrix4f, x + width, y, z).color(255, 255, 255, 255).texture(u2, v1).light(light).overlay(overlay);
            buffer.vertex(matrix4f, x, y, z).color(255, 255, 255, 255).texture(u1, v1).light(light).overlay(overlay);
            float hatU1 = 0.625f;
            float hatV1 = 0.125f;
            float hatU2 = 0.75f;
            float hatV2 = 0.25f;
            buffer.vertex(matrix4f, x, y + height, z -= 0.01f).color(255, 255, 255, 255).texture(hatU1, hatV2).light(light).overlay(overlay);
            buffer.vertex(matrix4f, x + width, y + height, z).color(255, 255, 255, 255).texture(hatU2, hatV2).light(light).overlay(overlay);
            buffer.vertex(matrix4f, x + width, y, z).color(255, 255, 255, 255).texture(hatU2, hatV1).light(light).overlay(overlay);
            buffer.vertex(matrix4f, x, y, z).color(255, 255, 255, 255).texture(hatU1, hatV1).light(light).overlay(overlay);
        }
        buffer.draw();
        BlendHelper.disableBlend();
        BlendHelper.disableDepthTest();
    }

    private static void drawMessageText(Matrix4f matrix, List<String> lines, int starting_line, int ending_line, class_4597 immediate, float lineSpacing, int fullBright, float yOffset) {
        class_327 fontRenderer = class_310.method_1551().field_1772;
        int currentLineIndex = 0;
        for (String lineText : lines) {
            if (currentLineIndex >= starting_line && currentLineIndex < ending_line) {
                fontRenderer.method_27521(lineText, (float)(-fontRenderer.method_1727(lineText)) / 2.0f, yOffset, -1, false, matrix, immediate, class_327.class_6415.field_33993, 0, fullBright);
                Objects.requireNonNull(fontRenderer);
                yOffset += 9.0f + lineSpacing;
            }
            if (++currentLineIndex <= ending_line) continue;
            break;
        }
    }

    private static void drawEntityName(class_1297 entity, Matrix4f matrix, class_4597 immediate, int fullBright, float yOffset, boolean truncate) {
        class_327 fontRenderer = class_310.method_1551().field_1772;
        Object nameText = "";
        if (entity instanceof class_1308) {
            if (entity.method_5797() != null) {
                nameText = entity.method_5797().getString();
            }
        } else if (entity instanceof class_1657) {
            nameText = entity.method_5477().getString();
        }
        if (((String)nameText).length() > 14 && truncate) {
            nameText = ((String)nameText).substring(0, 14) + "...";
        }
        fontRenderer.method_27521((String)nameText, (float)(-fontRenderer.method_1727((String)nameText)) / 2.0f, yOffset, -1, false, matrix, immediate, class_327.class_6415.field_33993, 0, fullBright);
    }

    public static void drawTextAboveEntities(WorldRenderContext context, long tick, float partialTicks) {
        float lineSpacing = 1.0f;
        float textHeaderHeight = 40.0f;
        float textFooterHeight = 5.0f;
        int fullBright = 0xF000F0;
        double renderDistance = 11.0;
        class_4184 camera = context.camera();
        class_1297 cameraEntity = camera.method_19331();
        if (cameraEntity == null) {
            return;
        }
        class_1937 world = cameraEntity.method_37908();
        class_243 pos = cameraEntity.method_19538();
        class_238 area = new class_238(pos.field_1352 - renderDistance, pos.field_1351 - renderDistance, pos.field_1350 - renderDistance, pos.field_1352 + renderDistance, pos.field_1351 + renderDistance, pos.field_1350 + renderDistance);
        class_327 fontRenderer = class_310.method_1551().field_1772;
        class_4587 matrices = context.matrixStack();
        class_4597 immediate = context.consumers();
        class_243 interpolatedCameraPos = new class_243(camera.method_19326().field_1352, camera.method_19326().field_1351, camera.method_19326().field_1350);
        if (++queryEntityDataCount % 3 == 0 || relevantEntities == null) {
            List nearbyEntities = world.method_8335(null, area);
            relevantEntities = nearbyEntities.stream().filter(entity -> entity instanceof class_1308 || entity instanceof class_1657).filter(entity -> !entity.method_5782()).filter(entity -> !entity.equals((Object)cameraEntity) || camera.method_19333()).filter(entity -> !entity.equals((Object)cameraEntity) || !entity.method_7325()).filter(entity -> {
                if (entity instanceof class_1657) {
                    return true;
                }
                class_2960 entityId = class_7923.field_41177.method_10221((Object)entity.method_5864());
                String entityIdString = entityId.toString();
                if (blacklist.contains(entityIdString)) {
                    return false;
                }
                return whitelist.isEmpty() || whitelist.contains(entityIdString);
            }).collect(Collectors.toList());
            queryEntityDataCount = 0;
        }
        for (class_1297 entity2 : relevantEntities) {
            class_243 bubblePosition;
            matrices.method_22903();
            float entityHeight = EntityHeights.getAdjustedEntityHeight(entity2);
            double paddingAboveEntity = 0.4;
            class_243 interpolatedEntityPos = EntityRenderPosition.getInterpolatedPosition(entity2, partialTicks);
            if (entity2 instanceof class_1510) {
                class_1510 dragon = (class_1510)entity2;
                class_1508 head = dragon.field_7017;
                class_243 headPos = EntityRenderPosition.getInterpolatedPosition((class_1297)head, partialTicks);
                bubblePosition = headPos.method_1031(0.0, (double)entityHeight + paddingAboveEntity, 0.0);
            } else {
                float entityYawRadians = (float)Math.toRadians(entity2.method_5705(partialTicks));
                class_243 forwardOffset = new class_243(-Math.sin(entityYawRadians), 0.0, Math.cos(entityYawRadians));
                class_243 scaledForwardOffset = forwardOffset.method_1021((double)entity2.method_17681() / 2.0 * 0.8);
                bubblePosition = interpolatedEntityPos.method_1019(scaledForwardOffset).method_1031(0.0, (double)entityHeight + paddingAboveEntity, 0.0);
            }
            matrices.method_22904(bubblePosition.field_1352 - interpolatedCameraPos.field_1352, bubblePosition.field_1351 - interpolatedCameraPos.field_1351, bubblePosition.field_1350 - interpolatedCameraPos.field_1350);
            class_243 difference = interpolatedCameraPos.method_1020(new class_243(interpolatedEntityPos.field_1352, interpolatedEntityPos.field_1351 + (double)entityHeight + paddingAboveEntity, interpolatedEntityPos.field_1350));
            double yaw = -(Math.atan2(difference.field_1350, difference.field_1352) + 1.5707963267948966);
            float halfYaw = (float)yaw * 0.5f;
            double sinHalfYaw = class_3532.method_15374((float)halfYaw);
            double cosHalfYaw = class_3532.method_15362((float)halfYaw);
            Quaternionf yawRotation = new Quaternionf(0.0, sinHalfYaw, 0.0, cosHalfYaw);
            matrices.method_22907(yawRotation);
            double horizontalDistance = Math.sqrt(difference.field_1352 * difference.field_1352 + difference.field_1350 * difference.field_1350);
            double pitch = Math.atan2(difference.field_1351, horizontalDistance);
            float halfPitch = (float)pitch * 0.5f;
            double sinHalfPitch = class_3532.method_15374((float)halfPitch);
            double cosHalfPitch = class_3532.method_15362((float)halfPitch);
            Quaternionf pitchRotation = new Quaternionf(sinHalfPitch, 0.0, 0.0, cosHalfPitch);
            matrices.method_22907(pitchRotation);
            Matrix4f matrix = matrices.method_23760().method_23761();
            class_746 player = class_310.method_1551().field_1724;
            EntityChatDataLight chatData = null;
            PlayerData playerData = null;
            if (entity2 instanceof class_1308) {
                chatData = ClientChatDataManager.getOrCreateChatData(entity2.method_5845());
                if (chatData != null) {
                    playerData = chatData.getPlayerData(player.method_5476().getString());
                }
            } else if (entity2 instanceof class_1657) {
                chatData = PlayerMessageManager.getMessage(entity2.method_5667());
                playerData = new PlayerData();
            }
            float f = ChatDataManager.DISPLAY_NUM_LINES;
            Objects.requireNonNull(fontRenderer);
            float minTextHeight = f * (9.0f + lineSpacing) + (float)(DISPLAY_PADDING * 2);
            float scaledTextHeight = 0.0f;
            if (chatData != null) {
                List<String> lines = chatData.getWrappedLines();
                float linesDisplayed = 0.0f;
                int starting_line = chatData.currentLineNumber;
                int ending_line = Math.min(chatData.currentLineNumber + ChatDataManager.DISPLAY_NUM_LINES, lines.size());
                linesDisplayed = ending_line - starting_line;
                Objects.requireNonNull(fontRenderer);
                scaledTextHeight = linesDisplayed * (9.0f + lineSpacing);
                scaledTextHeight = Math.max(scaledTextHeight, minTextHeight);
                BubbleLocationManager.updateBubbleData(entity2.method_5667(), bubblePosition, 2.56f, (scaledTextHeight + 25.0f) / 50.0f, yaw, pitch);
                matrices.method_22905(-0.02f, -0.02f, 0.02f);
                matrices.method_46416(0.0f, -scaledTextHeight - textHeaderHeight - textFooterHeight, 0.0f);
                if (chatData.status == ChatDataManager.ChatStatus.NONE) {
                    BubbleRenderer.drawIcon("button-chat", matrices, -16.0f, textHeaderHeight, 32.0f, 17.0f);
                    BubbleRenderer.drawEntityName(entity2, matrix, immediate, fullBright, 24.0f + (float)DISPLAY_PADDING, true);
                } else if (chatData.status == ChatDataManager.ChatStatus.PENDING) {
                    BubbleRenderer.drawIcon("button-dot-" + animationFrame, matrices, -16.0f, textHeaderHeight, 32.0f, 17.0f);
                } else if (chatData.sender == ChatDataManager.ChatSender.ASSISTANT && chatData.status != ChatDataManager.ChatStatus.HIDDEN) {
                    BubbleRenderer.drawEntityName(entity2, matrix, immediate, fullBright, 24.0f + (float)DISPLAY_PADDING, true);
                    BubbleRenderer.drawTextBubbleBackground("text-top", matrices, -64.0f, 0.0f, 128.0f, scaledTextHeight, playerData.friendship);
                    BubbleRenderer.drawEntityIcon(matrices, entity2, -82.0f, 7.0f, 32.0f, 32.0f);
                    BubbleRenderer.drawFriendshipStatus(matrices, 51.0f, 18.0f, 31.0f, 21.0f, playerData.friendship);
                    if (chatData.currentLineNumber > 0) {
                        BubbleRenderer.drawIcon("arrow-left", matrices, -63.0f, scaledTextHeight + 29.0f, 16.0f, 16.0f);
                    }
                    if (!chatData.isEndOfMessage()) {
                        BubbleRenderer.drawIcon("arrow-right", matrices, 47.0f, scaledTextHeight + 29.0f, 16.0f, 16.0f);
                    } else {
                        BubbleRenderer.drawIcon("keyboard", matrices, 47.0f, scaledTextHeight + 28.0f, 16.0f, 16.0f);
                    }
                    BubbleRenderer.drawMessageText(matrix, lines, starting_line, ending_line, immediate, lineSpacing, fullBright, 40.0f + (float)DISPLAY_PADDING);
                } else if (chatData.sender == ChatDataManager.ChatSender.ASSISTANT && chatData.status == ChatDataManager.ChatStatus.HIDDEN) {
                    BubbleRenderer.drawEntityName(entity2, matrix, immediate, fullBright, 24.0f + (float)DISPLAY_PADDING, false);
                    if (playerData.friendship == 3) {
                        BubbleRenderer.drawIcon("button-chat-friend", matrices, -16.0f, textHeaderHeight, 32.0f, 17.0f);
                    } else if (playerData.friendship == -3) {
                        BubbleRenderer.drawIcon("button-chat-enemy", matrices, -16.0f, textHeaderHeight, 32.0f, 17.0f);
                    } else {
                        BubbleRenderer.drawIcon("button-chat", matrices, -16.0f, textHeaderHeight, 32.0f, 17.0f);
                    }
                } else if (chatData.sender == ChatDataManager.ChatSender.USER && chatData.status == ChatDataManager.ChatStatus.DISPLAY) {
                    BubbleRenderer.drawEntityName(entity2, matrix, immediate, fullBright, 24.0f + (float)DISPLAY_PADDING, true);
                    BubbleRenderer.drawTextBubbleBackground("text-top-player", matrices, -64.0f, 0.0f, 128.0f, scaledTextHeight, playerData.friendship);
                    BubbleRenderer.drawPlayerIcon(matrices, entity2, -75.0f, 14.0f, 18.0f, 18.0f);
                    BubbleRenderer.drawMessageText(matrix, lines, starting_line, ending_line, immediate, lineSpacing, fullBright, 40.0f + (float)DISPLAY_PADDING);
                }
            } else if (entity2 instanceof class_1657) {
                matrices.method_22905(-0.02f, -0.02f, 0.02f);
                boolean showPendingIcon = false;
                if (PlayerMessageManager.isChatUIOpen(entity2.method_5667())) {
                    showPendingIcon = true;
                    scaledTextHeight += minTextHeight;
                } else {
                    scaledTextHeight -= 15.0f;
                }
                matrices.method_46416(0.0f, -scaledTextHeight - textHeaderHeight - textFooterHeight, 0.0f);
                if (!entity2.equals((Object)cameraEntity) && !class_310.method_1551().field_1690.field_1842) {
                    BubbleRenderer.drawEntityName(entity2, matrices.method_23760().method_23761(), immediate, fullBright, 24.0f + (float)DISPLAY_PADDING, true);
                    if (showPendingIcon) {
                        BubbleRenderer.drawIcon("button-dot-" + animationFrame, matrices, -16.0f, textHeaderHeight, 32.0f, 17.0f);
                    }
                }
            }
            if (lastTick != tick && tick % 5L == 0L) {
                lastTick = tick;
                ++animationFrame;
            }
            if (animationFrame > 8) {
                animationFrame = 0;
            }
            matrices.method_22909();
        }
        List<UUID> activeEntityUUIDs = relevantEntities.stream().map(class_1297::method_5667).collect(Collectors.toList());
        BubbleLocationManager.performCleanup(activeEntityUUIDs);
    }
}

