/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.ui;

import com.owlmaddie.chat.ChatDataManager;
import com.owlmaddie.chat.ClientChatDataManager;
import com.owlmaddie.chat.EntityChatDataLight;
import com.owlmaddie.network.ClientPackets;
import com.owlmaddie.ui.BubbleLocationManager;
import com.owlmaddie.ui.ChatScreen;
import com.owlmaddie.utils.ClientEntityFinder;
import com.owlmaddie.utils.UseItemCallbackHelper;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ClickHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");
    private static boolean wasClicked = false;

    public static void register() {
        UseItemCallback.EVENT.register(UseItemCallbackHelper::handleUseItemAction);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1690.field_1904.method_1434()) {
                if (!wasClicked && client.field_1724 != null && client.field_1724.method_6047().method_7960() && ClickHandler.handleUseKeyClick(client)) {
                    wasClicked = true;
                }
            } else {
                wasClicked = false;
            }
        });
    }

    public static boolean shouldCancelAction(class_1937 world) {
        class_310 client;
        if (world.field_9236 && (client = class_310.method_1551()) != null && client.field_1690.field_1904.method_1434()) {
            return ClickHandler.handleUseKeyClick(client);
        }
        return false;
    }

    public static boolean handleUseKeyClick(class_310 client) {
        class_1308 closestEntity;
        class_4184 camera = client.field_1773.method_19418();
        class_1297 cameraEntity = camera.method_19331();
        if (cameraEntity == null) {
            return false;
        }
        class_746 player = client.field_1724;
        class_243 startRay = camera.method_19326();
        class_243 lookVec = player.method_5828(1.0f);
        double closestDistance = Double.MAX_VALUE;
        Optional<class_243> closestHitResult = null;
        UUID closestEntityUUID = null;
        BubbleLocationManager.BubbleData closestBubbleData = null;
        for (Map.Entry<UUID, BubbleLocationManager.BubbleData> entry : BubbleLocationManager.getAllBubbleData().entrySet()) {
            double distance;
            UUID entityUUID = entry.getKey();
            BubbleLocationManager.BubbleData bubbleData = entry.getValue();
            class_243[] corners = ClickHandler.getBillboardCorners(bubbleData.position, camera.method_19326(), bubbleData.height, bubbleData.width, bubbleData.yaw, bubbleData.pitch);
            Optional<class_243> hitResult = ClickHandler.rayIntersectsPolygon(startRay, lookVec, corners);
            if (!hitResult.isPresent() || !((distance = startRay.method_1025(hitResult.get())) < closestDistance)) continue;
            closestDistance = distance;
            closestEntityUUID = entityUUID;
            closestHitResult = hitResult;
            closestBubbleData = bubbleData;
        }
        if (closestEntityUUID != null && (closestEntity = ClientEntityFinder.getEntityByUUID(client.field_1687, closestEntityUUID)) != null) {
            EntityChatDataLight chatData = ClientChatDataManager.getOrCreateChatData(closestEntityUUID.toString());
            String hitRegion = ClickHandler.determineHitRegion((class_243)closestHitResult.get(), closestBubbleData.position, camera, closestBubbleData.height);
            LOGGER.debug("Clicked region: " + hitRegion);
            if (chatData.status == ChatDataManager.ChatStatus.NONE) {
                ClientPackets.sendGenerateGreeting((class_1297)closestEntity);
            } else if (chatData.status == ChatDataManager.ChatStatus.DISPLAY) {
                if (hitRegion.equals("RIGHT") && !chatData.isEndOfMessage()) {
                    ClientPackets.sendUpdateLineNumber((class_1297)closestEntity, chatData.currentLineNumber + ChatDataManager.DISPLAY_NUM_LINES);
                } else if (hitRegion.equals("LEFT") && chatData.currentLineNumber > 0) {
                    ClientPackets.sendUpdateLineNumber((class_1297)closestEntity, chatData.currentLineNumber - ChatDataManager.DISPLAY_NUM_LINES);
                } else if (hitRegion.equals("RIGHT") && chatData.isEndOfMessage()) {
                    client.method_1507((class_437)new ChatScreen((class_1297)closestEntity, (class_1657)client.field_1724));
                } else if (hitRegion.equals("TOP")) {
                    ClientPackets.setChatStatus((class_1297)closestEntity, ChatDataManager.ChatStatus.HIDDEN);
                }
            } else if (chatData.status == ChatDataManager.ChatStatus.HIDDEN) {
                ClientPackets.setChatStatus((class_1297)closestEntity, ChatDataManager.ChatStatus.DISPLAY);
            }
            return true;
        }
        return false;
    }

    public static class_243[] getBillboardCorners(class_243 center, class_243 cameraPos, double height, double width, double yaw, double pitch) {
        double radYaw = Math.toRadians(yaw);
        double radPitch = Math.toRadians(pitch);
        class_243 toCamera = cameraPos.method_1020(center).method_1029();
        class_243 globalUp = new class_243(0.0, 1.0, 0.0);
        class_243 right = globalUp.method_1036(toCamera).method_1029();
        class_243 up = toCamera.method_1036(right).method_1029();
        right = ClickHandler.rotateVector(right, radYaw, radPitch);
        up = ClickHandler.rotateVector(up, radYaw, radPitch);
        class_243 adjustedCenter = center.method_1019(up.method_1021(height / 2.0));
        class_243 topLeft = adjustedCenter.method_1020(right.method_1021(width / 2.0)).method_1019(up.method_1021(height / 2.0));
        class_243 topRight = adjustedCenter.method_1019(right.method_1021(width / 2.0)).method_1019(up.method_1021(height / 2.0));
        class_243 bottomRight = adjustedCenter.method_1019(right.method_1021(width / 2.0)).method_1020(up.method_1021(height / 2.0));
        class_243 bottomLeft = adjustedCenter.method_1020(right.method_1021(width / 2.0)).method_1020(up.method_1021(height / 2.0));
        return new class_243[]{topLeft, topRight, bottomRight, bottomLeft};
    }

    private static class_243 rotateVector(class_243 vector, double yaw, double pitch) {
        double cosYaw = Math.cos(yaw);
        double sinYaw = Math.sin(yaw);
        class_243 yawRotated = new class_243(vector.field_1352 * cosYaw + vector.field_1350 * sinYaw, vector.field_1351, -vector.field_1352 * sinYaw + vector.field_1350 * cosYaw);
        double cosPitch = Math.cos(pitch);
        double sinPitch = Math.sin(pitch);
        return new class_243(yawRotated.field_1352, yawRotated.field_1351 * cosPitch - yawRotated.field_1350 * sinPitch, yawRotated.field_1351 * sinPitch + yawRotated.field_1350 * cosPitch);
    }

    public static Optional<class_243> rayIntersectsPolygon(class_243 rayOrigin, class_243 rayDirection, class_243[] vertices) {
        rayDirection = rayDirection.method_1029();
        return Stream.of(ClickHandler.rayIntersectsTriangle(rayOrigin, rayDirection, vertices[0], vertices[1], vertices[2]), ClickHandler.rayIntersectsTriangle(rayOrigin, rayDirection, vertices[0], vertices[2], vertices[3])).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    public static Optional<class_243> rayIntersectsTriangle(class_243 rayOrigin, class_243 rayDirection, class_243 v0, class_243 v1, class_243 v2) {
        class_243 edge2;
        class_243 h;
        class_243 edge1 = v1.method_1020(v0);
        double a = edge1.method_1026(h = rayDirection.method_1036(edge2 = v2.method_1020(v0)));
        if (Math.abs(a) < 1.0E-6) {
            return Optional.empty();
        }
        double f = 1.0 / a;
        class_243 s = rayOrigin.method_1020(v0);
        double u = f * s.method_1026(h);
        if (u < 0.0 || u > 1.0) {
            return Optional.empty();
        }
        class_243 q = s.method_1036(edge1);
        double v = f * rayDirection.method_1026(q);
        if (v < 0.0 || u + v > 1.0) {
            return Optional.empty();
        }
        double t = f * edge2.method_1026(q);
        if (t > 1.0E-6) {
            return Optional.of(rayOrigin.method_1019(rayDirection.method_1021(t)));
        }
        return Optional.empty();
    }

    public static String determineHitRegion(class_243 hitPoint, class_243 center, class_4184 camera, double height) {
        class_243 globalUp = new class_243(0.0, 1.0, 0.0);
        class_243 cameraPos = camera.method_19326();
        class_243 toCamera = cameraPos.method_1020(center).method_1029();
        class_243 right = globalUp.method_1036(toCamera).method_1029();
        if (right.method_1027() == 0.0) {
            right = new class_243(1.0, 0.0, 0.0);
        }
        class_243 up = toCamera.method_1036(right).method_1029();
        class_243 relPosition = hitPoint.method_1020(center);
        double relX = relPosition.method_1026(right);
        double relY = relPosition.method_1026(up);
        if (relY > 0.7 * height) {
            return "TOP";
        }
        return relX < -0.5 ? "LEFT" : "RIGHT";
    }
}

