/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.utils;

import java.util.Random;
import net.minecraft.class_11;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5534;

public class RandomTargetFinder {
    private static final Random random = new Random();

    public static class_243 findRandomTarget(class_1308 entity, double maxAngleOffset, double minDistance, double maxDistance) {
        class_243 entityPos = entity.method_19538();
        class_243 initialDirection = RandomTargetFinder.getLookDirection(entity);
        for (int attempt = 0; attempt < 10; ++attempt) {
            class_243 constrainedDirection = RandomTargetFinder.getConstrainedDirection(initialDirection, maxAngleOffset);
            class_243 target = RandomTargetFinder.getTargetInDirection(entity, constrainedDirection, minDistance, maxDistance);
            if (entity instanceof class_1314) {
                class_11 path;
                class_243 validTarget = class_5534.method_31528((class_1314)((class_1314)entity), (int)((int)maxDistance), (int)((int)maxDistance), (class_243)target);
                if (validTarget == null || !RandomTargetFinder.isWithinDistance(entityPos, validTarget, minDistance, maxDistance) || (path = entity.method_5942().method_6352(validTarget.field_1352, validTarget.field_1351, validTarget.field_1350, 4)) == null) continue;
                return validTarget;
            }
            if (!RandomTargetFinder.isWithinDistance(entityPos, target, minDistance, maxDistance)) continue;
            return target;
        }
        return RandomTargetFinder.getTargetInDirection(entity, initialDirection, minDistance, maxDistance);
    }

    private static class_243 getLookDirection(class_1308 entity) {
        float yaw = entity.method_36454() * ((float)Math.PI / 180);
        float pitch = entity.method_36455() * ((float)Math.PI / 180);
        float x = -class_3532.method_15374((float)yaw) * class_3532.method_15362((float)pitch);
        float y = -class_3532.method_15374((float)pitch);
        float z = class_3532.method_15362((float)yaw) * class_3532.method_15362((float)pitch);
        return new class_243((double)x, (double)y, (double)z);
    }

    private static class_243 getConstrainedDirection(class_243 initialDirection, double maxAngleOffset) {
        double randomYawAngleOffset = random.nextDouble() * Math.toRadians(maxAngleOffset) - Math.toRadians(maxAngleOffset / 2.0);
        double randomPitchAngleOffset = random.nextDouble() * Math.toRadians(maxAngleOffset) - Math.toRadians(maxAngleOffset / 2.0);
        double cosYaw = Math.cos(randomYawAngleOffset);
        double sinYaw = Math.sin(randomYawAngleOffset);
        double xYaw = initialDirection.field_1352 * cosYaw - initialDirection.field_1350 * sinYaw;
        double zYaw = initialDirection.field_1352 * sinYaw + initialDirection.field_1350 * cosYaw;
        double cosPitch = Math.cos(randomPitchAngleOffset);
        double sinPitch = Math.sin(randomPitchAngleOffset);
        double yPitch = initialDirection.field_1351 * cosPitch - zYaw * sinPitch;
        double zPitch = zYaw * cosPitch + initialDirection.field_1351 * sinPitch;
        return new class_243(xYaw, yPitch, zPitch).method_1029();
    }

    private static class_243 getTargetInDirection(class_1308 entity, class_243 direction, double minDistance, double maxDistance) {
        double distance = minDistance + entity.method_59922().method_43058() * (maxDistance - minDistance);
        return entity.method_19538().method_1019(direction.method_1021(distance));
    }

    private static boolean isWithinDistance(class_243 entityPos, class_243 targetPos, double minDistance, double maxDistance) {
        double distance = entityPos.method_1025(targetPos);
        return distance >= minDistance * minDistance && distance <= maxDistance * maxDistance;
    }
}

