/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.chat;

import com.owlmaddie.chat.ChatDataAutoSaver;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.MinecraftServer;

public class ChatDataSaverScheduler {
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private MinecraftServer server = null;

    public void startAutoSaveTask(MinecraftServer server, long interval, TimeUnit timeUnit) {
        this.server = server;
        ChatDataAutoSaver saverTask = new ChatDataAutoSaver(server);
        this.scheduler.scheduleAtFixedRate(saverTask, 1L, interval, timeUnit);
    }

    public void stopAutoSaveTask() {
        this.scheduler.shutdown();
    }

    public void scheduleTask(Runnable task) {
        this.scheduler.schedule(() -> this.server.execute(task), 50L, TimeUnit.MILLISECONDS);
    }
}

