/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.chat;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.owlmaddie.chat.ChatMessage;
import com.owlmaddie.commands.ConfigurationHandler;
import com.owlmaddie.json.ChatGPTResponse;
import com.owlmaddie.network.ServerPackets;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatGPTRequest {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");
    public static String lastErrorMessage;
    public static Map<UUID, CompletableFuture<String>> apiKeyAwaiter;

    public static String removeQuotes(String str) {
        if (str != null && str.length() > 1 && str.startsWith("\"") && str.endsWith("\"")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static String parseAndLogErrorResponse(String errorResponse) {
        try {
            Gson gson = new Gson();
            ErrorResponse response = (ErrorResponse)gson.fromJson(errorResponse, ErrorResponse.class);
            if (response.error != null) {
                LOGGER.error("Error Message: " + response.error.message);
                LOGGER.error("Error Type: " + response.error.type);
                LOGGER.error("Error Code: " + response.error.code);
                return response.error.message;
            }
            LOGGER.error("Unknown error response: " + errorResponse);
            return "Unknown: " + errorResponse;
        }
        catch (JsonSyntaxException e) {
            LOGGER.warn("Failed to parse error response as JSON, falling back to plain text");
            LOGGER.error("Error response: " + errorResponse);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse error response", (Throwable)e);
        }
        return ChatGPTRequest.removeQuotes(errorResponse);
    }

    public static String replacePlaceholders(String template, Map<String, String> replacements) {
        String result = template;
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            result = result.replaceAll(Pattern.quote("{{" + entry.getKey() + "}}"), entry.getValue());
        }
        return result.replace("\"", "");
    }

    private static int estimateTokenSize(String text) {
        return (int)Math.round((double)text.length() / 3.5);
    }

    public static CompletableFuture<String> fetchMessageFromChatGPT(ConfigurationHandler.Config config, String systemPrompt, Map<String, String> contextData, List<ChatMessage> messageHistory, Boolean jsonMode, String wrapMsg, class_3222 player) {
        CompletableFuture apiKeyFuture = new CompletableFuture();
        UUID authRequestId = UUID.randomUUID();
        apiKeyAwaiter.put(authRequestId, apiKeyFuture);
        CompletionStage messageFuture = ((CompletableFuture)apiKeyFuture.orTimeout(120L, TimeUnit.SECONDS).thenComposeAsync(apiKey -> {
            LOGGER.info("Received API key from player {}", (Object)player.method_5477().getString());
            return ChatGPTRequest.fetchMessageFromChatGPTInternal(config, systemPrompt, contextData, messageHistory, jsonMode, wrapMsg, apiKey);
        })).whenComplete((res, ex) -> apiKeyAwaiter.remove(authRequestId));
        ServerPackets.requestPlayerApiKeyWithId(player, authRequestId);
        return messageFuture;
    }

    public static CompletableFuture<String> fetchMessageFromChatGPTInternal(ConfigurationHandler.Config config, String systemPrompt, Map<String, String> contextData, List<ChatMessage> messageHistory, Boolean jsonMode, String wrapMsg, String apiKey) {
        String apiUrl = config.getUrl();
        String modelName = config.getModel();
        int timeout = config.getTimeout() * 1000;
        LOGGER.info("[CHATGPTRequest]/fetchMessageFromChatGPTInternal with timeout in seconds: " + config.getTimeout());
        int maxContextTokens = config.getMaxContextTokens();
        int maxOutputTokens = config.getMaxOutputTokens();
        double percentOfContext = config.getPercentOfContext();
        return CompletableFuture.supplyAsync(() -> {
            try {
                int messageTokens;
                String systemMessage = ChatGPTRequest.replacePlaceholders(systemPrompt, contextData);
                URL url = new URL(apiUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setRequestProperty("Authorization", "Bearer " + apiKey);
                connection.setDoOutput(true);
                connection.setConnectTimeout(timeout);
                connection.setReadTimeout(timeout);
                connection.setRequestProperty("player2-game-key", "creature-chat-evolved");
                ArrayList<ChatGPTRequestMessage> messages = new ArrayList<ChatGPTRequestMessage>();
                int remainingContextTokens = (int)((double)(maxContextTokens - maxOutputTokens) * percentOfContext);
                int usedTokens = ChatGPTRequest.estimateTokenSize("system: " + systemMessage);
                for (int i = messageHistory.size() - 1; i >= 0; usedTokens += messageTokens, --i) {
                    ChatMessage chatMessage = (ChatMessage)messageHistory.get(i);
                    String senderName = chatMessage.sender.toString().toLowerCase(Locale.ENGLISH);
                    String messageText = ChatGPTRequest.replacePlaceholders(chatMessage.message, contextData);
                    if (messageText.equals("...")) {
                        messageText = "";
                    }
                    messageText.replace("said ...", "said ");
                    messageTokens = ChatGPTRequest.estimateTokenSize(senderName + ": " + messageText);
                    if (usedTokens + messageTokens > remainingContextTokens) break;
                    messages.add(new ChatGPTRequestMessage(senderName, messageText));
                }
                messages.add(new ChatGPTRequestMessage("system", systemMessage));
                Collections.reverse(messages);
                if (wrapMsg != null && !wrapMsg.isBlank() && messages.size() > 0) {
                    ((ChatGPTRequestMessage)messages.get((int)(messages.size() - 1))).content = String.format("User message: '%s' |%s|", ((ChatGPTRequestMessage)messages.get((int)(messages.size() - 1))).content, wrapMsg);
                }
                LOGGER.info("---- CONVERSATION HISTORY SENT TO LLM -----");
                for (ChatGPTRequestMessage msg : messages) {
                    LOGGER.info(String.format("%s:'%s'", msg.role.toString(), msg.content));
                }
                LOGGER.info("---- END CONVERSATION HISTORY SENT ---------");
                ChatGPTRequestPayload payload = new ChatGPTRequestPayload(modelName, messages, jsonMode, 1.0f, maxOutputTokens);
                Gson gsonInput = new Gson();
                String jsonInputString = gsonInput.toJson((Object)payload);
                try (OutputStream os = connection.getOutputStream();){
                    byte[] input = jsonInputString.getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
                if (connection.getResponseCode() >= 400) {
                    LOGGER.error(String.format("BAD RESPONSE CODE %d", connection.getResponseCode()));
                    LOGGER.error(String.format(connection.getResponseMessage(), new Object[0]));
                    if (connection.getErrorStream() == null) {
                        lastErrorMessage = "Internal server error, Try restarting player2";
                        return null;
                    }
                    try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));){
                        String errorLine;
                        StringBuilder errorResponse = new StringBuilder();
                        while ((errorLine = errorReader.readLine()) != null) {
                            errorResponse.append(errorLine.trim());
                        }
                        String cleanError = ChatGPTRequest.parseAndLogErrorResponse(errorResponse.toString());
                        System.out.println(String.format("CHATGPT ERROR : %s", errorResponse.toString()));
                        lastErrorMessage = cleanError;
                        return null;
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to read error response", (Throwable)e);
                        lastErrorMessage = "Failed to read error response: " + e.getMessage();
                    }
                    return null;
                }
                try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                    String responseLine;
                    StringBuilder response = new StringBuilder();
                    while ((responseLine = br.readLine()) != null) {
                        response.append(responseLine.trim());
                    }
                    Gson gsonOutput = new Gson();
                    ChatGPTResponse chatGPTResponse = (ChatGPTResponse)gsonOutput.fromJson(response.toString(), ChatGPTResponse.class);
                    if (chatGPTResponse != null && chatGPTResponse.choices != null && !chatGPTResponse.choices.isEmpty()) {
                        String content = chatGPTResponse.choices.get((int)0).message.content;
                        if (content == null) {
                            LOGGER.info("CHATGPT RETURN NULL");
                            String string = "";
                            return string;
                        }
                        LOGGER.info("CHATGPT RETURN " + content);
                        String string = content;
                        return string;
                    }
                    LOGGER.info("CHATGPT RETURN NULL ERR");
                    lastErrorMessage = "Failed to parse response from LLM";
                    String string = null;
                    return string;
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to request message from LLM", (Throwable)e);
                lastErrorMessage = "Failed to request message from LLM: " + e.getMessage();
                return null;
            }
        });
    }

    static {
        apiKeyAwaiter = new ConcurrentHashMap<UUID, CompletableFuture<String>>();
    }

    public static class ErrorResponse {
        Error error;

        static class Error {
            String message;
            String type;
            String code;

            Error() {
            }
        }
    }

    static class ChatGPTRequestMessage {
        String role;
        String content;

        public ChatGPTRequestMessage(String role, String content) {
            this.role = role;
            this.content = content;
        }
    }

    static class ChatGPTRequestPayload {
        String model;
        List<ChatGPTRequestMessage> messages;
        ResponseFormat response_format;
        float temperature;
        boolean stream;

        public ChatGPTRequestPayload(String model, List<ChatGPTRequestMessage> messages, Boolean jsonMode, float temperature, int maxTokens) {
            this.model = model;
            this.messages = messages;
            this.temperature = temperature;
            this.stream = false;
            this.response_format = jsonMode != false ? new ResponseFormat("json_object") : new ResponseFormat("text");
        }
    }

    static class ResponseFormat {
        String type;

        public ResponseFormat(String type) {
            this.type = type;
        }
    }
}

