/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.chat;

import com.google.gson.annotations.Expose;
import com.owlmaddie.chat.ChatDataManager;
import com.owlmaddie.chat.EntityChatData;
import com.owlmaddie.chat.LineWrapper;
import com.owlmaddie.chat.PlayerData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityChatDataLight {
    @Expose
    public String entityId;
    @Expose
    public String currentMessage;
    @Expose
    public int currentLineNumber;
    @Expose
    public ChatDataManager.ChatStatus status;
    @Expose
    public ChatDataManager.ChatSender sender;
    @Expose
    public Map<String, PlayerData> players;
    @Expose
    public String characterSheet;
    @Expose(serialize=false, deserialize=false)
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");

    public EntityChatDataLight(EntityChatData fullData, String playerName) {
        this.entityId = fullData.entityId;
        this.currentMessage = fullData.currentMessage != null ? fullData.currentMessage : "";
        this.currentLineNumber = fullData.currentLineNumber;
        this.status = fullData.status;
        this.sender = fullData.sender;
        this.characterSheet = fullData.characterSheet;
        this.players = new HashMap<String, PlayerData>();
        PlayerData playerData = fullData.getPlayerData(playerName);
        this.players.put(playerName, playerData);
    }

    public EntityChatDataLight(String entityId, String currentMessage, int currentLineNumber, ChatDataManager.ChatStatus status, ChatDataManager.ChatSender sender, String characterSheet, Map<String, PlayerData> players) {
        this.entityId = entityId;
        if (currentMessage == null) {
            LOGGER.error("current message null!");
        }
        this.currentMessage = currentMessage;
        this.currentLineNumber = currentLineNumber;
        this.status = status;
        this.sender = sender;
        this.characterSheet = characterSheet;
        this.players = players;
    }

    public static EntityChatDataLight CreateData(String entityId) {
        return new EntityChatDataLight(entityId, "", 0, ChatDataManager.ChatStatus.NONE, ChatDataManager.ChatSender.USER, "", null);
    }

    public EntityChatDataLight(String entityId) {
        this.entityId = entityId;
        this.currentMessage = "";
        this.currentLineNumber = 0;
        this.status = ChatDataManager.ChatStatus.NONE;
        this.sender = ChatDataManager.ChatSender.USER;
        this.characterSheet = "";
        this.players = null;
    }

    public List<String> getWrappedLines() {
        if (this.currentMessage == null) {
            LOGGER.info("nullWrapped entityID={}, currentLineNumber={}, status={}", new Object[]{this.entityId, this.currentLineNumber, this.status});
        }
        return LineWrapper.wrapLines(this.currentMessage, ChatDataManager.MAX_CHAR_PER_LINE);
    }

    public boolean isEndOfMessage() {
        int totalLines = this.getWrappedLines().size();
        return this.currentLineNumber + ChatDataManager.DISPLAY_NUM_LINES >= totalLines;
    }

    public PlayerData getPlayerData(String playerName) {
        if (this.players == null) {
            return new PlayerData();
        }
        if (this.players.containsKey("")) {
            return this.players.get("");
        }
        if (this.players.containsKey(playerName)) {
            return this.players.get(playerName);
        }
        PlayerData newPlayerData = new PlayerData();
        this.players.put(playerName, newPlayerData);
        return newPlayerData;
    }
}

