/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.chat;

import com.owlmaddie.chat.ChatDataManager;
import com.owlmaddie.chat.ChatGPTRequest;
import com.owlmaddie.chat.ChatMessage;
import com.owlmaddie.chat.ChatPrompt;
import com.owlmaddie.chat.EntityChatData;
import com.owlmaddie.chat.MessageData;
import com.owlmaddie.commands.ConfigurationHandler;
import com.owlmaddie.network.PacketHelper;
import com.owlmaddie.network.ServerPackets;
import com.owlmaddie.utils.ServerEntityFinder;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventQueueData {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");
    private static long waitTimeAfterError = 20000000000L;
    private String entityId;
    private class_1297 entity;
    private boolean isProcessing = false;
    private Deque<MessageData> llmQueue;
    private String userLanguage = null;
    private class_3222 player = null;
    private long lastErrorTime = 0L;
    private long lastProcessTime = 0L;
    private boolean greetingRequested = false;
    private boolean generatedCharacter = false;

    public void updateUUID(String newId, class_1297 newEntity) {
        this.entityId = newId;
        this.entity = newEntity;
    }

    private EntityChatData getChatData() {
        return ChatDataManager.getServerInstance().getOrCreateChatData(this.entityId);
    }

    private void updateUserLanguageAndPlayer(MessageData message) {
        this.userLanguage = message.userLanguage;
        if (message.player != null) {
            this.player = message.player;
        }
    }

    public void addUserMessage(class_1297 entity, String userLanguage, class_3222 player, String userMessage, boolean is_auto_message) {
        this.addMessage(new MessageData(userLanguage, player, userMessage, is_auto_message));
    }

    private void addMessage(MessageData message) {
        this.updateUserLanguageAndPlayer(message);
        this.llmQueue.add(message);
    }

    private void moveFromLLMQueueToChatData() {
        while (!this.llmQueue.isEmpty()) {
            MessageData cur = this.llmQueue.poll();
            this.getChatData().addMessage(cur.userMessage, ChatDataManager.ChatSender.USER, cur.player);
        }
    }

    public boolean shouldProcess() {
        return !this.isProcessing && this.player != null && this.getAction() != ProcessAction.NOOP && System.nanoTime() >= this.lastErrorTime + waitTimeAfterError;
    }

    private void processResponse(BiConsumer<String, class_3222> onUncleanResponse, BiConsumer<String, class_3222> onError) {
        this.moveFromLLMQueueToChatData();
        LOGGER.info("Moved from LLMQueue To Chat Data, now generating message.");
        if (!this.getChatData().lastMsgIsUserMsg()) {
            this.isProcessing = false;
            return;
        }
        this.getChatData().generateEntityResponse(this.userLanguage, this.player, resp -> onUncleanResponse.accept((String)resp, this.player), errMsg -> onError.accept((String)errMsg, this.player));
    }

    private ProcessAction getAction() {
        if (this.llmQueue.isEmpty()) {
            if (this.generatedCharacter || !this.greetingRequested) {
                return ProcessAction.NOOP;
            }
            return ProcessAction.Greeting;
        }
        if (this.generatedCharacter) {
            return ProcessAction.Response;
        }
        return ProcessAction.CharacterThenResponse;
    }

    public void requestGreeting(String userLangauge, class_3222 player) {
        LOGGER.info("REQuesting greeting with " + String.valueOf(player));
        this.userLanguage = userLangauge;
        if (player != null) {
            this.player = player;
        }
        this.greetingRequested = true;
    }

    public void process(BiConsumer<String, class_3222> onUncleanResponse, BiConsumer<String, class_3222> onError, PacketHelper.TriConsumer<String, Boolean, class_3222> onCharacterSheetAndShouldGreet) {
        this.lastProcessTime = System.nanoTime();
        this.isProcessing = true;
        if (this.player == null) {
            throw new RuntimeException("Player is null!!!");
        }
        switch (this.getAction().ordinal()) {
            case 0: {
                this.generateCharacterSheet(characterSheet -> {
                    this.generatedCharacter = true;
                    onCharacterSheetAndShouldGreet.accept((String)characterSheet, true, this.player);
                    this.greetingRequested = false;
                    this.isProcessing = false;
                }, errMsg -> {
                    onError.accept((String)errMsg, this.player);
                    this.isProcessing = false;
                });
                break;
            }
            case 1: {
                this.generateCharacterSheet(characterSheet -> {
                    this.generatedCharacter = true;
                    onCharacterSheetAndShouldGreet.accept((String)characterSheet, false, this.player);
                    this.processResponse(onUncleanResponse, onError);
                    this.greetingRequested = false;
                    this.isProcessing = false;
                }, errMsg -> {
                    onError.accept((String)errMsg, this.player);
                    this.isProcessing = false;
                });
                break;
            }
            case 2: {
                this.processResponse((uncleanRes, player) -> {
                    onUncleanResponse.accept((String)uncleanRes, (class_3222)player);
                    this.greetingRequested = false;
                    this.isProcessing = false;
                }, (errMsg, player) -> {
                    onError.accept((String)errMsg, (class_3222)player);
                    this.isProcessing = false;
                });
                break;
            }
            case 3: {
                this.isProcessing = false;
            }
        }
    }

    public EventQueueData(String entityId, class_1297 entity) {
        this.entityId = entityId;
        this.entity = entity;
        this.llmQueue = new ArrayDeque<MessageData>();
    }

    public int getPriority() {
        return this.greetingRequested ? 1 : 0;
    }

    private void generateCharacterSheet(Consumer<String> onCharacterSheet, Consumer<String> onError) {
        MessageData greetingMessage = MessageData.genCharacterAndOrGreetingMessage(this.userLanguage, this.player, this.entity);
        String systemPrompt = "system-character";
        ConfigurationHandler.Config config = new ConfigurationHandler(ServerPackets.serverInstance).loadConfig();
        String promptText = ChatPrompt.loadPromptFromResource(ServerPackets.serverInstance.method_34864(), systemPrompt);
        Map<String, String> contextData = this.getChatData().getPlayerContext(greetingMessage.player, greetingMessage.userLanguage, config);
        ((CompletableFuture)ChatGPTRequest.fetchMessageFromChatGPT(config, promptText, contextData, List.of(new ChatMessage(greetingMessage.userMessage, ChatDataManager.ChatSender.USER, this.player.method_5477().getString())), false, "", this.player).thenAccept(char_sheet -> ServerPackets.serverInstance.execute(() -> {
            try {
                if (char_sheet == null) {
                    throw new RuntimeException(ChatGPTRequest.lastErrorMessage + "(gen character sheet)");
                }
                LOGGER.info("Generated Character sheet:" + char_sheet);
                onCharacterSheet.accept((String)char_sheet);
            }
            catch (Exception e) {
                onError.accept(e.getMessage() != null ? e.getMessage() : "");
            }
        }))).exceptionally(ex -> {
            ServerPackets.serverInstance.execute(() -> onError.accept(ex != null && ex.getMessage() != null ? ex.getMessage() : ""));
            return null;
        });
    }

    public long getLastProcessTime() {
        return this.lastProcessTime;
    }

    public String getId() {
        return this.entityId;
    }

    public void errorCooldown() {
        this.lastErrorTime = System.nanoTime();
    }

    @Nullable
    public class_3222 getPlayer() {
        return this.player;
    }

    public boolean shouldDelete() {
        if (this.player != null) {
            return ServerEntityFinder.getEntityByUUID((class_3218)this.player.method_37908(), UUID.fromString(this.entityId)) == null || !this.entity.method_5805();
        }
        return false;
    }

    private static enum ProcessAction {
        Greeting,
        CharacterThenResponse,
        Response,
        NOOP;

    }
}

