/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.owlmaddie.commands.ConfigurationHandler;
import com.owlmaddie.network.ServerPackets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreaturePalsCommands {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");

    public static void register() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            CommandDispatcher dispatcher = server.method_3734().method_9235();
            CreaturePalsCommands.registerCommands((CommandDispatcher<class_2168>)dispatcher);
        });
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"creaturepals").then(CreaturePalsCommands.registerSetCommand("key", "API Key", StringArgumentType.string()))).then(CreaturePalsCommands.registerSetCommand("url", "URL", StringArgumentType.string()))).then(CreaturePalsCommands.registerSetCommand("model", "Model", StringArgumentType.string()))).then(CreaturePalsCommands.registerSetCommand("timeout", "Timeout (seconds)", IntegerArgumentType.integer()))).then(CreaturePalsCommands.registerStoryCommand())).then(CreaturePalsCommands.registerWhitelistCommand())).then(CreaturePalsCommands.registerBlacklistCommand())).then(CreaturePalsCommands.registerChatBubbleCommand())).then(CreaturePalsCommands.registerTTSCommand())).then(CreaturePalsCommands.registerHelpCommand()));
    }

    private static LiteralArgumentBuilder<class_2168> registerSetCommand(String settingName, String settingDescription, ArgumentType<?> valueType) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)settingName).requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)"set").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", valueType).then(CreaturePalsCommands.addConfigArgs((context, useServerConfig) -> {
            if (valueType instanceof StringArgumentType) {
                return CreaturePalsCommands.setConfig((class_2168)context.getSource(), settingName, StringArgumentType.getString((CommandContext)context, (String)"value"), useServerConfig, settingDescription);
            }
            if (valueType instanceof IntegerArgumentType) {
                return CreaturePalsCommands.setConfig((class_2168)context.getSource(), settingName, IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), useServerConfig, settingDescription);
            }
            return 1;
        }))).executes(context -> {
            if (valueType instanceof StringArgumentType) {
                return CreaturePalsCommands.setConfig((class_2168)context.getSource(), settingName, StringArgumentType.getString((CommandContext)context, (String)"value"), false, settingDescription);
            }
            if (valueType instanceof IntegerArgumentType) {
                return CreaturePalsCommands.setConfig((class_2168)context.getSource(), settingName, IntegerArgumentType.getInteger((CommandContext)context, (String)"value"), false, settingDescription);
            }
            return 1;
        })));
    }

    private static List<class_2960> getLivingEntityIds() {
        return class_7923.field_41177.method_10235().stream().filter(id -> class_7923.field_41177.method_17966(id).map(type -> type.method_5891() != class_1311.field_17715 || CreaturePalsCommands.isIncludedEntity(type)).orElse(false)).collect(Collectors.toList());
    }

    private static boolean isIncludedEntity(class_1299<?> entityType) {
        return entityType == class_1299.field_6077 || entityType == class_1299.field_6147 || entityType == class_1299.field_6047;
    }

    private static List<String> getLivingEntityTypeNames() {
        return CreaturePalsCommands.getLivingEntityIds().stream().map(class_2960::toString).collect(Collectors.toList());
    }

    private static LiteralArgumentBuilder<class_2168> registerTTSCommand() {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)"tts").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(class_2170.method_9247((String)"on").executes(context -> {
            ServerPackets.SendTTSStatus(((class_2168)context.getSource()).method_44023(), true);
            return 1;
        }))).then(class_2170.method_9247((String)"off").executes(context -> {
            ServerPackets.SendTTSStatus(((class_2168)context.getSource()).method_44023(), false);
            return 1;
        })));
    }

    private static LiteralArgumentBuilder<class_2168> registerChatBubbleCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"chatbubble").requires(source -> source.method_9259(4))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"on").then(CreaturePalsCommands.addConfigArgs((context, useServerConfig) -> CreaturePalsCommands.setChatBubbleEnabled((CommandContext<class_2168>)context, true, useServerConfig)))).executes(context -> CreaturePalsCommands.setChatBubbleEnabled((CommandContext<class_2168>)context, true, false)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"off").then(CreaturePalsCommands.addConfigArgs((context, useServerConfig) -> CreaturePalsCommands.setChatBubbleEnabled((CommandContext<class_2168>)context, false, useServerConfig)))).executes(context -> CreaturePalsCommands.setChatBubbleEnabled((CommandContext<class_2168>)context, false, false))));
    }

    private static int setChatBubbleEnabled(CommandContext<class_2168> context, boolean enabled, boolean useServerConfig) {
        class_2168 source = (class_2168)context.getSource();
        ConfigurationHandler configHandler = new ConfigurationHandler(source.method_9211());
        ConfigurationHandler.Config config = configHandler.loadConfig();
        config.setChatBubbles(enabled);
        if (configHandler.saveConfig(config, useServerConfig)) {
            class_5250 feedbackMessage = class_2561.method_43470((String)("Player chat bubbles have been " + (enabled ? "enabled" : "disabled") + ".")).method_27692(class_124.field_1060);
            source.method_9226(() -> CreaturePalsCommands.lambda$setChatBubbleEnabled$13((class_2561)feedbackMessage), true);
            return 1;
        }
        class_5250 feedbackMessage = class_2561.method_43470((String)"Failed to update player chat bubble setting.").method_27692(class_124.field_1061);
        source.method_9226(() -> CreaturePalsCommands.lambda$setChatBubbleEnabled$14((class_2561)feedbackMessage), false);
        return 0;
    }

    private static LiteralArgumentBuilder<class_2168> registerWhitelistCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"whitelist").requires(source -> source.method_9259(4))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entityType", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> class_2172.method_9270(CreaturePalsCommands.getLivingEntityIds(), (SuggestionsBuilder)builder)).then(CreaturePalsCommands.addConfigArgs((context, useServerConfig) -> CreaturePalsCommands.modifyList((CommandContext<class_2168>)context, "whitelist", class_2232.method_9443((CommandContext)context, (String)"entityType").toString(), useServerConfig)))).executes(context -> CreaturePalsCommands.modifyList((CommandContext<class_2168>)context, "whitelist", class_2232.method_9443((CommandContext)context, (String)"entityType").toString(), false)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"all").then(CreaturePalsCommands.addConfigArgs((context, useServerConfig) -> CreaturePalsCommands.modifyList((CommandContext<class_2168>)context, "whitelist", "all", useServerConfig)))).executes(context -> CreaturePalsCommands.modifyList((CommandContext<class_2168>)context, "whitelist", "all", false)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").then(CreaturePalsCommands.addConfigArgs((context, useServerConfig) -> CreaturePalsCommands.modifyList((CommandContext<class_2168>)context, "whitelist", "clear", useServerConfig)))).executes(context -> CreaturePalsCommands.modifyList((CommandContext<class_2168>)context, "whitelist", "clear", false)));
    }

    private static LiteralArgumentBuilder<class_2168> registerBlacklistCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"blacklist").requires(source -> source.method_9259(4))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entityType", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> class_2172.method_9270(CreaturePalsCommands.getLivingEntityIds(), (SuggestionsBuilder)builder)).then(CreaturePalsCommands.addConfigArgs((context, useServerConfig) -> CreaturePalsCommands.modifyList((CommandContext<class_2168>)context, "blacklist", class_2232.method_9443((CommandContext)context, (String)"entityType").toString(), useServerConfig)))).executes(context -> CreaturePalsCommands.modifyList((CommandContext<class_2168>)context, "blacklist", class_2232.method_9443((CommandContext)context, (String)"entityType").toString(), false)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"all").then(CreaturePalsCommands.addConfigArgs((context, useServerConfig) -> CreaturePalsCommands.modifyList((CommandContext<class_2168>)context, "blacklist", "all", useServerConfig)))).executes(context -> CreaturePalsCommands.modifyList((CommandContext<class_2168>)context, "blacklist", "all", false)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").then(CreaturePalsCommands.addConfigArgs((context, useServerConfig) -> CreaturePalsCommands.modifyList((CommandContext<class_2168>)context, "blacklist", "clear", useServerConfig)))).executes(context -> CreaturePalsCommands.modifyList((CommandContext<class_2168>)context, "blacklist", "clear", false)));
    }

    private static LiteralArgumentBuilder<class_2168> registerHelpCommand() {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)"help").executes(context -> {
            String helpMessage = "Usage of CreaturePals Commands:\n/creaturepals tts set <on | off> - Sets text to speech (TTS)/creaturepals key set <key> - Sets the API key\n/creaturepals url set \"<url>\" - Sets the URL\n/creaturepals model set <model> - Sets the model\n/creaturepals timeout set <seconds> - Sets the API timeout\n/creaturepals story set \"<story>\" - Sets a custom story\n/creaturepals chatbubbles set <on | off> - Show player chat bubbles\n/creaturepals whitelist <entityType | all | clear> - Show chat bubbles\n/creaturepals blacklist <entityType | all | clear> - Hide chat bubbles\n\nOptional: Append [--config default | server] to any command to specify configuration scope.\n\nSecurity: Level 4 permission required.";
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)helpMessage), false);
            return 1;
        });
    }

    private static LiteralArgumentBuilder<class_2168> registerStoryCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"story").requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.string()).then(CreaturePalsCommands.addConfigArgs((context, useServerConfig) -> {
            String story = StringArgumentType.getString((CommandContext)context, (String)"value");
            ConfigurationHandler.Config config = new ConfigurationHandler(((class_2168)context.getSource()).method_9211()).loadConfig();
            config.setStory(story);
            if (new ConfigurationHandler(((class_2168)context.getSource()).method_9211()).saveConfig(config, useServerConfig)) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Story set successfully: " + story)).method_27692(class_124.field_1060), true);
                return 1;
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Failed to set story!").method_27692(class_124.field_1061), false);
            return 0;
        }))))).then(class_2170.method_9247((String)"clear").then(CreaturePalsCommands.addConfigArgs((context, useServerConfig) -> {
            ConfigurationHandler.Config config = new ConfigurationHandler(((class_2168)context.getSource()).method_9211()).loadConfig();
            config.setStory("");
            if (new ConfigurationHandler(((class_2168)context.getSource()).method_9211()).saveConfig(config, useServerConfig)) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Story cleared successfully!").method_27692(class_124.field_1060), true);
                return 1;
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Failed to clear story!").method_27692(class_124.field_1061), false);
            return 0;
        })))).then(class_2170.method_9247((String)"display").executes(context -> {
            ConfigurationHandler.Config config = new ConfigurationHandler(((class_2168)context.getSource()).method_9211()).loadConfig();
            String story = config.getStory();
            if (story == null || story.isEmpty()) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"No story is currently set.").method_27692(class_124.field_1061), false);
                return 0;
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Current story: " + story)).method_27692(class_124.field_1075), false);
            return 1;
        }));
    }

    private static <T> int setConfig(class_2168 source, String settingName, T value, boolean useServerConfig, String settingDescription) {
        class_5250 feedbackMessage;
        ConfigurationHandler configHandler = new ConfigurationHandler(source.method_9211());
        ConfigurationHandler.Config config = configHandler.loadConfig();
        try {
            switch (settingName) {
                case "key": {
                    config.setApiKey((String)value);
                    break;
                }
                case "url": {
                    config.setUrl((String)value);
                    break;
                }
                case "model": {
                    config.setModel((String)value);
                    break;
                }
                case "timeout": {
                    if (value instanceof Integer) {
                        config.setTimeout((Integer)value);
                        break;
                    }
                    throw new IllegalArgumentException("Invalid type for timeout, must be Integer.");
                }
                default: {
                    throw new IllegalArgumentException("Unknown configuration setting: " + settingName);
                }
            }
        }
        catch (ClassCastException e) {
            class_5250 errorMessage = class_2561.method_43470((String)("Invalid type for setting " + settingName)).method_27692(class_124.field_1061);
            source.method_9226(() -> CreaturePalsCommands.lambda$setConfig$43((class_2561)errorMessage), false);
            LOGGER.error("Type mismatch during configuration setting for: " + settingName, (Throwable)e);
            return 0;
        }
        catch (IllegalArgumentException e) {
            class_5250 errorMessage = class_2561.method_43470((String)e.getMessage()).method_27692(class_124.field_1061);
            source.method_9226(() -> CreaturePalsCommands.lambda$setConfig$44((class_2561)errorMessage), false);
            LOGGER.error("Error setting configuration: " + e.getMessage(), (Throwable)e);
            return 0;
        }
        if (configHandler.saveConfig(config, useServerConfig)) {
            feedbackMessage = class_2561.method_43470((String)(settingDescription + " Set Successfully!")).method_27692(class_124.field_1060);
            source.method_9226(() -> CreaturePalsCommands.lambda$setConfig$45((class_2561)feedbackMessage), false);
            LOGGER.info("Command executed: " + feedbackMessage.getString());
            return 1;
        }
        feedbackMessage = class_2561.method_43470((String)(settingDescription + " Set Failed!")).method_27692(class_124.field_1061);
        source.method_9226(() -> CreaturePalsCommands.lambda$setConfig$46((class_2561)feedbackMessage), false);
        LOGGER.info("Command executed: " + feedbackMessage.getString());
        return 0;
    }

    private static int modifyList(CommandContext<class_2168> context, String listName, String action, boolean useServerConfig) {
        class_5250 feedbackMessage;
        class_2168 source = (class_2168)context.getSource();
        ConfigurationHandler configHandler = new ConfigurationHandler(source.method_9211());
        ConfigurationHandler.Config config = configHandler.loadConfig();
        List<String> entityTypes = CreaturePalsCommands.getLivingEntityTypeNames();
        try {
            if ("all".equals(action)) {
                if ("whitelist".equals(listName)) {
                    config.setWhitelist(entityTypes);
                    config.setBlacklist(new ArrayList<String>());
                } else if ("blacklist".equals(listName)) {
                    config.setBlacklist(entityTypes);
                    config.setWhitelist(new ArrayList<String>());
                }
            } else if ("clear".equals(action)) {
                if ("whitelist".equals(listName)) {
                    config.setWhitelist(new ArrayList<String>());
                } else if ("blacklist".equals(listName)) {
                    config.setBlacklist(new ArrayList<String>());
                }
            } else {
                if (!entityTypes.contains(action)) {
                    throw new IllegalArgumentException("Invalid entity type: " + action);
                }
                if ("whitelist".equals(listName)) {
                    ArrayList<String> whitelist = new ArrayList<String>(config.getWhitelist());
                    if (!whitelist.contains(action)) {
                        whitelist.add(action);
                        config.setWhitelist(whitelist);
                    }
                    ArrayList<String> blacklist = new ArrayList<String>(config.getBlacklist());
                    blacklist.remove(action);
                    config.setBlacklist(blacklist);
                } else if ("blacklist".equals(listName)) {
                    ArrayList<String> blacklist = new ArrayList<String>(config.getBlacklist());
                    if (!blacklist.contains(action)) {
                        blacklist.add(action);
                        config.setBlacklist(blacklist);
                    }
                    ArrayList<String> whitelist = new ArrayList<String>(config.getWhitelist());
                    whitelist.remove(action);
                    config.setWhitelist(whitelist);
                }
            }
        }
        catch (IllegalArgumentException e) {
            class_5250 errorMessage = class_2561.method_43470((String)e.getMessage()).method_27692(class_124.field_1061);
            source.method_9226(() -> CreaturePalsCommands.lambda$modifyList$47((class_2561)errorMessage), false);
            LOGGER.error("Error modifying list: " + e.getMessage(), (Throwable)e);
            return 0;
        }
        if (configHandler.saveConfig(config, useServerConfig)) {
            feedbackMessage = class_2561.method_43470((String)("Successfully updated " + listName + " with " + action)).method_27692(class_124.field_1060);
            source.method_9226(() -> CreaturePalsCommands.lambda$modifyList$48((class_2561)feedbackMessage), false);
            ServerPackets.send_whitelist_blacklist(null);
            return 1;
        }
        feedbackMessage = class_2561.method_43470((String)("Failed to update " + listName)).method_27692(class_124.field_1061);
        source.method_9226(() -> CreaturePalsCommands.lambda$modifyList$49((class_2561)feedbackMessage), false);
        return 0;
    }

    private static LiteralArgumentBuilder<class_2168> addConfigArgs(CommandExecutor executor) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"--config").then(class_2170.method_9247((String)"default").executes(context -> executor.run((CommandContext<class_2168>)context, false)))).then(class_2170.method_9247((String)"server").executes(context -> executor.run((CommandContext<class_2168>)context, true)))).executes(context -> executor.run((CommandContext<class_2168>)context, false));
    }

    private static /* synthetic */ class_2561 lambda$modifyList$49(class_2561 feedbackMessage) {
        return feedbackMessage;
    }

    private static /* synthetic */ class_2561 lambda$modifyList$48(class_2561 feedbackMessage) {
        return feedbackMessage;
    }

    private static /* synthetic */ class_2561 lambda$modifyList$47(class_2561 errorMessage) {
        return errorMessage;
    }

    private static /* synthetic */ class_2561 lambda$setConfig$46(class_2561 feedbackMessage) {
        return feedbackMessage;
    }

    private static /* synthetic */ class_2561 lambda$setConfig$45(class_2561 feedbackMessage) {
        return feedbackMessage;
    }

    private static /* synthetic */ class_2561 lambda$setConfig$44(class_2561 errorMessage) {
        return errorMessage;
    }

    private static /* synthetic */ class_2561 lambda$setConfig$43(class_2561 errorMessage) {
        return errorMessage;
    }

    private static /* synthetic */ class_2561 lambda$setChatBubbleEnabled$14(class_2561 feedbackMessage) {
        return feedbackMessage;
    }

    private static /* synthetic */ class_2561 lambda$setChatBubbleEnabled$13(class_2561 feedbackMessage) {
        return feedbackMessage;
    }

    @FunctionalInterface
    private static interface CommandExecutor {
        public int run(CommandContext<class_2168> var1, boolean var2) throws CommandSyntaxException;
    }
}

