/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.goals;

import com.owlmaddie.goals.GoalPriority;
import com.owlmaddie.goals.GoalUtils;
import com.owlmaddie.network.ServerPackets;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1308;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_3218;
import net.minecraft.class_4135;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityBehaviorManager {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");

    public static void addGoal(class_1308 entity, class_1352 goal, GoalPriority priority) {
        if (!(entity.method_37908() instanceof class_3218)) {
            LOGGER.debug("Attempted to add a goal in a non-server world. Aborting.");
            return;
        }
        ServerPackets.serverInstance.execute(() -> {
            class_1355 goalSelector = GoalUtils.getGoalSelector(entity);
            EntityBehaviorManager.clearAndRemove(g -> goal.getClass().equals(g.getClass()), goalSelector);
            EntityBehaviorManager.moveConflictingGoals(goalSelector, priority);
            goalSelector.method_6277(priority.getPriority(), goal);
            LOGGER.debug("Goal of type {} added with priority {}", (Object)goal.getClass().getSimpleName(), (Object)priority);
        });
    }

    public static void clearAndRemove(Predicate<class_1352> predicate, class_1355 goalSelector) {
        List<class_4135> toBeRemoved = goalSelector.method_35115().stream().filter(prioritizedGoal -> predicate.test(prioritizedGoal.method_19058())).collect(Collectors.toList());
        toBeRemoved.forEach(prioritizedGoal -> goalSelector.method_6280(prioritizedGoal.method_19058()));
    }

    public static void removeGoal(class_1308 entity, Class<? extends class_1352> goalClass) {
        ServerPackets.serverInstance.execute(() -> {
            class_1355 goalSelector = GoalUtils.getGoalSelector(entity);
            EntityBehaviorManager.clearAndRemove(g -> goalClass.equals(g.getClass()), goalSelector);
            LOGGER.debug("All goals of type {} removed.", (Object)goalClass.getSimpleName());
        });
    }

    public static void moveConflictingGoals(class_1355 goalSelector, GoalPriority newGoalPriority) {
        List sortedGoals = goalSelector.method_35115().stream().sorted(Comparator.comparingInt(class_4135::method_19057)).collect(Collectors.toList());
        boolean conflictExists = sortedGoals.stream().anyMatch(pg -> pg.method_19057() == newGoalPriority.getPriority());
        if (conflictExists) {
            int shiftPriority = newGoalPriority.getPriority();
            for (class_4135 pg2 : sortedGoals) {
                if (pg2.method_19057() < shiftPriority) continue;
                goalSelector.method_6280(pg2.method_19058());
                goalSelector.method_6277(shiftPriority + 1, pg2.method_19058());
                ++shiftPriority;
            }
            LOGGER.debug("Moved conflicting goals starting from priority {}", (Object)newGoalPriority);
        } else {
            LOGGER.debug("No conflicting goal at priority {}, no action taken.", (Object)newGoalPriority);
        }
    }
}

