/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.message;

import com.owlmaddie.message.Behavior;
import com.owlmaddie.message.ParsedMessage;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageParser {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");

    public static ParsedMessage parseMessage(String input) {
        LOGGER.debug("Parsing message: {}", (Object)input);
        StringBuilder cleanedMessage = new StringBuilder();
        ArrayList<Behavior> behaviors = new ArrayList<Behavior>();
        Pattern pattern = Pattern.compile("[<*](FOLLOW|LEAD|FLEE|ATTACK|PROTECT|FRIENDSHIP|UNFOLLOW|UNLEAD|UNFLEE|UNATTACK|UNPROTECT)[:\\s]*(\\s*[+-]?\\d+)?[>*]", 2);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            String behaviorName = matcher.group(1);
            Integer argument = null;
            if (matcher.group(2) != null) {
                argument = Integer.valueOf(matcher.group(2));
            }
            behaviors.add(new Behavior(behaviorName, argument));
            LOGGER.debug("Found behavior: {} with argument: {}", (Object)behaviorName, (Object)argument);
            matcher.appendReplacement(cleanedMessage, "");
        }
        matcher.appendTail(cleanedMessage);
        String displayMessage = cleanedMessage.toString().trim();
        displayMessage = displayMessage.replaceAll("<>", "").replaceAll("\\*\\*", "").trim();
        LOGGER.debug("Cleaned message: {}", (Object)displayMessage);
        return new ParsedMessage(displayMessage, input.trim(), behaviors);
    }
}

