/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.player2;

import com.owlmaddie.player2.Player2APIService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class HeartbeatManager {
    static Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");
    public static final ExecutorService heartbeatManager = Executors.newSingleThreadExecutor();
    public static long lastHeartbeatTime = System.nanoTime();
    public static boolean isConnected = false;

    public static void sendHeartbeat() {
        heartbeatManager.submit(() -> {
            try {
                Player2APIService.sendHeartbeat();
                isConnected = true;
                LOGGER.info("Player2 API connection established");
            }
            catch (Exception e) {
                isConnected = false;
                LOGGER.error("Player2 API connection failed: " + e.getMessage());
            }
        });
    }

    public static void injectIntoOnTick() {
        long now = System.nanoTime();
        if (now - lastHeartbeatTime > 60000000000L) {
            HeartbeatManager.sendHeartbeat();
            lastHeartbeatTime = now;
        }
    }

    public static boolean isConnected() {
        return isConnected;
    }

    public static void forceHeartbeat() {
        lastHeartbeatTime = 0L;
        HeartbeatManager.injectIntoOnTick();
    }
}

