/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.player2;

import com.owlmaddie.utils.ClientEntityFinder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_6880;

@Environment(value=EnvType.CLIENT)
public class Player2AudioHandler {
    private static final ConcurrentHashMap<UUID, String> activeAudioFiles = new ConcurrentHashMap();
    private static final String SOUND_NAMESPACE = "creaturepals";
    private static final String TTS_SOUND_NAME = "tts_audio";

    public static boolean playAudioFile(File audioFile, UUID entityId) {
        if (audioFile == null || !audioFile.exists()) {
            System.err.println("Audio file does not exist: " + String.valueOf(audioFile));
            return false;
        }
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.field_1724 == null) {
            System.err.println("Minecraft client not ready for audio playback");
            return false;
        }
        try {
            System.out.println("Source audio file: " + audioFile.getAbsolutePath());
            System.out.println("Source file size: " + audioFile.length() + " bytes");
            activeAudioFiles.put(entityId, audioFile.getAbsolutePath());
            class_1308 entity = ClientEntityFinder.getEntityByUUID(mc.field_1687, entityId);
            if (entity == null) {
                System.out.println("Entity not found, playing TTS at player location");
                entity = mc.field_1724;
            }
            Player2AudioHandler.play3DAudio(audioFile, (class_1297)entity, mc);
            return true;
        }
        catch (Exception e) {
            System.err.println("Failed to prepare audio file for playback: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private static void play3DAudio(File audioFile, class_1297 entity, class_310 mc) {
        try {
            class_243 entityPos = entity.method_19538();
            class_243 playerPos = mc.field_1724.method_19538();
            double distance = entityPos.method_1022(playerPos);
            class_243 direction = entityPos.method_1020(playerPos).method_1029();
            System.out.println("Playing 3D TTS audio at entity position: " + String.valueOf(entityPos));
            System.out.println("Distance from player: " + String.format("%.2f", distance) + " blocks");
            Thread audioThread = new Thread(() -> {
                try {
                    int bytesRead;
                    AudioInputStream audioStream = AudioSystem.getAudioInputStream(audioFile);
                    AudioFormat format = audioStream.getFormat();
                    DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
                    if (!AudioSystem.isLineSupported(info)) {
                        System.err.println("Audio format not supported: " + String.valueOf(format));
                        return;
                    }
                    SourceDataLine audioLine = (SourceDataLine)AudioSystem.getLine(info);
                    audioLine.open(format);
                    audioLine.start();
                    float volume = Player2AudioHandler.calculate3DVolume(distance);
                    float pan = Player2AudioHandler.calculate3DPan(direction);
                    System.out.println("3D Audio - Volume: " + String.format("%.2f", Float.valueOf(volume)) + ", Pan: " + String.format("%.2f", Float.valueOf(pan)));
                    Player2AudioHandler.apply3DEffects(audioLine, volume, pan);
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = audioStream.read(buffer)) != -1) {
                        audioLine.write(buffer, 0, bytesRead);
                    }
                    audioLine.drain();
                    audioLine.close();
                    audioStream.close();
                    System.out.println("3D TTS audio playback completed successfully");
                }
                catch (Exception e) {
                    System.err.println("Failed to play 3D audio: " + e.getMessage());
                    e.printStackTrace();
                    try {
                        mc.execute(() -> mc.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)0.5f)));
                        System.out.println("Fallback notification sound played");
                    }
                    catch (Exception fallbackEx) {
                        System.err.println("Failed to play fallback sound: " + fallbackEx.getMessage());
                    }
                }
            });
            audioThread.setDaemon(true);
            audioThread.start();
        }
        catch (Exception e) {
            System.err.println("Failed to start 3D audio playback: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static float calculate3DVolume(double distance) {
        double maxDistance = 64.0;
        double volume = Math.max(0.1, 1.0 - distance / maxDistance);
        return (float)volume;
    }

    private static float calculate3DPan(class_243 direction) {
        double pan = direction.field_1352;
        return (float)Math.max(-1.0, Math.min(1.0, pan));
    }

    private static void apply3DEffects(SourceDataLine audioLine, float volume, float pan) {
        try {
            FloatControl panControl;
            FloatControl volumeControl = (FloatControl)audioLine.getControl(FloatControl.Type.MASTER_GAIN);
            if (volumeControl != null) {
                float minGain = volumeControl.getMinimum();
                float maxGain = volumeControl.getMaximum();
                float gain = minGain + (maxGain - minGain) * volume;
                volumeControl.setValue(gain);
            }
            if ((panControl = (FloatControl)audioLine.getControl(FloatControl.Type.BALANCE)) != null) {
                panControl.setValue(pan);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to apply 3D audio effects: " + e.getMessage());
        }
    }

    public static void cleanupAudio(UUID entityId) {
        String audioPath = activeAudioFiles.remove(entityId);
        if (audioPath != null) {
            try {
                File audioFile = new File(audioPath);
                if (audioFile.exists()) {
                    Files.delete(audioFile.toPath());
                    System.out.println("Cleaned up audio file: " + audioPath);
                }
            }
            catch (IOException e) {
                System.err.println("Failed to cleanup audio file: " + e.getMessage());
            }
        }
    }

    public static void cleanupAllAudio() {
        for (UUID entityId : activeAudioFiles.keySet()) {
            Player2AudioHandler.cleanupAudio(entityId);
        }
    }
}

