/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.player2.auth;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.owlmaddie.player2.Player2APIService;
import com.owlmaddie.player2.auth.OAuthData;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class Player2OAuthHandler {
    private static final String OAUTH_BASE_URL = "https://api.player2.game/v1";
    private static final String DEVICE_AUTH_URL = "https://api.player2.game/v1/login/device/new";
    private static final String OAUTH_TOKEN_URL = "https://api.player2.game/v1/login/device/token";
    private static final String CLIENT_ID = "01977e1e-0b52-7269-ac8d-97522d4c1c21";
    private static boolean hasCheckedApiKey = false;
    private static boolean isApiKeyValid = false;
    private static Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");
    private static ScheduledExecutorService executor;
    private static boolean isAuthenticating;
    private static ExecutorService authExecutor;

    public static void startOAuthFlow(Consumer<OAuthData> onData, Runnable onSuccess, Runnable onError) {
        if (isAuthenticating) {
            LOGGER.info("Already auth, skipping");
            return;
        }
        executor = Executors.newScheduledThreadPool(1);
        isAuthenticating = true;
        Player2OAuthHandler.attemptWebLoginOrFallback(onData, onSuccess, onError);
    }

    private static void attemptWebLoginOrFallback(Consumer<OAuthData> onData, Runnable onSuccess, Runnable onError) {
        authExecutor.submit(() -> {
            try {
                JsonObject json;
                String url = "http://127.0.0.1:4315/v1/login/web/01977e1e-0b52-7269-ac8d-97522d4c1c21";
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).POST(HttpRequest.BodyPublishers.noBody()).build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                System.out.println("Web login probe status: " + response.statusCode());
                System.out.println("Web login probe body: " + response.body());
                if (response.statusCode() == 200 && (json = JsonParser.parseString((String)response.body()).getAsJsonObject()).has("p2Key")) {
                    String p2Key = json.get("p2Key").getAsString();
                    Player2OAuthHandler.setApiKey(p2Key);
                    System.out.println("Obtained Player2 API key via web login probe.");
                    isAuthenticating = false;
                    onSuccess.run();
                    return;
                }
                Player2OAuthHandler.startDeviceAuthorization(onData, onSuccess, onError);
            }
            catch (Exception e) {
                System.err.println("Web login probe failed: " + e.getMessage());
                Player2OAuthHandler.startDeviceAuthorization(onData, onSuccess, onError);
            }
        });
    }

    private static void startDeviceAuthorization(Consumer<OAuthData> onData, Runnable onSuccess, Runnable onError) {
        try {
            JsonObject deviceResponse;
            JsonObject deviceRequest = new JsonObject();
            deviceRequest.addProperty("client_id", CLIENT_ID);
            deviceRequest.addProperty("scope", "api");
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(DEVICE_AUTH_URL)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(deviceRequest.toString())).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            System.out.println("Device authorization response status: " + response.statusCode());
            System.out.println("Device authorization response body: " + response.body());
            if (response.statusCode() == 200) {
                deviceResponse = JsonParser.parseString((String)response.body()).getAsJsonObject();
                System.out.println("Device authorization response: " + deviceResponse.toString());
                if (!deviceResponse.has("deviceCode")) {
                    throw new RuntimeException("Missing 'deviceCode' field in response");
                }
                if (!deviceResponse.has("userCode")) {
                    throw new RuntimeException("Missing 'userCode' field in response");
                }
                if (!deviceResponse.has("verificationUri")) {
                    throw new RuntimeException("Missing 'verificationUri' field in response");
                }
                if (!deviceResponse.has("interval")) {
                    throw new RuntimeException("Missing 'interval' field in response");
                }
            } else {
                System.err.println("Device authorization request failed with status " + response.statusCode());
                System.err.println("Response body: " + response.body());
                throw new RuntimeException("Device authorization request failed with status " + response.statusCode() + ": " + response.body());
            }
            String deviceCode = deviceResponse.get("deviceCode").getAsString();
            String userCode = deviceResponse.get("userCode").getAsString();
            String verificationUri = deviceResponse.get("verificationUri").getAsString();
            String verificationUriComplete = deviceResponse.get("verificationUriComplete").getAsString();
            int interval = deviceResponse.get("interval").getAsInt();
            OAuthData data = new OAuthData(deviceCode, userCode, verificationUri, interval, verificationUriComplete);
            onData.accept(data);
            Player2OAuthHandler.startTokenPolling(deviceCode, interval, onSuccess);
        }
        catch (Exception e) {
            System.err.println("Device authorization failed: " + e.getMessage());
            isAuthenticating = false;
            onError.run();
        }
    }

    private static void startTokenPolling(String deviceCode, int interval, Runnable onSuccess) {
        executor.scheduleWithFixedDelay(() -> {
            try {
                JsonObject errorResponse;
                JsonObject tokenRequest = new JsonObject();
                tokenRequest.addProperty("grant_type", "urn:ietf:params:oauth:grant-type:device_code");
                tokenRequest.addProperty("client_id", CLIENT_ID);
                tokenRequest.addProperty("device_code", deviceCode);
                HttpClient client = HttpClient.newHttpClient();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(OAUTH_TOKEN_URL)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(tokenRequest.toString())).build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                System.out.println("Token polling response status: " + response.statusCode());
                System.out.println("Token polling response body: " + response.body());
                if (response.statusCode() == 200) {
                    JsonObject tokenResponse = JsonParser.parseString((String)response.body()).getAsJsonObject();
                    if (tokenResponse.has("p2Key")) {
                        String p2Key = tokenResponse.get("p2Key").getAsString();
                        Player2OAuthHandler.setApiKey(p2Key);
                        executor.shutdown();
                        System.out.println("Successfully obtained Player2 API key via Device Authorization Flow");
                        isAuthenticating = false;
                        onSuccess.run();
                    }
                } else if (response.statusCode() == 400 && (errorResponse = JsonParser.parseString((String)response.body()).getAsJsonObject()).has("error") && "authorization_pending".equals(errorResponse.get("error").getAsString())) {
                    return;
                }
            }
            catch (Exception e) {
                System.err.println("Token polling failed: " + e.getMessage());
            }
        }, interval, interval, TimeUnit.SECONDS);
    }

    public static void openBrowser(String url) {
        try {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(new URI(url));
            } else {
                String os = System.getProperty("os.name").toLowerCase();
                if (os.contains("win")) {
                    Runtime.getRuntime().exec("cmd /c start " + url);
                } else if (os.contains("mac")) {
                    Runtime.getRuntime().exec("open " + url);
                } else if (os.contains("nix") || os.contains("nux")) {
                    Runtime.getRuntime().exec("xdg-open " + url);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Failed to open browser: " + e.getMessage());
        }
    }

    public static boolean isAuthenticating() {
        return isAuthenticating;
    }

    public static void resetAuthenticationState() {
        isAuthenticating = false;
    }

    @Nullable
    public static String getApiKey() {
        String apiKey = System.getProperty("PLAYER2_API_KEY");
        if (apiKey != null && !apiKey.trim().isEmpty()) {
            return apiKey.trim();
        }
        apiKey = System.getenv("PLAYER2_API_KEY");
        if (apiKey != null && !apiKey.trim().isEmpty()) {
            return apiKey.trim();
        }
        try {
            String minecraftDir = null;
            String os = System.getProperty("os.name").toLowerCase();
            minecraftDir = os.contains("win") ? System.getenv("APPDATA") + "\\.minecraft" : (os.contains("mac") ? System.getProperty("user.home") + "/Library/Application Support/minecraft" : System.getProperty("user.home") + "/.minecraft");
            File file = new File(minecraftDir, "p2key.txt");
            if (file.exists() && !(apiKey = new String(Files.readAllBytes(file.toPath())).trim()).isEmpty()) {
                System.setProperty("PLAYER2_API_KEY", apiKey);
                return apiKey;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to read API key from file: " + e.getMessage());
        }
        return null;
    }

    public static void checkApiKey(Runnable onNotFoundAPiKey, Consumer<String> onValidationErrStr) {
        if (hasCheckedApiKey) {
            return;
        }
        hasCheckedApiKey = true;
        LOGGER.info("Player2StartupHandler: Checking API key on startup...");
        String apiKey = Player2OAuthHandler.getApiKey();
        if (apiKey == null || apiKey.trim().isEmpty()) {
            LOGGER.info("Player2StartupHandler: No API key found, showing setup screen");
            onNotFoundAPiKey.run();
            return;
        }
        LOGGER.info("Player2StartupHandler: API key found, validating...");
        Player2OAuthHandler.validateApiKey(apiKey, onValidationErrStr);
    }

    public static void validateApiKey(String apiKey, Consumer<String> onValidationErrStr) {
        CompletableFuture.runAsync(() -> {
            try {
                Player2APIService.sendHeartbeat();
                isApiKeyValid = true;
                LOGGER.info("Player2 API key validated successfully: " + apiKey);
            }
            catch (Exception e) {
                isApiKeyValid = false;
                LOGGER.warn("Player2 API key validation failed: " + e.getMessage());
                onValidationErrStr.accept(e.getMessage());
            }
        });
    }

    public static void revalidateApiKey(Runnable onNotFoundAPiKey, Consumer<String> onValidationErrStr) {
        hasCheckedApiKey = false;
        isApiKeyValid = false;
        Player2OAuthHandler.checkApiKey(onNotFoundAPiKey, onValidationErrStr);
    }

    public static void clearApiKey() {
        System.clearProperty("PLAYER2_API_KEY");
        hasCheckedApiKey = false;
        isApiKeyValid = false;
    }

    public static void setApiKey(String apiKey) {
        if (apiKey != null && !apiKey.trim().isEmpty()) {
            System.setProperty("PLAYER2_API_KEY", apiKey.trim());
            try {
                String minecraftDir = null;
                String os = System.getProperty("os.name").toLowerCase();
                minecraftDir = os.contains("win") ? System.getenv("APPDATA") + "\\.minecraft" : (os.contains("mac") ? System.getProperty("user.home") + "/Library/Application Support/minecraft" : System.getProperty("user.home") + "/.minecraft");
                File file = new File(minecraftDir, "p2key.txt");
                Files.write(file.toPath(), apiKey.trim().getBytes(), new OpenOption[0]);
                LOGGER.debug("Player2 API key saved to: " + file.getAbsolutePath());
            }
            catch (Exception e) {
                LOGGER.warn("Failed to save API key to file: " + e.getMessage());
            }
            hasCheckedApiKey = false;
            isApiKeyValid = false;
        }
    }

    public static boolean hasCheckedApiKey() {
        return hasCheckedApiKey;
    }

    static {
        isAuthenticating = false;
        authExecutor = Executors.newSingleThreadExecutor();
    }
}

