/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.player2.auth;

import com.owlmaddie.player2.auth.OAuthData;
import com.owlmaddie.player2.auth.Player2OAuthHandler;
import com.owlmaddie.player2.auth.Player2OAuthScreen;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_442;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class Player2StartupHandler {
    static Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");

    private static void showApiKeyErrorScreen(String errorMessage) {
        class_310 client = class_310.method_1551();
        if (client != null && client.field_1755 != null) {
            client.method_1507((class_437)new Player2ApiKeyErrorScreen(client.field_1755, errorMessage));
        }
    }

    public static void checkApiKeyOnStartup() {
        Player2OAuthHandler.checkApiKey(Player2ApiKeySetupScreen::showApiKeySetupScreen, Player2ApiKeyErrorScreen.onValidationErrStr);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Player2ApiKeyErrorScreen
    extends class_437 {
        private final class_437 parent;
        private final String errorMessage;
        public static final Consumer<String> onValidationErrStr = errStr -> class_310.method_1551().execute(() -> Player2StartupHandler.showApiKeyErrorScreen(errStr));

        public Player2ApiKeyErrorScreen(class_437 parent, String errorMessage) {
            super((class_2561)class_2561.method_43470((String)"Player2 API Key Error"));
            this.parent = parent;
            this.errorMessage = errorMessage;
        }

        protected void method_25426() {
            super.method_25426();
            int centerX = this.field_22789 / 2;
            int centerY = this.field_22790 / 2;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"API Key Validation Failed"), button -> {}).method_46434(centerX - 100, centerY - 80, 200, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Error: " + this.errorMessage)), button -> {}).method_46434(centerX - 100, centerY - 50, 300, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Retry"), button -> this.retryValidation(Player2ApiKeySetupScreen::showApiKeySetupScreen, onValidationErrStr)).method_46434(centerX - 100, centerY, 200, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Setup New Key"), button -> this.setupNewKey()).method_46434(centerX - 100, centerY + 30, 200, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Continue Anyway"), button -> this.method_25419()).method_46434(centerX - 100, centerY + 60, 200, 20).method_46431());
        }

        private void retryValidation(Runnable onNotFoundAPiKey, Consumer<String> onValidationErrStr) {
            Player2OAuthHandler.revalidateApiKey(onNotFoundAPiKey, onValidationErrStr);
            this.method_25419();
        }

        private void setupNewKey() {
            this.field_22787.method_1507((class_437)new Player2ApiKeySetupScreen(this));
        }

        public void method_25419() {
            if (this.parent != null) {
                this.field_22787.method_1507(this.parent);
            } else {
                this.field_22787.method_1507((class_437)new class_442());
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Player2ApiKeySetupScreen
    extends class_437 {
        private final class_437 parent;
        private class_342 apiKeyField;
        private class_4185 saveButton;
        private class_4185 skipButton;
        private class_4185 helpButton;

        public Player2ApiKeySetupScreen(class_437 parent) {
            super((class_2561)class_2561.method_43470((String)"Player2 API Key Setup"));
            this.parent = parent;
            LOGGER.debug("Player2ApiKeySetupScreen: Constructor called with parent: " + (parent != null ? parent.getClass().getSimpleName() : "null"));
        }

        protected void method_25426() {
            super.method_25426();
            LOGGER.debug("Player2ApiKeySetupScreen: init() called");
            int centerX = this.field_22789 / 2;
            int centerY = this.field_22790 / 2;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Player2 API Key Required"), button -> {}).method_46434(centerX - 100, centerY - 80, 200, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"This mod requires a Player2 API key to function."), button -> {}).method_46434(centerX - 150, centerY - 50, 300, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Get your key at: player2.game"), button -> {}).method_46434(centerX - 150, centerY - 30, 300, 20).method_46431());
            this.apiKeyField = new class_342(this.field_22787.field_1772, centerX - 100, centerY, 200, 20, (class_2561)class_2561.method_43470((String)"Enter your Player2 API key"));
            this.apiKeyField.method_1880(100);
            this.apiKeyField.method_1863(text -> {
                this.saveButton.field_22763 = !text.trim().isEmpty();
            });
            this.saveButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save & Validate"), button -> this.saveApiKey()).method_46434(centerX - 100, centerY + 30, 200, 20).method_46431();
            this.saveButton.field_22763 = false;
            this.skipButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Skip for now"), button -> this.method_25419()).method_46434(centerX - 100, centerY + 60, 200, 20).method_46431();
            this.helpButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Help"), button -> this.showHelp()).method_46434(centerX - 100, centerY + 90, 200, 20).method_46431();
            this.method_25429((class_364)this.apiKeyField);
            this.method_37063((class_364)this.apiKeyField);
            this.method_37063((class_364)this.saveButton);
            this.method_37063((class_364)this.skipButton);
            this.method_37063((class_364)this.helpButton);
            this.method_48265((class_364)this.apiKeyField);
        }

        private void saveApiKey() {
            String apiKey = this.apiKeyField.method_25369().getString();
            if (apiKey.isEmpty()) {
                return;
            }
            try {
                System.setProperty("PLAYER2_API_KEY", apiKey);
                Player2OAuthHandler.validateApiKey(apiKey, Player2ApiKeyErrorScreen.onValidationErrStr);
                this.field_22787.method_1507((class_437)new class_410(this::onValidationComplete, (class_2561)class_2561.method_43470((String)"API Key Saved"), (class_2561)class_2561.method_43470((String)"Your Player2 API key has been saved for this session.\n\nNote: You'll need to set this as an environment variable for permanent storage."), (class_2561)class_2561.method_43470((String)"Continue"), (class_2561)class_2561.method_43470((String)"Exit")));
            }
            catch (Exception e) {
                this.field_22787.method_1507((class_437)new class_410(button -> this.field_22787.method_1507((class_437)this), (class_2561)class_2561.method_43470((String)"Error"), (class_2561)class_2561.method_43470((String)("Failed to save API key: " + e.getMessage())), (class_2561)class_2561.method_43470((String)"OK"), (class_2561)class_2561.method_43470((String)"Exit")));
            }
        }

        private void onValidationComplete(boolean confirmed) {
            if (confirmed) {
                this.method_25419();
            }
        }

        private void showHelp() {
            this.field_22787.method_1507((class_437)new class_410(button -> this.field_22787.method_1507((class_437)this), (class_2561)class_2561.method_43470((String)"How to Set Player2 API Key"), (class_2561)class_2561.method_43470((String)"1. Visit player2.game and sign up\n2. Get your API key from your account\n3. Set it as an environment variable:\n\nWindows (PowerShell):\n$env:PLAYER2_API_KEY=\"your_key\"\n\nWindows (CMD):\nset PLAYER2_API_KEY=your_key\n\nLinux/macOS:\nexport PLAYER2_API_KEY=\"your_key\"\n\n4. Restart Minecraft"), (class_2561)class_2561.method_43470((String)"OK"), (class_2561)class_2561.method_43470((String)"Exit")));
        }

        public void method_25419() {
            if (this.parent != null) {
                this.field_22787.method_1507(this.parent);
            } else {
                this.field_22787.method_1507((class_437)new class_442());
            }
        }

        private static void showApiKeySetupScreen() {
            LOGGER.info("Player2StartupHandler: showApiKeySetupScreen called");
            class_310 client = class_310.method_1551();
            if (client != null) {
                class_437 currentScreen = client.field_1755;
                LOGGER.info("Player2StartupHandler: Current screen: " + (currentScreen != null ? currentScreen.getClass().getSimpleName() : "null"));
                Runnable onSuccess = () -> class_310.method_1551().execute(() -> Player2OAuthScreen.showSuccessNotification());
                if (currentScreen instanceof class_442) {
                    LOGGER.info("Player2StartupHandler: On title screen, starting OAuth flow");
                    Consumer<OAuthData> onData = data -> class_310.method_1551().execute(() -> {
                        class_310 mcClient = class_310.method_1551();
                        if (mcClient != null) {
                            mcClient.method_1507((class_437)new Player2OAuthScreen(null, (OAuthData)data));
                        }
                    });
                    Player2OAuthHandler.startOAuthFlow(onData, onSuccess, () -> LOGGER.error("Start oauth err!"));
                } else if (currentScreen != null) {
                    LOGGER.info("Player2StartupHandler: On other screen, starting OAuth flow");
                    Consumer<OAuthData> onData = data -> class_310.method_1551().execute(() -> {
                        class_310 mcClient = class_310.method_1551();
                        if (mcClient != null) {
                            mcClient.method_1507((class_437)new Player2OAuthScreen(currentScreen, (OAuthData)data));
                        }
                    });
                    Player2OAuthHandler.startOAuthFlow(onData, onSuccess, () -> LOGGER.error("Start oauth err!"));
                }
            } else {
                LOGGER.warn("Player2StartupHandler: Minecraft client is null!");
            }
        }
    }
}

