/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.ui;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;

@Environment(value=EnvType.CLIENT)
public class BubbleLocationManager {
    private static final Map<UUID, BubbleData> bubbleDataMap = new ConcurrentHashMap<UUID, BubbleData>();

    public static void updateBubbleData(UUID entityId, class_243 position, double width, double height, double yaw, double pitch) {
        bubbleDataMap.put(entityId, new BubbleData(position, width, height, yaw, pitch));
    }

    public static BubbleData getBubbleData(UUID entityId) {
        return bubbleDataMap.get(entityId);
    }

    public static void performCleanup(List<UUID> activeEntityIds) {
        bubbleDataMap.keySet().retainAll(activeEntityIds);
    }

    public static Map<UUID, BubbleData> getAllBubbleData() {
        return Collections.unmodifiableMap(bubbleDataMap);
    }

    @Environment(value=EnvType.CLIENT)
    public static class BubbleData {
        public final class_243 position;
        public final double width;
        public final double height;
        public final double yaw;
        public final double pitch;

        public BubbleData(class_243 position, double width, double height, double yaw, double pitch) {
            this.position = position;
            this.width = width;
            this.height = height;
            this.yaw = yaw;
            this.pitch = pitch;
        }
    }
}

