/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.ui;

import com.owlmaddie.chat.ChatDataManager;
import com.owlmaddie.ui.PlayerMessage;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class PlayerMessageManager {
    private static final ConcurrentHashMap<UUID, PlayerMessage> messages = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Boolean> openChatUIs = new ConcurrentHashMap();

    public static void addMessage(UUID playerUUID, String messageText, String playerName, int ticks) {
        messages.put(playerUUID, new PlayerMessage(playerUUID.toString(), messageText, ticks));
    }

    public static PlayerMessage getMessage(UUID playerId) {
        return messages.get(playerId);
    }

    public static void tickUpdate() {
        messages.forEach((uuid, playerMessage) -> {
            if (playerMessage.tickCountdown.decrementAndGet() <= 0) {
                PlayerMessageManager.nextLineOrRemove(uuid, playerMessage);
            }
        });
    }

    private static void nextLineOrRemove(UUID uuid, PlayerMessage playerMessage) {
        if (!playerMessage.isEndOfMessage()) {
            playerMessage.currentLineNumber += ChatDataManager.DISPLAY_NUM_LINES;
            playerMessage.tickCountdown.set(ChatDataManager.TICKS_TO_DISPLAY_USER_MESSAGE);
        } else {
            messages.remove(uuid);
        }
    }

    public static void openChatUI(UUID playerId) {
        openChatUIs.put(playerId, Boolean.TRUE);
    }

    public static boolean isChatUIOpen(UUID playerId) {
        return openChatUIs.getOrDefault(playerId, Boolean.FALSE);
    }

    public static void closeChatUI(UUID playerId) {
        openChatUIs.remove(playerId);
    }
}

