/*
 * Decompiled with CFR 0.152.
 */
package com.owlmaddie.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class TextureLoader {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"creaturepals");
    private static final Set<String> missing = new HashSet<String>();

    public class_2960 GetUI(String name) {
        String texturePath = "textures/ui/" + name + ".png";
        class_2960 textureId = new class_2960("creaturepals", texturePath);
        Optional resource = class_310.method_1551().method_1478().method_14486(textureId);
        if (resource.isPresent()) {
            RenderSystem.setShaderTexture((int)0, (class_2960)textureId);
            return textureId;
        }
        this.logMissingTextureOnce(texturePath);
        return null;
    }

    public class_2960 GetEntity(String texturePath) {
        class_2960 textureId = new class_2960("creaturepals", texturePath);
        Optional resource = class_310.method_1551().method_1478().method_14486(textureId);
        if (resource.isPresent()) {
            RenderSystem.setShaderTexture((int)0, (class_2960)textureId);
            return textureId;
        }
        class_2960 notFoundId = new class_2960("creaturepals", "textures/entity/not_found.png");
        RenderSystem.setShaderTexture((int)0, (class_2960)notFoundId);
        this.logMissingTextureOnce(texturePath);
        return notFoundId;
    }

    private void logMissingTextureOnce(String texturePath) {
        if (missing.add(texturePath)) {
            LOGGER.info("{} was not found", (Object)texturePath);
        }
    }

    public static void bind(int unit, class_2960 textureId) {
        RenderSystem.setShaderTexture((int)unit, (class_2960)textureId);
    }
}

