/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.uar.ndev;

import dev.norska.uar.UltimateAutoRestart;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public class NorskaUtils {
    public List<String> aliases = new ArrayList<String>();

    public Boolean isAbove1_16() {
        return Bukkit.getVersion().contains("1.16") || Bukkit.getVersion().contains("1.17") || Bukkit.getVersion().contains("1.18") || Bukkit.getVersion().contains("1.19") || Bukkit.getVersion().contains("1.20") || Bukkit.getVersion().contains("1.21");
    }

    public int getSecondsFromString(String s) {
        int returnSeconds = 0;
        try {
            returnSeconds = Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            try {
                String[] splitString = s.split(":");
                if (splitString.length > 1) {
                    int hours = Integer.parseInt(splitString[0]);
                    int minutes = Integer.parseInt(splitString[1]);
                    return hours * 3600 + minutes * 60;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return returnSeconds;
    }

    public void fetchAliases(UltimateAutoRestart main) {
        try {
            String[] splitExtracted;
            String pluginString = Objects.requireNonNull(main.getServer().getPluginManager().getPlugin("UltimateAutoRestart")).getDescription().getCommands().toString();
            Pattern p = Pattern.compile("\\[(.*?)\\]");
            Matcher m = p.matcher(pluginString);
            String extracted = null;
            while (m.find()) {
                extracted = m.group(1);
            }
            for (String s : splitExtracted = ((String)Objects.requireNonNull(extracted)).split(",")) {
                this.aliases.add(s.toLowerCase());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String convertSecondsToFormattedString(UltimateAutoRestart main, int seconds) {
        long daysParsed = seconds / 86400;
        long hoursParsed = seconds % 86400 / 3600;
        long minutesParsed = seconds % 86400 % 3600 / 60;
        long secondsParsed = seconds % 86400 % 3600 % 60;
        StringBuilder stringBuilder = new StringBuilder();
        if (!(daysParsed <= 0L || main.getNHandler().getCacheHandler().getDays().isEmpty() && main.getNHandler().getCacheHandler().getDay().isEmpty())) {
            stringBuilder.append(daysParsed);
            if (daysParsed > 1L) {
                stringBuilder.append(main.getNHandler().getCacheHandler().getDays());
            } else {
                stringBuilder.append(main.getNHandler().getCacheHandler().getDay());
            }
        }
        if (!(hoursParsed <= 0L || main.getNHandler().getCacheHandler().getHours().isEmpty() && main.getNHandler().getCacheHandler().getHour().isEmpty())) {
            stringBuilder.append(hoursParsed);
            if (hoursParsed > 1L) {
                stringBuilder.append(main.getNHandler().getCacheHandler().getHours());
            } else {
                stringBuilder.append(main.getNHandler().getCacheHandler().getHour());
            }
        }
        if (!(minutesParsed <= 0L || main.getNHandler().getCacheHandler().getMinutes().isEmpty() && main.getNHandler().getCacheHandler().getMinute().isEmpty())) {
            if (hoursParsed > 1L && secondsParsed == 0L) {
                stringBuilder.append(main.getNHandler().getCacheHandler().getSplitter());
            }
            stringBuilder.append(minutesParsed);
            if (minutesParsed > 1L) {
                stringBuilder.append(main.getNHandler().getCacheHandler().getMinutes());
            } else {
                stringBuilder.append(main.getNHandler().getCacheHandler().getMinute());
            }
        }
        if (!(secondsParsed <= 0L || main.getNHandler().getCacheHandler().getSeconds().isEmpty() && main.getNHandler().getCacheHandler().getSecond().isEmpty())) {
            if (minutesParsed > 0L || hoursParsed > 0L) {
                stringBuilder.append(main.getNHandler().getCacheHandler().getSplitter());
            }
            stringBuilder.append(secondsParsed);
            if (secondsParsed > 1L) {
                stringBuilder.append(main.getNHandler().getCacheHandler().getSeconds());
            } else {
                stringBuilder.append(main.getNHandler().getCacheHandler().getSecond());
            }
        }
        String conversion = stringBuilder.toString();
        if ((conversion = conversion.trim()).endsWith(",")) {
            conversion = conversion.substring(0, conversion.length() - 1);
        }
        return NorskaUtils.trimEnd(stringBuilder.toString());
    }

    private static String trimEnd(String s) {
        int i;
        if (s == null || s.length() == 0) {
            return s;
        }
        for (i = s.length(); i > 0 && Character.isWhitespace(s.charAt(i - 1)); --i) {
        }
        if (i == s.length()) {
            return s;
        }
        return s.substring(0, i);
    }

    public String convertSecondsToHHMMSS(int seconds) {
        long hours = seconds / 3600;
        long minutes = seconds % 3600 / 60;
        long secs = seconds % 60;
        return String.format("%02d:%02d:%02d", hours, minutes, secs);
    }

    public List<String> getAliases() {
        return this.aliases;
    }
}

