/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.uar;

import dev.norska.niridiumcolorapi.IridiumColorAPI;
import dev.norska.uar.bukkit.Metrics;
import dev.norska.uar.commands.UARCommands;
import dev.norska.uar.commands.UARTabComplete;
import dev.norska.uar.folia.universalScheduler.UniversalScheduler;
import dev.norska.uar.folia.universalScheduler.scheduling.schedulers.TaskScheduler;
import dev.norska.uar.listeners.JoinUpdateNotifier;
import dev.norska.uar.ndev.NorskaHandler;
import dev.norska.uar.ndev.NorskaUtils;
import dev.norska.uar.perms.UARPermHandler;
import dev.norska.uar.tasks.UARAfterRestart;
import dev.norska.uar.tasks.UARCountdown;
import dev.norska.uar.tasks.UARRestartCommands;
import dev.norska.uar.utils.WebhookSender;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UltimateAutoRestart
extends JavaPlugin {
    public static boolean catGoesMeow = false;
    private static UltimateAutoRestart instance;
    private final NorskaHandler nHandler = new NorskaHandler();
    private final NorskaUtils nUtils = new NorskaUtils();
    private final UARRestartCommands restartUtils = new UARRestartCommands(this);
    private final UARCountdown taskScheduler = new UARCountdown(this);
    private final UARAfterRestart afterRestartTask = new UARAfterRestart(this);
    private final UARPermHandler permHandler = new UARPermHandler();
    private final String proxyMessageChannel = "bukkit:uar";
    private int restartInSeconds;
    public String prefix;
    private static TaskScheduler scheduler;
    public Boolean usingFolia;

    public UltimateAutoRestart() {
        instance = this;
    }

    public static UltimateAutoRestart getInstance() {
        return instance;
    }

    public void onEnable() {
        this.usingFolia = this.isFolia();
        scheduler = UniversalScheduler.getScheduler((Plugin)this);
        this.checkUpdates();
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, this.getProxyMessageChannel());
        this.generateFiles();
        this.cache();
        this.getNHandler().getMessageFeedbackHandler().loadConsoleMessages();
        if (catGoesMeow) {
            this.prefix = this.getNUtils().isAbove1_16() != false ? IridiumColorAPI.process("&8[<GRADIENT:9483FF>UltimateAutoRestart+</GRADIENT:FB9AF2>&8]") : IridiumColorAPI.process("&8[&dUltimateAutoRestart+&8]");
            this.getNHandler().getMessageFeedbackHandler().sendConsoleMessage("STARTUP_PREMIUM", this.prefix, this.getDescription().getVersion());
        } else {
            this.prefix = this.getNUtils().isAbove1_16() != false ? IridiumColorAPI.process("&8[<GRADIENT:9483FF>UltimateAutoRestart</GRADIENT:FB9AF2>&8]") : IridiumColorAPI.process("&8[&dUltimateAutoRestart&8]");
            this.getNHandler().getMessageFeedbackHandler().sendConsoleMessage("STARTUP_FREE", this.prefix, this.getDescription().getVersion());
        }
        this.fetchAliases();
        this.checkForHooks();
        this.registerCommands();
        this.registerEvents();
        this.checkRestarts();
        this.startMetricsService();
        this.afterRestartTask.startCounter();
        this.getNHandler().getMessageFeedbackHandler().loadTextComponents(this);
        this.getPermHandler().loadPerms();
        if (this.getNHandler().getCacheHandler().getWebhookEnabled().booleanValue() && this.getNHandler().getCacheHandler().getWebhook_SERVER_BACK_UP_enabled().booleanValue()) {
            WebhookSender.sendWebhook(instance, "SERVER_BACK_UP");
        }
        if (this.usingFolia.booleanValue()) {
            this.getNHandler().getMessageFeedbackHandler().sendConsoleMessage("FOLIA", this.prefix);
        }
    }

    public void generateFiles() {
        this.getNHandler().getConfigurationHandler().generateFiles(instance);
    }

    private void checkUpdates() {
        this.getNHandler().getUpdateHandler().fetchVersionFromServer(instance);
        this.getNHandler().getUpdateHandler().checkForUpdates(instance);
    }

    private void checkForHooks() {
        this.getNHandler().getHooksHandler().checkForHooks(instance);
    }

    private void fetchAliases() {
        this.getNUtils().fetchAliases(instance);
    }

    public void cache() {
        this.getNHandler().getCacheHandler().cache(instance);
    }

    public void onDisable() {
        UltimateAutoRestart.getScheduler().cancelTasks((Plugin)this);
    }

    public void onUnload() {
        Bukkit.getServer().getScheduler().cancelTasks((Plugin)this);
    }

    public void checkRestarts() {
        int specificRebootTime = Integer.MAX_VALUE;
        if (!this.getNHandler().getConfigurationHandler().getConfigFile().getStringList("settings.restarts").isEmpty()) {
            for (String restartEntry : this.getNHandler().getConfigurationHandler().getConfigFile().getStringList("settings.restarts")) {
                int additionalDays;
                int entryMinutes;
                int entryHour;
                String[] fullFormatSplit = restartEntry.split(";");
                String day = fullFormatSplit[0];
                Boolean test = true;
                if (day.equalsIgnoreCase("daily")) {
                    entryHour = Integer.parseInt(fullFormatSplit[1]);
                    if (entryHour == 24) {
                        entryHour = 0;
                    }
                    entryMinutes = Integer.parseInt(fullFormatSplit[2]);
                    LocalDateTime restart = LocalDateTime.now().withHour(entryHour).withMinute(entryMinutes).withSecond(0);
                    LocalDateTime now = LocalDateTime.now();
                    now.withHour(now.getHour());
                    now.withMinute(now.getMinute());
                    now.withSecond(now.getSecond());
                    int secondsBetween = (int)ChronoUnit.SECONDS.between(now, restart);
                    if (secondsBetween <= 0) {
                        secondsBetween += 86400;
                    }
                    if (secondsBetween >= specificRebootTime || secondsBetween <= 0) continue;
                    specificRebootTime = secondsBetween;
                    continue;
                }
                entryHour = Integer.parseInt(fullFormatSplit[1]);
                if (entryHour == 24) {
                    entryHour = 0;
                }
                entryMinutes = Integer.parseInt(fullFormatSplit[2]);
                for (additionalDays = 0; !LocalDateTime.now().getDayOfWeek().plus(additionalDays).toString().equalsIgnoreCase(day) && additionalDays <= 7; ++additionalDays) {
                }
                if (additionalDays > 7) {
                    this.getNHandler().getMessageFeedbackHandler().sendConsoleMessage("ERROR_RESTART_ENTRY", this.prefix, restartEntry);
                    continue;
                }
                LocalDateTime restart = LocalDateTime.now().plusDays(additionalDays).withHour(entryHour).withMinute(entryMinutes).withSecond(0);
                LocalDateTime now = LocalDateTime.now();
                now.withHour(now.getHour());
                now.withMinute(now.getMinute());
                now.withSecond(now.getSecond());
                int secondsBetween = (int)ChronoUnit.SECONDS.between(now, restart);
                if (secondsBetween < 0) {
                    if (additionalDays == 0) {
                        additionalDays = 7;
                    }
                    secondsBetween = additionalDays * 86400 - secondsBetween * -1;
                }
                if (secondsBetween >= specificRebootTime || secondsBetween <= 0) continue;
                specificRebootTime = secondsBetween;
            }
            this.setRestartInSeconds(specificRebootTime);
            this.taskScheduler.scheduleRestart();
        } else if (this.taskScheduler.isRunning().booleanValue()) {
            this.taskScheduler.stopRestart();
        }
    }

    private void startMetricsService() {
        Metrics metrics = new Metrics(this, 4993);
    }

    private void registerCommands() {
        Objects.requireNonNull(this.getCommand("ultimateautorestart")).setExecutor((CommandExecutor)new UARCommands(this));
        Objects.requireNonNull(this.getCommand("ultimateautorestart")).setTabCompleter((TabCompleter)new UARTabComplete(this));
    }

    private void registerEvents() {
        Bukkit.getPluginManager().registerEvents((Listener)new JoinUpdateNotifier(this), (Plugin)this);
    }

    private boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public NorskaHandler getNHandler() {
        return this.nHandler;
    }

    public NorskaUtils getNUtils() {
        return this.nUtils;
    }

    public UARRestartCommands getRestartUtils() {
        return this.restartUtils;
    }

    public UARCountdown getTaskScheduler() {
        return this.taskScheduler;
    }

    public UARAfterRestart getAfterRestartTask() {
        return this.afterRestartTask;
    }

    public UARPermHandler getPermHandler() {
        return this.permHandler;
    }

    public String getProxyMessageChannel() {
        return this.proxyMessageChannel;
    }

    public int getRestartInSeconds() {
        return this.restartInSeconds;
    }

    public void setRestartInSeconds(int restartInSeconds) {
        this.restartInSeconds = restartInSeconds;
    }

    public static TaskScheduler getScheduler() {
        return scheduler;
    }
}

