/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.uar;

import dev.norska.uar.base.XBase;
import dev.norska.uar.base.XRegistry;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public enum XItemFlag implements XBase<XItemFlag, ItemFlag>
{
    HIDE_ADDITIONAL_TOOLTIP("HIDE_POTION_EFFECTS"),
    HIDE_ARMOR_TRIM(new String[0]),
    HIDE_ATTRIBUTES(new String[0]),
    HIDE_DESTROYS(new String[0]),
    HIDE_DYE(new String[0]),
    HIDE_ENCHANTS(new String[0]),
    HIDE_PLACED_ON(new String[0]),
    HIDE_STORED_ENCHANTMENTS("HIDE_STORED_ENCHANTS"),
    HIDE_UNBREAKABLE(new String[0]),
    HIDE_CUSTOM_DATA(new String[0]),
    HIDE_MAX_STACK_SIZE(new String[0]),
    HIDE_MAX_DAMAGE(new String[0]),
    HIDE_DAMAGE(new String[0]),
    HIDE_CUSTOM_NAME(new String[0]),
    HIDE_ITEM_NAME(new String[0]),
    HIDE_ITEM_MODEL(new String[0]),
    HIDE_LORE(new String[0]),
    HIDE_RARITY(new String[0]),
    HIDE_ENCHANTMENTS(new String[0]),
    HIDE_CAN_PLACE_ON(new String[0]),
    HIDE_CAN_BREAK(new String[0]),
    HIDE_ATTRIBUTE_MODIFIERS(new String[0]),
    HIDE_CUSTOM_MODEL_DATA(new String[0]),
    HIDE_TOOLTIP_DISPLAY(new String[0]),
    HIDE_REPAIR_COST(new String[0]),
    HIDE_CREATIVE_SLOT_LOCK(new String[0]),
    HIDE_ENCHANTMENT_GLINT_OVERRIDE(new String[0]),
    HIDE_INTANGIBLE_PROJECTILE(new String[0]),
    HIDE_FOOD(new String[0]),
    HIDE_CONSUMABLE(new String[0]),
    HIDE_USE_REMAINDER(new String[0]),
    HIDE_USE_COOLDOWN(new String[0]),
    HIDE_DAMAGE_RESISTANT(new String[0]),
    HIDE_TOOL(new String[0]),
    HIDE_WEAPON(new String[0]),
    HIDE_ENCHANTABLE(new String[0]),
    HIDE_EQUIPPABLE(new String[0]),
    HIDE_REPAIRABLE(new String[0]),
    HIDE_GLIDER(new String[0]),
    HIDE_TOOLTIP_STYLE(new String[0]),
    HIDE_DEATH_PROTECTION(new String[0]),
    HIDE_BLOCKS_ATTACKS(new String[0]),
    HIDE_DYED_COLOR(new String[0]),
    HIDE_MAP_COLOR(new String[0]),
    HIDE_MAP_ID(new String[0]),
    HIDE_MAP_DECORATIONS(new String[0]),
    HIDE_MAP_POST_PROCESSING(new String[0]),
    HIDE_CHARGED_PROJECTILES(new String[0]),
    HIDE_BUNDLE_CONTENTS(new String[0]),
    HIDE_POTION_CONTENTS(new String[0]),
    HIDE_POTION_DURATION_SCALE(new String[0]),
    HIDE_SUSPICIOUS_STEW_EFFECTS(new String[0]),
    HIDE_WRITABLE_BOOK_CONTENT(new String[0]),
    HIDE_WRITTEN_BOOK_CONTENT(new String[0]),
    HIDE_TRIM(new String[0]),
    HIDE_DEBUG_STICK_STATE(new String[0]),
    HIDE_ENTITY_DATA(new String[0]),
    HIDE_BUCKET_ENTITY_DATA(new String[0]),
    HIDE_BLOCK_ENTITY_DATA(new String[0]),
    HIDE_INSTRUMENT(new String[0]),
    HIDE_PROVIDES_TRIM_MATERIAL(new String[0]),
    HIDE_OMINOUS_BOTTLE_AMPLIFIER(new String[0]),
    HIDE_JUKEBOX_PLAYABLE(new String[0]),
    HIDE_PROVIDES_BANNER_PATTERNS(new String[0]),
    HIDE_RECIPES(new String[0]),
    HIDE_LODESTONE_TRACKER(new String[0]),
    HIDE_FIREWORK_EXPLOSION(new String[0]),
    HIDE_FIREWORKS(new String[0]),
    HIDE_PROFILE(new String[0]),
    HIDE_NOTE_BLOCK_SOUND(new String[0]),
    HIDE_BANNER_PATTERNS(new String[0]),
    HIDE_BASE_COLOR(new String[0]),
    HIDE_POT_DECORATIONS(new String[0]),
    HIDE_CONTAINER(new String[0]),
    HIDE_BLOCK_STATE(new String[0]),
    HIDE_BEES(new String[0]),
    HIDE_LOCK(new String[0]),
    HIDE_CONTAINER_LOOT(new String[0]),
    HIDE_BREAK_SOUND(new String[0]),
    HIDE_VILLAGER_VARIANT(new String[0]),
    HIDE_WOLF_VARIANT(new String[0]),
    HIDE_WOLF_SOUND_VARIANT(new String[0]),
    HIDE_WOLF_COLLAR(new String[0]),
    HIDE_FOX_VARIANT(new String[0]),
    HIDE_SALMON_SIZE(new String[0]),
    HIDE_PARROT_VARIANT(new String[0]),
    HIDE_TROPICAL_FISH_PATTERN(new String[0]),
    HIDE_TROPICAL_FISH_BASE_COLOR(new String[0]),
    HIDE_TROPICAL_FISH_PATTERN_COLOR(new String[0]),
    HIDE_MOOSHROOM_VARIANT(new String[0]),
    HIDE_RABBIT_VARIANT(new String[0]),
    HIDE_PIG_VARIANT(new String[0]),
    HIDE_COW_VARIANT(new String[0]),
    HIDE_CHICKEN_VARIANT(new String[0]),
    HIDE_FROG_VARIANT(new String[0]),
    HIDE_HORSE_VARIANT(new String[0]),
    HIDE_PAINTING_VARIANT(new String[0]),
    HIDE_LLAMA_VARIANT(new String[0]),
    HIDE_AXOLOTL_VARIANT(new String[0]),
    HIDE_CAT_VARIANT(new String[0]),
    HIDE_CAT_COLLAR(new String[0]),
    HIDE_SHEEP_COLOR(new String[0]),
    HIDE_SHULKER_COLOR(new String[0]);

    public static final XRegistry<XItemFlag, ItemFlag> REGISTRY;
    private static final ItemFlag[] NONE_DECORATION_FLAGS;
    private final ItemFlag itemFlag;

    private XItemFlag(String ... names) {
        this.itemFlag = (ItemFlag)Data.REGISTRY.stdEnum(this, names);
    }

    public static XItemFlag of(ItemFlag itemFlag) {
        return REGISTRY.getByBukkitForm(itemFlag);
    }

    public static Optional<XItemFlag> of(String itemFlag) {
        return REGISTRY.getByName(itemFlag);
    }

    @NotNull
    public static @Unmodifiable Collection<XItemFlag> getValues() {
        return REGISTRY.getValues();
    }

    @Override
    public String[] getNames() {
        return new String[]{this.name()};
    }

    @Override
    @Nullable
    public ItemFlag get() {
        return this.itemFlag;
    }

    public void set(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{this.itemFlag});
        item.setItemMeta(meta);
    }

    public void set(ItemMeta meta) {
        meta.addItemFlags(new ItemFlag[]{this.itemFlag});
    }

    public void removeFrom(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        this.removeFrom(meta);
        item.setItemMeta(meta);
    }

    public void removeFrom(ItemMeta meta) {
        meta.removeItemFlags(new ItemFlag[]{this.itemFlag});
    }

    public Set<XItemFlag> getFlags(ItemStack item) {
        return this.getFlags(item.getItemMeta());
    }

    public Set<XItemFlag> getFlags(ItemMeta meta) {
        return meta.getItemFlags().stream().map(XItemFlag::of).collect(Collectors.toSet());
    }

    public boolean has(ItemStack item) {
        return this.has(item.getItemMeta());
    }

    public boolean has(ItemMeta meta) {
        return meta.getItemFlags().contains(this.itemFlag);
    }

    @Deprecated
    public static void hideEverything(ItemMeta meta) {
        XItemFlag.decorationOnly(meta);
    }

    public static void decorationOnly(ItemMeta meta) {
        meta.addItemFlags(NONE_DECORATION_FLAGS);
    }

    static {
        REGISTRY = Data.REGISTRY;
        NONE_DECORATION_FLAGS = (ItemFlag[])Arrays.stream(XItemFlag.values()).filter(x -> x != HIDE_LORE && x != HIDE_ITEM_NAME && x != HIDE_CUSTOM_NAME).filter(XBase::isSupported).map(XItemFlag::get).toArray(ItemFlag[]::new);
        REGISTRY.discardMetadata();
    }

    private static final class Data {
        private static final XRegistry<XItemFlag, ItemFlag> REGISTRY = new XRegistry<XItemFlag, ItemFlag>(ItemFlag.class, XItemFlag.class, XItemFlag[]::new);

        private Data() {
        }
    }
}

