/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.uar.ndev.handlers;

import dev.norska.uar.UltimateAutoRestart;
import dev.norska.uar.api.UARAPI;
import dev.norska.uar.config.CommentedConfiguration;
import dev.norska.uar.ndev.objects.MessageObject;
import dev.norska.uar.ndev.objects.SoundObject;
import dev.norska.uar.utils.NDebug;
import java.io.File;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;

public class CacheHandler {
    private final HashMap<String, MessageObject> messageMap = new HashMap();
    private final HashMap<String, SoundObject> soundMap = new HashMap();
    private String editablePrefix;
    private String days;
    private String day;
    private String hours;
    private String hour;
    private String minutes;
    private String minute;
    private String seconds;
    private String second;
    private String splitter;
    private String today;
    private Boolean webhookEnabled;
    private Boolean webhook_SERVER_RESTART_enabled;
    private Boolean webhook_SERVER_BACK_UP_enabled;
    private Boolean webhook_SERVER_FORCED_RESTART_enabled;
    private Boolean delayRestart;
    private Boolean checkUpdate;
    private String webhookTimestampPlaceholder;
    private String defaultReason;
    private int delayRestartBySeconds;
    private int delayRestartMinimumPlayers;
    private int delayRestartCheckAtSeconds;
    private final HashMap<Integer, String> timedCommands = new HashMap();
    private final HashMap<Integer, String> timedBungeeCommands = new HashMap();
    private final HashMap<Integer, String> afterRebootTimedCommands = new HashMap();
    private final HashMap<Integer, String> afterRebootTimedBungeeCommands = new HashMap();
    private final HashMap<Integer, String> delayedBungeeCommands = new HashMap();
    private List<String> intervalSounds;
    private List<String> intervalMessages;
    private final List<String> normalProxyCommands = new ArrayList<String>();
    private final List<String> normalBukkitCommands = new ArrayList<String>();
    private Boolean stripConsole;
    private Boolean notifyForUpdates;

    public void cache(UltimateAutoRestart main) {
        CommentedConfiguration configFile = main.getNHandler().getConfigurationHandler().getConfigFile();
        CommentedConfiguration msgFile = main.getNHandler().getConfigurationHandler().getMsgFile();
        CommentedConfiguration soundFile = main.getNHandler().getConfigurationHandler().getSoundsFile();
        CommentedConfiguration webhookFile = main.getNHandler().getConfigurationHandler().getWebhookFile();
        this.cacheMessageFeedback(msgFile);
        this.cacheSoundFeedback(soundFile);
        this.editablePrefix = msgFile.getString("messages.prefix");
        File debugEnabled = new File(main.getDataFolder(), "ndev.debug");
        NDebug.setEnabled(debugEnabled.exists());
        this.notifyForUpdates = main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("updates.notifications");
        if (UltimateAutoRestart.catGoesMeow) {
            this.webhookEnabled = main.getNHandler().getConfigurationHandler().getWebhookPremium().getBoolean("webhook.enabled");
            this.webhook_SERVER_RESTART_enabled = main.getNHandler().getConfigurationHandler().getWebhookPremium().getBoolean("messages.SERVER_RESTARTING.enabled");
            this.webhook_SERVER_BACK_UP_enabled = main.getNHandler().getConfigurationHandler().getWebhookPremium().getBoolean("messages.SERVER_BACK_UP.enabled");
            this.webhook_SERVER_FORCED_RESTART_enabled = main.getNHandler().getConfigurationHandler().getWebhookPremium().getBoolean("messages.SERVER_FORCED_RESTART.enabled");
            this.webhookTimestampPlaceholder = main.getNHandler().getConfigurationHandler().getWebhookPremium().getString("format.timestamp");
        } else {
            this.webhookEnabled = webhookFile.getBoolean("webhook.enabled");
            this.webhook_SERVER_RESTART_enabled = webhookFile.getBoolean("messages.SERVER_RESTARTING.enabled");
            this.webhook_SERVER_BACK_UP_enabled = webhookFile.getBoolean("messages.SERVER_BACK_UP.enabled");
            this.webhook_SERVER_FORCED_RESTART_enabled = webhookFile.getBoolean("messages.SERVER_FORCED_RESTART.enabled");
            this.webhookTimestampPlaceholder = main.getNHandler().getConfigurationHandler().getWebhookFile().getString("format.timestamp");
        }
        this.stripConsole = msgFile.getBoolean("stripConsole");
        this.days = configFile.getString("format.days");
        this.day = configFile.getString("format.day");
        this.hours = configFile.getString("format.hours");
        this.hour = configFile.getString("format.hour");
        this.minutes = configFile.getString("format.minutes");
        this.minute = configFile.getString("format.minute");
        this.seconds = configFile.getString("format.seconds");
        this.second = configFile.getString("format.second");
        this.splitter = configFile.getString("format.splitter");
        this.today = LocalDateTime.now().getDayOfWeek().toString();
        this.delayRestart = configFile.getBoolean("delayRestart.enabled");
        this.delayRestartBySeconds = configFile.getInt("delayRestart.delayBySeconds");
        this.delayRestartMinimumPlayers = configFile.getInt("delayRestart.minimumPlayers");
        this.delayRestartCheckAtSeconds = configFile.getInt("delayRestart.checkSecondsBeforeRestart");
        this.intervalMessages = configFile.getStringList("settings.messageAtIntervals");
        this.intervalSounds = configFile.getStringList("settings.soundAtIntervals");
        this.editablePrefix = msgFile.getString("messages.prefix");
        this.defaultReason = msgFile.getString("defaultReason");
        this.checkTimedCommands(configFile);
        this.checkTimedBungeeCommands(configFile);
        this.checkAfterRebootTimedCommands(configFile);
        this.checkAfterRebootTimedBungeeCommands(configFile);
        this.checkDelayedBungeeCommands(configFile);
        this.checkNormalProxyCommands(configFile);
        this.checkNormalBukkitCommands(configFile);
        this.checkUpdate = configFile.getBoolean("updates.notifications");
        String version = Bukkit.getVersion();
        UARAPI.setForceRestartReason(this.defaultReason);
    }

    private void cacheMessageFeedback(CommentedConfiguration msgFile) {
        if (!this.messageMap.isEmpty()) {
            this.messageMap.clear();
        }
        for (String section : Objects.requireNonNull(msgFile.getConfigurationSection("messages")).getKeys(false)) {
            MessageObject message = new MessageObject();
            this.messageMap.put(section, message);
            message = this.messageMap.get(section);
            message.setChatMessageEnabled(msgFile.getBoolean("messages." + section + ".chatMessage.enabled"));
            message.setChatMessageCentered(msgFile.getBoolean("messages." + section + ".chatMessage.centered"));
            message.setChatMessageContent(msgFile.getStringList("messages." + section + ".chatMessage.content"));
            message.setActionbarEnabled(msgFile.getBoolean("messages." + section + ".actionbar.enabled"));
            message.setActionbarContent(msgFile.getString("messages." + section + ".actionbar.content"));
            message.setActionbarDuration(msgFile.getInt("messages." + section + ".actionbar.duration"));
            message.setTitleEnabled(msgFile.getBoolean("messages." + section + ".titles.enabled"));
            message.setTitleContent(msgFile.getString("messages." + section + ".titles.titleContent"));
            message.setSubtitleContent(msgFile.getString("messages." + section + ".titles.subtitleContent"));
        }
    }

    private void cacheSoundFeedback(CommentedConfiguration soundFile) {
        if (!this.soundMap.isEmpty()) {
            this.soundMap.clear();
        }
        for (String section : Objects.requireNonNull(soundFile.getConfigurationSection("sounds")).getKeys(false)) {
            SoundObject sound = new SoundObject();
            this.soundMap.put(section, sound);
            sound = this.soundMap.get(section);
            sound.setEnabled(soundFile.getBoolean("sounds." + section + ".enabled"));
            sound.setName(soundFile.getString("sounds." + section + ".sound"));
            sound.setVolume((float)soundFile.getDouble("sounds." + section + ".volume"));
            sound.setPitch((float)soundFile.getDouble("sounds." + section + ".pitch"));
        }
    }

    private void checkAfterRebootTimedCommands(CommentedConfiguration configFile) {
        this.afterRebootTimedCommands.clear();
        for (String command : configFile.getStringList("settings.commandsAfterReboot")) {
            if (!command.startsWith("[time:")) continue;
            String[] splitCommand = command.split("\\s+");
            int number = Integer.parseInt(splitCommand[0].replaceAll("\\D+", ""));
            String extractedCommand = command.replace("[time:" + number + "] ", "");
            this.afterRebootTimedCommands.put(number, extractedCommand);
        }
    }

    private void checkAfterRebootTimedBungeeCommands(CommentedConfiguration configFile) {
        this.afterRebootTimedBungeeCommands.clear();
        for (String command : configFile.getStringList("settings.commandsAfterReboot")) {
            if (!command.startsWith("[proxy:")) continue;
            String[] splitCommand = command.split("\\s+");
            int number = Integer.parseInt(splitCommand[0].replaceAll("\\D+", ""));
            String extractedCommand = command.replace("[proxy:" + number + "] ", "");
            this.afterRebootTimedBungeeCommands.put(number, extractedCommand);
        }
    }

    private void checkNormalProxyCommands(CommentedConfiguration configFile) {
        this.normalProxyCommands.clear();
        for (String command : configFile.getStringList("settings.restartCommands")) {
            if (!command.startsWith("[proxy]")) continue;
            String extractedCommand = command.replace("[proxy]", "");
            this.normalProxyCommands.add(extractedCommand);
        }
    }

    private void checkNormalBukkitCommands(CommentedConfiguration configFile) {
        this.normalBukkitCommands.clear();
        for (String command : configFile.getStringList("settings.restartCommands")) {
            if (command.startsWith("[proxy]") || command.startsWith("[time:") || command.startsWith("[proxy:") || command.startsWith("[proxydelay:")) continue;
            this.normalBukkitCommands.add(command);
        }
    }

    private void checkTimedCommands(CommentedConfiguration configFile) {
        this.timedCommands.clear();
        for (String command : configFile.getStringList("settings.restartCommands")) {
            if (!command.startsWith("[time:")) continue;
            String[] splitCommand = command.split("\\s+");
            int number = Integer.parseInt(splitCommand[0].replaceAll("\\D+", ""));
            String extractedCommand = command.replace("[time:" + number + "] ", "");
            this.timedCommands.put(number, extractedCommand);
        }
    }

    private void checkTimedBungeeCommands(CommentedConfiguration configFile) {
        this.timedBungeeCommands.clear();
        for (String command : configFile.getStringList("settings.restartCommands")) {
            if (!command.startsWith("[proxy:")) continue;
            String[] splitCommand = command.split("\\s+");
            int number = Integer.parseInt(splitCommand[0].replaceAll("\\D+", ""));
            String extractedCommand = command.replace("[proxy:" + number + "] ", "");
            this.timedBungeeCommands.put(number, extractedCommand);
        }
    }

    private void checkDelayedBungeeCommands(CommentedConfiguration configFile) {
        this.delayedBungeeCommands.clear();
        for (String command : configFile.getStringList("settings.restartCommands")) {
            if (!command.startsWith("[proxydelay:")) continue;
            String[] splitCommand = command.split("\\s+");
            int number = Integer.parseInt(splitCommand[0].replaceAll("\\D+", ""));
            String extractedCommand = command.replace("[proxydelay:" + number + "] ", "");
            this.delayedBungeeCommands.put(number, extractedCommand);
        }
    }

    public HashMap<String, MessageObject> getMessageMap() {
        return this.messageMap;
    }

    public HashMap<String, SoundObject> getSoundMap() {
        return this.soundMap;
    }

    public String getEditablePrefix() {
        return this.editablePrefix;
    }

    public String getDays() {
        return this.days;
    }

    public String getDay() {
        return this.day;
    }

    public String getHours() {
        return this.hours;
    }

    public String getHour() {
        return this.hour;
    }

    public String getMinutes() {
        return this.minutes;
    }

    public String getMinute() {
        return this.minute;
    }

    public String getSeconds() {
        return this.seconds;
    }

    public String getSecond() {
        return this.second;
    }

    public String getSplitter() {
        return this.splitter;
    }

    public String getToday() {
        return this.today;
    }

    public Boolean getWebhookEnabled() {
        return this.webhookEnabled;
    }

    public Boolean getWebhook_SERVER_RESTART_enabled() {
        return this.webhook_SERVER_RESTART_enabled;
    }

    public Boolean getWebhook_SERVER_BACK_UP_enabled() {
        return this.webhook_SERVER_BACK_UP_enabled;
    }

    public Boolean getWebhook_SERVER_FORCED_RESTART_enabled() {
        return this.webhook_SERVER_FORCED_RESTART_enabled;
    }

    public Boolean getDelayRestart() {
        return this.delayRestart;
    }

    public Boolean getCheckUpdate() {
        return this.checkUpdate;
    }

    public String getWebhookTimestampPlaceholder() {
        return this.webhookTimestampPlaceholder;
    }

    public String getDefaultReason() {
        return this.defaultReason;
    }

    public int getDelayRestartBySeconds() {
        return this.delayRestartBySeconds;
    }

    public int getDelayRestartMinimumPlayers() {
        return this.delayRestartMinimumPlayers;
    }

    public int getDelayRestartCheckAtSeconds() {
        return this.delayRestartCheckAtSeconds;
    }

    public HashMap<Integer, String> getTimedCommands() {
        return this.timedCommands;
    }

    public HashMap<Integer, String> getTimedBungeeCommands() {
        return this.timedBungeeCommands;
    }

    public HashMap<Integer, String> getAfterRebootTimedCommands() {
        return this.afterRebootTimedCommands;
    }

    public HashMap<Integer, String> getAfterRebootTimedBungeeCommands() {
        return this.afterRebootTimedBungeeCommands;
    }

    public HashMap<Integer, String> getDelayedBungeeCommands() {
        return this.delayedBungeeCommands;
    }

    public List<String> getIntervalSounds() {
        return this.intervalSounds;
    }

    public List<String> getIntervalMessages() {
        return this.intervalMessages;
    }

    public List<String> getNormalProxyCommands() {
        return this.normalProxyCommands;
    }

    public List<String> getNormalBukkitCommands() {
        return this.normalBukkitCommands;
    }

    public Boolean getStripConsole() {
        return this.stripConsole;
    }

    public Boolean getNotifyForUpdates() {
        return this.notifyForUpdates;
    }
}

