/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.uar.commands;

import dev.norska.uar.UltimateAutoRestart;
import dev.norska.uar.commands.admin.DebugCommand;
import dev.norska.uar.commands.admin.DebugInfoCommand;
import dev.norska.uar.commands.admin.DelayCommand;
import dev.norska.uar.commands.admin.HelpCommand;
import dev.norska.uar.commands.admin.NowCommand;
import dev.norska.uar.commands.admin.ReloadCommand;
import dev.norska.uar.commands.admin.StopCommand;
import dev.norska.uar.commands.admin.TimeCommand;
import dev.norska.uar.commands.admin.VersionCommand;
import dev.norska.uar.perms.UARPerm;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class UARCommands
implements CommandExecutor {
    private final UltimateAutoRestart main;
    private final HelpCommand helpCommand = new HelpCommand();
    private final DebugInfoCommand licenseCommand = new DebugInfoCommand();
    private final ReloadCommand reloadCommand = new ReloadCommand();
    private final VersionCommand versionCommand = new VersionCommand();
    private final NowCommand nowCommand = new NowCommand();
    private final DelayCommand delayCommand = new DelayCommand();
    private final TimeCommand timeCommand = new TimeCommand();
    private final StopCommand stopCommand = new StopCommand();
    private final DebugCommand debugCommand = new DebugCommand();

    public UARCommands(UltimateAutoRestart main) {
        this.main = main;
    }

    public boolean onCommand(@NotNull CommandSender cms, Command cmd, @NotNull String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("ultimateautorestart")) {
            if (!cms.hasPermission(this.main.getPermHandler().getPermMap().get((Object)UARPerm.ADMIN))) {
                this.timeCommand.execute(this.main, cms);
                return false;
            }
            if (args.length == 0) {
                this.helpCommand.execute(this.main, cms);
                return false;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                this.reloadCommand.execute(this.main, cms);
                return false;
            }
            if (args[0].equalsIgnoreCase("version")) {
                this.versionCommand.execute(this.main, cms);
                return false;
            }
            if (args[0].equalsIgnoreCase("help")) {
                this.helpCommand.execute(this.main, cms);
                return false;
            }
            if (args[0].equalsIgnoreCase("debuginfo")) {
                if (UltimateAutoRestart.catGoesMeow) {
                    this.licenseCommand.execute(this.main, cms);
                }
                return false;
            }
            if (args[0].equalsIgnoreCase("now")) {
                this.nowCommand.execute(this.main, cms, args);
                return false;
            }
            if (args[0].equalsIgnoreCase("delay")) {
                this.delayCommand.execute(this.main, cms, args);
                return false;
            }
            if (args[0].equalsIgnoreCase("time")) {
                this.timeCommand.execute(this.main, cms);
                return false;
            }
            if (args[0].equalsIgnoreCase("stop")) {
                this.stopCommand.execute(this.main, cms);
                return false;
            }
            if (args[0].equalsIgnoreCase("debug")) {
                this.debugCommand.execute(this.main, cms, args);
                return false;
            }
            this.helpCommand.execute(this.main, cms);
        }
        return false;
    }
}

