/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.uar.tasks;

import dev.norska.niridiumcolorapi.IridiumColorAPI;
import dev.norska.uar.UltimateAutoRestart;
import dev.norska.uar.api.UARAPI;
import dev.norska.uar.api.UARAutoDelayEvent;
import dev.norska.uar.api.UARRestartEvent;
import dev.norska.uar.perms.UARPerm;
import dev.norska.uar.utils.InnerAPI;
import dev.norska.uar.utils.WebhookSender;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class UARCountdown {
    private final UltimateAutoRestart main;
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public UARCountdown(UltimateAutoRestart main) {
        this.main = main;
    }

    public void stopRestart() {
        this.scheduler.shutdownNow();
        this.scheduler = null;
    }

    public Boolean isRunning() {
        return this.scheduler != null;
    }

    public void scheduleRestart() {
        if (!this.isRunning().booleanValue()) {
            this.scheduler = Executors.newScheduledThreadPool(1);
        }
        Runnable restartRunnable = () -> {
            String commandWithoutDay;
            String specificDay;
            String commandToExecute;
            UARAPI.setInterval(this.main, UARAPI.getInterval(this.main) - 1);
            int interval = UARAPI.getInterval(this.main);
            if (this.main.getNHandler().getCacheHandler().getDelayRestart().booleanValue() && interval == this.main.getNHandler().getCacheHandler().getDelayRestartCheckAtSeconds() && Bukkit.getOnlinePlayers().size() >= this.main.getNHandler().getCacheHandler().getDelayRestartMinimumPlayers()) {
                UltimateAutoRestart.getScheduler().runTaskLater(() -> {
                    try {
                        UARAutoDelayEvent event1 = new UARAutoDelayEvent(interval + this.main.getNHandler().getCacheHandler().getDelayRestartBySeconds());
                        Bukkit.getPluginManager().callEvent((Event)event1);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }, 1L);
                UARAPI.setInterval(this.main, interval + this.main.getNHandler().getCacheHandler().getDelayRestartBySeconds());
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (p.hasPermission(this.main.getPermHandler().getPermMap().get((Object)UARPerm.STAFF_NOTIFY_DELAY))) {
                        this.main.getNHandler().getMessageFeedbackHandler().sendMessage(this.main, (CommandSender)p, "EVENT_RESTART_DELAY_STAFF", this.main.getNUtils().convertSecondsToFormattedString(this.main, this.main.getNHandler().getCacheHandler().getDelayRestartBySeconds()));
                        this.main.getNHandler().getSoundFeedbackHandler().playSound(this.main, (CommandSender)p, "EVENT_RESTART_DELAY_STAFF");
                        continue;
                    }
                    this.main.getNHandler().getMessageFeedbackHandler().sendMessage(this.main, (CommandSender)p, "EVENT_RESTART_DELAY_GLOBAL", this.main.getNUtils().convertSecondsToFormattedString(this.main, this.main.getNHandler().getCacheHandler().getDelayRestartBySeconds()));
                    this.main.getNHandler().getSoundFeedbackHandler().playSound(this.main, (CommandSender)p, "EVENT_RESTART_DELAY_GLOBAL");
                }
            }
            if (this.main.getNHandler().getCacheHandler().getIntervalMessages().contains(Integer.toString(interval))) {
                if (this.main.getNHandler().getConfigurationHandler().getMsgFile().getBoolean("messages.EVENT_INTERVAL_CONSOLE.chatMessage.enabled")) {
                    for (String line : this.main.getNHandler().getConfigurationHandler().getMsgFile().getStringList("messages.EVENT_INTERVAL_CONSOLE.chatMessage.content")) {
                        Bukkit.getConsoleSender().sendMessage(IridiumColorAPI.process(line).replace("{PREFIX}", this.main.prefix).replace("{0}", this.main.getNUtils().convertSecondsToFormattedString(this.main, interval)).replace("{1}", UARAPI.getForceRestartReason()));
                    }
                }
                for (Player p : Bukkit.getOnlinePlayers()) {
                    this.main.getNHandler().getMessageFeedbackHandler().sendMessage(this.main, (CommandSender)p, "EVENT_INTERVAL_GLOBAL", this.main.getNUtils().convertSecondsToFormattedString(this.main, interval), UARAPI.getForceRestartReason());
                }
            }
            if (this.main.getNHandler().getCacheHandler().getIntervalSounds().contains(Integer.toString(interval))) {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    this.main.getNHandler().getSoundFeedbackHandler().playSound(this.main, (CommandSender)p, "EVENT_INTERVAL_GLOBAL");
                }
            }
            if (this.main.getNHandler().getCacheHandler().getTimedCommands().containsKey(interval)) {
                commandToExecute = this.main.getNHandler().getCacheHandler().getTimedCommands().get(interval);
                if (InnerAPI.isDaySpecific(commandToExecute).booleanValue()) {
                    specificDay = InnerAPI.getDaySpecificDay(commandToExecute);
                    if (specificDay.equalsIgnoreCase(this.main.getNHandler().getCacheHandler().getToday())) {
                        commandWithoutDay = InnerAPI.stripDay(commandToExecute, specificDay);
                        UltimateAutoRestart.getScheduler().runTaskLater(() -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), commandWithoutDay), 1L);
                    }
                } else {
                    UltimateAutoRestart.getScheduler().runTaskLater(() -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), commandToExecute), 1L);
                }
            }
            if (this.main.getNHandler().getCacheHandler().getTimedBungeeCommands().containsKey(interval)) {
                commandToExecute = this.main.getNHandler().getCacheHandler().getTimedBungeeCommands().get(interval);
                if (InnerAPI.isDaySpecific(commandToExecute).booleanValue()) {
                    specificDay = InnerAPI.getDaySpecificDay(commandToExecute);
                    if (specificDay.equalsIgnoreCase(this.main.getNHandler().getCacheHandler().getToday())) {
                        commandWithoutDay = InnerAPI.stripDay(commandToExecute, specificDay);
                        UltimateAutoRestart.getScheduler().runTaskLater(() -> {
                            boolean executed = false;
                            ByteArrayOutputStream b = new ByteArrayOutputStream();
                            DataOutputStream out = new DataOutputStream(b);
                            try {
                                out.writeUTF(commandWithoutDay);
                                for (Player player : this.main.getServer().getOnlinePlayers()) {
                                    if (executed) continue;
                                    player.sendPluginMessage((Plugin)this.main, this.main.getProxyMessageChannel(), b.toByteArray());
                                    executed = true;
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }, 1L);
                    }
                } else {
                    UltimateAutoRestart.getScheduler().runTaskLater(() -> {
                        boolean executed = false;
                        ByteArrayOutputStream b = new ByteArrayOutputStream();
                        DataOutputStream out = new DataOutputStream(b);
                        try {
                            out.writeUTF(commandToExecute);
                            for (Player player : this.main.getServer().getOnlinePlayers()) {
                                if (executed) continue;
                                player.sendPluginMessage((Plugin)this.main, this.main.getProxyMessageChannel(), b.toByteArray());
                                executed = true;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }, 1L);
                }
            }
            if (interval == 1) {
                UltimateAutoRestart.getScheduler().runTaskLater(() -> {
                    try {
                        UARRestartEvent event1 = new UARRestartEvent();
                        Bukkit.getPluginManager().callEvent((Event)event1);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }, 1L);
            }
            if (interval == 0) {
                if (this.main.getNHandler().getCacheHandler().getWebhookEnabled().booleanValue() && this.main.getNHandler().getCacheHandler().getWebhook_SERVER_RESTART_enabled().booleanValue()) {
                    WebhookSender.sendWebhook(this.main, "SERVER_RESTARTING");
                }
                for (Player p : Bukkit.getOnlinePlayers()) {
                    this.main.getNHandler().getMessageFeedbackHandler().sendMessage(this.main, (CommandSender)p, "EVENT_RESTART_GLOBAL", "");
                    this.main.getNHandler().getSoundFeedbackHandler().playSound(this.main, (CommandSender)p, "EVENT_RESTART_GLOBAL");
                }
                this.main.getRestartUtils().runRestartCommands();
                this.scheduler.shutdownNow();
            }
        };
        this.scheduler.scheduleAtFixedRate(restartRunnable, 1L, 1L, TimeUnit.SECONDS);
    }
}

