/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.uar.utils;

import dev.norska.uar.UltimateAutoRestart;
import dev.norska.uar.api.UARAPI;
import dev.norska.uar.ndev.NorskaUtils;
import dev.norska.uar.ndev.handlers.CacheHandler;
import dev.norska.uar.ndev.handlers.ConfigHandler;
import dev.norska.uar.utils.DiscordWebhook;
import java.awt.Color;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

public class WebhookSender {
    public static void sendWebhook(UltimateAutoRestart main, String type) {
        UltimateAutoRestart.getScheduler().runTaskLater(() -> {
            if (UltimateAutoRestart.catGoesMeow) {
                String contentMessage;
                ConfigHandler configHandler = main.getNHandler().getConfigurationHandler();
                CacheHandler cacheHandler = main.getNHandler().getCacheHandler();
                NorskaUtils utils = main.getNUtils();
                SimpleDateFormat formatter = new SimpleDateFormat(cacheHandler.getWebhookTimestampPlaceholder());
                String timestamp = formatter.format(new Date());
                Integer secondsToRestart = UARAPI.getInterval(main);
                String secondsString = Integer.toString(secondsToRestart);
                String formatted = utils.convertSecondsToFormattedString(main, secondsToRestart);
                String reason = UARAPI.getForceRestartReason();
                DiscordWebhook webhook = new DiscordWebhook(configHandler.getWebhookPremium().getString("webhook.url"));
                webhook.setAvatarUrl(configHandler.getWebhookPremium().getString("messages." + type + ".settings.avatarURL"));
                webhook.setUsername(configHandler.getWebhookPremium().getString("messages." + type + ".settings.username"));
                webhook.setTts(configHandler.getWebhookPremium().getBoolean("messages." + type + ".settings.textToSpeech"));
                if (configHandler.getWebhookPremium().getBoolean("messages." + type + ".settings.content.enabled") && !(contentMessage = configHandler.getWebhookPremium().getString("messages." + type + ".settings.content.message", "")).isEmpty()) {
                    webhook.setContent(WebhookSender.replacePlaceholders(contentMessage, timestamp, secondsString, formatted, reason));
                }
                if (configHandler.getWebhookPremium().getBoolean("messages." + type + ".settings.embed.enabled")) {
                    DiscordWebhook.EmbedObject embed = new DiscordWebhook.EmbedObject();
                    embed.setTitle(WebhookSender.replacePlaceholders(configHandler.getWebhookPremium().getString("messages." + type + ".settings.embed.title"), timestamp, secondsString, formatted, reason)).setDescription(WebhookSender.replacePlaceholders(configHandler.getWebhookPremium().getString("messages." + type + ".settings.embed.description"), timestamp, secondsString, formatted, reason)).setColor(Color.decode(Objects.requireNonNull(configHandler.getWebhookPremium().getString("messages." + type + ".settings.embed.color")))).setThumbnail(configHandler.getWebhookPremium().getString("messages." + type + ".settings.embed.thumbnail"));
                    if (configHandler.getWebhookPremium().getBoolean("messages." + type + ".settings.embed.footer.enabled")) {
                        embed.setFooter(WebhookSender.replacePlaceholders(configHandler.getWebhookPremium().getString("messages." + type + ".settings.embed.footer.message"), timestamp, secondsString, formatted, reason), configHandler.getWebhookPremium().getString("messages." + type + ".settings.embed.footer.image"));
                    }
                    if (configHandler.getWebhookPremium().getBoolean("messages." + type + ".settings.embed.author.enabled")) {
                        embed.setAuthor(WebhookSender.replacePlaceholders(configHandler.getWebhookPremium().getString("messages." + type + ".settings.embed.author.message"), timestamp, secondsString, formatted, reason), configHandler.getWebhookPremium().getString("messages." + type + ".settings.embed.author.link"), configHandler.getWebhookPremium().getString("messages." + type + ".settings.embed.author.image"));
                    }
                    if (configHandler.getWebhookPremium().getBoolean("messages." + type + ".settings.embed.url.enabled")) {
                        embed.setUrl(configHandler.getWebhookPremium().getString("messages." + type + ".settings.embed.url.link"));
                    }
                    if (configHandler.getWebhookPremium().isConfigurationSection("messages." + type + ".settings.embed.fields")) {
                        for (String field : Objects.requireNonNull(configHandler.getWebhookPremium().getConfigurationSection("messages." + type + ".settings.embed.fields")).getKeys(false)) {
                            embed.addField(WebhookSender.replacePlaceholders(configHandler.getWebhookPremium().getString("messages." + type + ".settings.embed.fields." + field + ".title"), timestamp, secondsString, formatted, reason), WebhookSender.replacePlaceholders(configHandler.getWebhookPremium().getString("messages." + type + ".settings.embed.fields." + field + ".description"), timestamp, secondsString, formatted, reason), configHandler.getWebhookPremium().getBoolean("messages." + type + ".settings.embed.fields." + field + ".inline"));
                        }
                    }
                    webhook.addEmbed(embed);
                }
                try {
                    webhook.execute();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                SimpleDateFormat formatter = new SimpleDateFormat(main.getNHandler().getCacheHandler().getWebhookTimestampPlaceholder());
                Date now = new Date();
                String timestamp = formatter.format(now);
                String seconds = Integer.toString(UARAPI.getInterval(main));
                String formatted = main.getNUtils().convertSecondsToFormattedString(main, UARAPI.getInterval(main));
                String reason = UARAPI.getForceRestartReason();
                DiscordWebhook webhook = new DiscordWebhook(main.getNHandler().getConfigurationHandler().getWebhookFile().getString("webhook.url"));
                webhook.setUsername("UltimateAutoRestart");
                webhook.setAvatarUrl("https://i.imgur.com/fWq0CzW.png");
                String contentMessage = main.getNHandler().getConfigurationHandler().getWebhookFile().getString("messages." + type + ".content", "");
                if (!contentMessage.isEmpty()) {
                    webhook.setContent(WebhookSender.replacePlaceholders(contentMessage, timestamp, seconds, formatted, reason));
                }
                webhook.addEmbed(new DiscordWebhook.EmbedObject().setDescription(WebhookSender.replacePlaceholders(contentMessage, timestamp, seconds, formatted, reason)).setThumbnail("https://i.imgur.com/fWq0CzW.png").setAuthor("UltimateAutoRestart", "https://norska.dev/r/spigot/uar/", "https://i.imgur.com/ecamIyC.png"));
                try {
                    webhook.execute();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, 21L);
    }

    private static String replacePlaceholders(String message, String timestamp, String seconds, String formatted, String reason) {
        if (message == null) {
            return "";
        }
        return message.replace("{TIMESTAMP}", timestamp).replace("{SECONDS}", seconds).replace("{FORMATTED}", formatted).replace("{REASON}", reason);
    }
}

