/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.worldborder_common_forge.events;

import com.natamus.collective_common_forge.functions.BlockPosFunctions;
import com.natamus.collective_common_forge.functions.MessageFunctions;
import com.natamus.worldborder_common_forge.config.ConfigHandler;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;

public class BorderEvent {
    private static final HashMap<String, BlockPos> lastplayerpos = new HashMap();

    public static void onPlayerTick(ServerLevel world, ServerPlayer player) {
        int negz;
        int posz;
        int negx;
        int posx;
        if (player.tickCount % 20 != 0) {
            return;
        }
        String dimension = world.dimension().identifier().toString();
        if (dimension.equals("minecraft:overworld")) {
            if (!ConfigHandler.enableCustomOverworldBorder) {
                return;
            }
            posx = ConfigHandler.overworldBorderPositiveX;
            negx = ConfigHandler.overworldBorderNegativeX;
            posz = ConfigHandler.overworldBorderPositiveZ;
            negz = ConfigHandler.overworldBorderNegativeZ;
        } else if (dimension.equals("minecraft:the_nether")) {
            if (!ConfigHandler.enableCustomNetherBorder) {
                return;
            }
            posx = ConfigHandler.netherBorderPositiveX;
            negx = ConfigHandler.netherBorderNegativeX;
            posz = ConfigHandler.netherBorderPositiveZ;
            negz = ConfigHandler.netherBorderNegativeZ;
        } else if (dimension.equals("minecraft:the_end")) {
            if (!ConfigHandler.enableCustomEndBorder) {
                return;
            }
            posx = ConfigHandler.endBorderPositiveX;
            negx = ConfigHandler.endBorderNegativeX;
            posz = ConfigHandler.endBorderPositiveZ;
            negz = ConfigHandler.endBorderNegativeZ;
        } else {
            return;
        }
        BlockPos ppos = player.blockPosition();
        boolean altered = false;
        boolean shouldloop = ConfigHandler.shouldLoopToOppositeBorder;
        int x = ppos.getX();
        int z = ppos.getZ();
        int d = ConfigHandler.distanceTeleportedBack;
        if (x <= negx) {
            x = shouldloop ? posx - d : negx + d;
            altered = true;
        } else if (x >= posx) {
            x = shouldloop ? negx + d : posx - d;
            altered = true;
        }
        if (z <= negz) {
            z = shouldloop ? posz - d : negz + d;
            altered = true;
        } else if (z >= posz) {
            z = shouldloop ? negz + d : posz - d;
            altered = true;
        }
        if (altered) {
            Entity ride;
            BlockPos centerpos = new BlockPos(0, 0, 0);
            BlockPos newpos = BlockPosFunctions.getSurfaceBlockPos((ServerLevel)world, (int)x, (int)z);
            if (newpos.equals((Object)centerpos) && dimension.equals("minecraft:the_nether") || newpos.getY() == 128 && dimension.equals("minecraft:the_nether")) {
                for (BlockPos around : BlockPos.betweenClosed((int)(x - 5), (int)0, (int)(z - 5), (int)(x + 5), (int)128, (int)(z + 5))) {
                    if (!world.getBlockState(around).getBlock().equals(Blocks.AIR) || !world.getBlockState(around.above()).getBlock().equals(Blocks.AIR)) continue;
                    newpos = around.immutable();
                    break;
                }
            }
            if (dimension.equals("minecraft:the_nether")) {
                for (BlockPos checkforlavapos : BlockPos.betweenClosed((int)(newpos.getX() - 1), (int)(newpos.getY() - 1), (int)(newpos.getZ() - 1), (int)(newpos.getX() + 1), (int)(newpos.getY() + 1), (int)(newpos.getZ() + 1))) {
                    if (checkforlavapos.getY() > newpos.getY() - 1) {
                        world.setBlockAndUpdate(checkforlavapos, Blocks.AIR.defaultBlockState());
                        continue;
                    }
                    if (!world.getBlockState(checkforlavapos).getBlock().equals(Blocks.LAVA)) continue;
                    world.setBlockAndUpdate(checkforlavapos, Blocks.OBSIDIAN.defaultBlockState());
                }
            }
            if (newpos.getY() < 0) {
                newpos = newpos.above().immutable();
            }
            if ((ride = player.getVehicle()) != null) {
                ride.ejectPassengers();
                ride.teleportTo((double)newpos.getX(), (double)newpos.getY(), (double)newpos.getZ());
            }
            player.teleportTo((double)newpos.getX(), (double)newpos.getY(), (double)newpos.getZ());
            if (shouldloop) {
                MessageFunctions.sendMessage((Player)player, (String)ConfigHandler.loopBorderMessage, (ChatFormatting)ChatFormatting.DARK_GREEN);
            } else {
                MessageFunctions.sendMessage((Player)player, (String)ConfigHandler.hitBorderMessage, (ChatFormatting)ChatFormatting.RED);
            }
        } else {
            boolean shouldmessage = false;
            if (x < 0) {
                if (negx - x < 0 && negx - x > -d) {
                    shouldmessage = true;
                }
            } else if (posx - x > 0 && posx - x < d) {
                shouldmessage = true;
            }
            if (z < 0) {
                if (negz - z < 0 && negz - z > -d) {
                    shouldmessage = true;
                }
            } else if (posz - z > 0 && posz - z < d) {
                shouldmessage = true;
            }
            if (shouldmessage) {
                String playername = player.getName().getString();
                BlockPos lastpos = ppos.immutable();
                if (lastplayerpos.containsKey(playername)) {
                    lastpos = lastplayerpos.get(playername);
                }
                lastplayerpos.put(playername, ppos.immutable());
                if (lastpos.equals((Object)ppos)) {
                    return;
                }
                MessageFunctions.sendMessage((Player)player, (String)ConfigHandler.nearBorderMessage, (ChatFormatting)ChatFormatting.YELLOW);
            }
        }
    }
}

